/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.graphs.impl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.PlaneAxis;
import org.jzy3d.maths.graphs.IGraph;
import org.jzy3d.picking.PickingSupport;
import org.jzy3d.plot3d.primitives.graphs.impl.DefaultDrawableGraph2d;
import org.jzy3d.plot3d.primitives.pickable.PickableTexture;
import org.jzy3d.plot3d.primitives.textured.DrawableTexture;
import org.jzy3d.plot3d.rendering.textures.SharedTexture;
import org.jzy3d.plot3d.rendering.textures.TextureFactory;
import org.jzy3d.plot3d.rendering.view.Camera;

public class TextureGraph2d<V, E>
extends DefaultDrawableGraph2d<V, E> {
    public static float TEX_MAPPING_WIDTH = 0.25f;
    public static float TEX_MAPPING_HEIGHT = 0.25f;
    protected SharedTexture resource;
    protected Map<V, PickableTexture> vertexTextures = new HashMap<V, PickableTexture>();

    public TextureGraph2d(String nodeMaskFile) {
        this.resource = TextureFactory.get(nodeMaskFile);
        this.labelScreenOffset = new Coord2d(0.0f, 0.0f);
        this.labelSceneOffset = new Coord3d(0.0f, -TEX_MAPPING_HEIGHT / 2.0f, 0.0f);
    }

    @Override
    public void setGraphModel(IGraph<V, E> graph, PickingSupport picking) {
        super.setGraphModel(graph, picking);
        for (V v : graph.getVertices()) {
            PickableTexture t = this.newTexture(v);
            this.vertexTextures.put((PickableTexture)v, t);
            picking.registerDrawableObject(t, v);
        }
    }

    protected PickableTexture newTexture(V vertex) {
        List<Coord2d> mapping = DrawableTexture.getManualTextureMapping(TEX_MAPPING_WIDTH, TEX_MAPPING_HEIGHT);
        PickableTexture texture = new PickableTexture(this.resource, PlaneAxis.Z, Z, mapping, Color.BLACK);
        return texture;
    }

    @Override
    protected void drawVertices(GL gl, GLU glu, Camera cam) {
        for (Object v : this.graph.getVertices()) {
            if (((Boolean)this.highlights.get(v)).booleanValue()) {
                this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getHighlightedVertexColor());
                continue;
            }
            this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getVertexColor());
        }
    }

    @Override
    protected void drawVertexNode(GL gl, GLU glu, Camera cam, V v, Coord2d coord, Color color) {
        PickableTexture t = this.vertexTextures.get(v);
        t.setColorFilter(color);
        t.setPlanePosition(coord);
        t.draw(gl, glu, cam);
    }
}

