/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.layout.AxeBoxLayout;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.log.GlVertexExecutor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class LogAxeBox
extends AxeBox {
    public LogAxeBox(BoundingBox3d bbox, SpaceTransformer transformers) {
        this(bbox, new AxeBoxLayout(), transformers);
    }

    public LogAxeBox(BoundingBox3d bbox, IAxeLayout layout, SpaceTransformer transformers) {
        super(bbox, layout);
        this.spaceTransformer = transformers;
    }

    @Override
    protected void drawCube(GL gl, int mode) {
        for (int q = 0; q < 6; ++q) {
            Coord3d c3d;
            int v;
            if (gl.isGL2()) {
                if (mode == 7169) {
                    gl.getGL2().glPassThrough(q);
                }
                gl.getGL2().glBegin(7);
                for (v = 0; v < 4; ++v) {
                    c3d = new Coord3d(this.quadx[q][v], this.quady[q][v], this.quadz[q][v]);
                    GlVertexExecutor.Vertex(gl, c3d, this.spaceTransformer);
                }
                gl.getGL2().glEnd();
                continue;
            }
            if (mode == 7169) {
                GLES2CompatUtils.glPassThrough(q);
            }
            GLES2CompatUtils.glBegin(7);
            for (v = 0; v < 4; ++v) {
                c3d = new Coord3d(this.quadx[q][v], this.quady[q][v], this.quadz[q][v]);
                GlVertexExecutor.Vertex(gl, c3d, this.spaceTransformer);
            }
            GLES2CompatUtils.glEnd();
        }
    }

    @Override
    protected void drawGridOnQuad(GL gl, int quad) {
        Coord3d c3d;
        int t;
        if (quad != 0 && quad != 1) {
            double[] xticks = this.layout.getXTicks();
            for (t = 0; t < xticks.length; ++t) {
                if (!gl.isGL2()) continue;
                gl.getGL2().glBegin(1);
                c3d = new Coord3d(xticks[t], (double)this.quady[quad][0], (double)this.quadz[quad][0]);
                GlVertexExecutor.Vertex(gl, c3d, this.spaceTransformer);
                c3d = new Coord3d(xticks[t], (double)this.quady[quad][2], (double)this.quadz[quad][2]);
                GlVertexExecutor.Vertex(gl, c3d, this.spaceTransformer);
                gl.getGL2().glEnd();
            }
        }
        if (quad != 2 && quad != 3) {
            double[] yticks = this.layout.getYTicks();
            for (t = 0; t < yticks.length; ++t) {
                if (!gl.isGL2()) continue;
                gl.getGL2().glBegin(1);
                c3d = new Coord3d((double)this.quadx[quad][0], yticks[t], (double)this.quadz[quad][0]);
                GlVertexExecutor.Vertex(gl, c3d, this.spaceTransformer);
                c3d = new Coord3d((double)this.quadx[quad][2], yticks[t], (double)this.quadz[quad][2]);
                GlVertexExecutor.Vertex(gl, c3d, this.spaceTransformer);
                gl.getGL2().glEnd();
            }
        }
        if (quad != 4 && quad != 5) {
            double[] zticks = this.layout.getZTicks();
            for (t = 0; t < zticks.length; ++t) {
                if (!gl.isGL2()) continue;
                gl.getGL2().glBegin(1);
                c3d = new Coord3d((double)this.quadx[quad][0], (double)this.quady[quad][0], zticks[t]);
                GlVertexExecutor.Vertex(gl, c3d, this.spaceTransformer);
                c3d = new Coord3d((double)this.quadx[quad][2], (double)this.quady[quad][2], zticks[t]);
                GlVertexExecutor.Vertex(gl, c3d, this.spaceTransformer);
                gl.getGL2().glEnd();
            }
        }
    }

    @Override
    protected BoundingBox3d drawTicks(GL gl, GLU glu, Camera cam, int axis, int direction, Color color, Halign hal, Valign val) {
        String axeLabel;
        double zlab;
        double ylab;
        double xlab;
        int quad_1;
        int quad_0;
        float tickLength = 20.0f;
        float axeLabelDist = 2.5f;
        BoundingBox3d ticksTxtBounds = new BoundingBox3d();
        if (this.isX(direction)) {
            quad_0 = this.axeXquads[axis][0];
            quad_1 = this.axeXquads[axis][1];
        } else if (this.isY(direction)) {
            quad_0 = this.axeYquads[axis][0];
            quad_1 = this.axeYquads[axis][1];
        } else {
            quad_0 = this.axeZquads[axis][0];
            quad_1 = this.axeZquads[axis][1];
        }
        double xpos = this.spaceTransformer.getX().compute(this.normx[quad_0]) + this.spaceTransformer.getX().compute(this.normx[quad_1]);
        double ypos = this.spaceTransformer.getY().compute(this.normy[quad_0]) + this.spaceTransformer.getY().compute(this.normy[quad_1]);
        double zpos = this.spaceTransformer.getZ().compute(this.normz[quad_0]) + this.spaceTransformer.getZ().compute(this.normz[quad_1]);
        float xdir = this.normx[quad_0] + this.normx[quad_1] - this.center.x;
        float ydir = this.normy[quad_0] + this.normy[quad_1] - this.center.y;
        float zdir = this.normz[quad_0] + this.normz[quad_1] - this.center.z;
        xdir = xdir == 0.0f ? 0.0f : xdir / Math.abs(xdir);
        ydir = ydir == 0.0f ? 0.0f : ydir / Math.abs(ydir);
        zdir = zdir == 0.0f ? 0.0f : zdir / Math.abs(zdir);
        boolean dist = true;
        if (this.isX(direction)) {
            xlab = this.center.x;
            ylab = (double)(axeLabelDist * (this.yrange / tickLength) * (float)dist * ydir) + ypos;
            zlab = (double)(axeLabelDist * (this.zrange / tickLength) * (float)dist * zdir) + zpos;
            axeLabel = this.layout.getXAxeLabel();
        } else if (this.isY(direction)) {
            xlab = (double)(axeLabelDist * (this.xrange / tickLength) * (float)dist * xdir) + xpos;
            ylab = this.center.y;
            zlab = (double)(axeLabelDist * (this.zrange / tickLength) * (float)dist * zdir) + zpos;
            axeLabel = this.layout.getYAxeLabel();
        } else {
            xlab = (double)(axeLabelDist * (this.xrange / tickLength) * (float)dist * xdir) + xpos;
            ylab = (double)(axeLabelDist * (this.yrange / tickLength) * (float)dist * ydir) + ypos;
            zlab = this.center.z;
            axeLabel = this.layout.getZAxeLabel();
        }
        this.drawAxisLabel(gl, glu, cam, direction, color, ticksTxtBounds, xlab, ylab, zlab, axeLabel);
        this.drawAxisTicks(gl, glu, cam, direction, color, hal, val, tickLength, ticksTxtBounds, xpos, ypos, zpos, xdir, ydir, zdir, this.getAxisTicks(direction));
        return ticksTxtBounds;
    }

    @Override
    public void drawAxisTicks(GL gl, GLU glu, Camera cam, int direction, Color color, Halign hal, Valign val, float tickLength, BoundingBox3d ticksTxtBounds, double xpos, double ypos, double zpos, float xdir, float ydir, float zdir, double[] ticks) {
        String tickLabel = "";
        for (int t = 0; t < ticks.length; ++t) {
            double zlab;
            double ylab;
            double xlab;
            if (this.isX(direction)) {
                xlab = xpos = (double)this.spaceTransformer.getX().compute((float)ticks[t]);
                ylab = (double)(Math.signum(tickLength * ydir) * (this.yrange / this.spaceTransformer.getY().compute(Math.abs(tickLength))) * this.spaceTransformer.getY().compute(Math.abs(ydir))) + ypos;
                zlab = (double)(Math.signum(tickLength * ydir) * (this.zrange / this.spaceTransformer.getZ().compute(Math.abs(tickLength))) * this.spaceTransformer.getZ().compute(Math.abs(zdir))) + zpos;
                tickLabel = this.layout.getXTickRenderer().format(xpos);
            } else if (this.isY(direction)) {
                ypos = this.spaceTransformer.getY().compute((float)ticks[t]);
                xlab = (double)(Math.signum(tickLength * xdir) * (this.xrange / this.spaceTransformer.getX().compute(Math.abs(tickLength))) * this.spaceTransformer.getX().compute(Math.abs(xdir))) + xpos;
                ylab = ypos;
                zlab = (double)(Math.signum(tickLength * zdir) * (this.zrange / this.spaceTransformer.getZ().compute(Math.abs(tickLength))) * this.spaceTransformer.getZ().compute(Math.abs(zdir))) + zpos;
                tickLabel = this.layout.getYTickRenderer().format(ypos);
            } else {
                zpos = this.spaceTransformer.getZ().compute((float)ticks[t]);
                xlab = (double)(Math.signum(tickLength * xdir) * (this.xrange / this.spaceTransformer.getX().compute(Math.abs(tickLength))) * this.spaceTransformer.getX().compute(Math.abs(xdir))) + xpos;
                ylab = (double)(Math.signum(tickLength * ydir) * (this.yrange / this.spaceTransformer.getY().compute(Math.abs(tickLength))) * this.spaceTransformer.getY().compute(Math.abs(ydir))) + ypos;
                zlab = zpos;
                tickLabel = this.layout.getZTickRenderer().format(zpos);
            }
            Coord3d tickPosition = new Coord3d(xlab, ylab, zlab);
            if (this.layout.isTickLineDisplayed() && gl.isGL2()) {
                this.drawTickLine(gl, color, xpos, ypos, zpos, xlab, ylab, zlab);
            }
            Halign hAlign = this.layoutHorizontal(direction, cam, hal, tickPosition);
            Valign vAlign = this.layoutVertical(direction, val, zdir);
            this.drawAxisTickNumericLabel(gl, glu, direction, cam, color, hAlign, vAlign, ticksTxtBounds, tickLabel, tickPosition);
        }
    }
}

