/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import java.nio.FloatBuffer;
import org.apache.log4j.Logger;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;

public class FeedbackBufferAxeBox
extends AxeBox
implements IAxe {
    static Logger logger = Logger.getLogger(FeedbackBufferAxeBox.class);

    public FeedbackBufferAxeBox(BoundingBox3d bbox) {
        super(bbox);
    }

    public FeedbackBufferAxeBox(BoundingBox3d bbox, IAxeLayout layout) {
        super(bbox, layout);
    }

    protected boolean[] getHiddenQuads(GL gl) {
        int feedbacklength = 1024;
        FloatBuffer floatbuffer = Buffers.newDirectFloatBuffer(feedbacklength);
        float[] feedback = new float[feedbacklength];
        gl.getGL2().glFeedbackBuffer(feedbacklength, 1538, floatbuffer);
        gl.getGL2().glRenderMode(7169);
        this.drawCube(gl, 7169);
        gl.getGL2().glRenderMode(7168);
        floatbuffer.get(feedback);
        return this.getEmptyTokens(6, feedback, feedbacklength);
    }

    protected boolean[] getEmptyTokens(int ntokens, float[] buffer, int size) {
        boolean[] isempty = new boolean[ntokens];
        boolean printout = false;
        int count = size;
        float prevtoken_type = Float.NaN;
        float passthrough_value = Float.NaN;
        float prevpassthrough_value = Float.NaN;
        float EMPTY_TOKEN = 0.0f;
        while (count > 0) {
            int prevtoken_id;
            float token_type = buffer[size - count];
            --count;
            if (token_type == 1792.0f) {
                passthrough_value = buffer[size - count];
                --count;
                if (printout) {
                    logger.info((Object)("GL.GL_PASS_THROUGH_TOKEN: " + passthrough_value));
                }
                if (!Float.isNaN(prevpassthrough_value)) {
                    prevtoken_id = (int)prevpassthrough_value;
                    isempty[prevtoken_id] = token_type == prevtoken_type;
                }
                prevpassthrough_value = passthrough_value;
            } else if (token_type == 1793.0f) {
                if (printout) {
                    logger.info((Object)" GL.GL_POINT_TOKEN");
                    count = this.print3DcolorVertex(size, count, buffer);
                } else {
                    count -= 7;
                }
            } else if (token_type == 1794.0f) {
                if (printout) {
                    logger.info((Object)" GL.GL_LINE_TOKEN ");
                    count = this.print3DcolorVertex(size, count, buffer);
                    count = this.print3DcolorVertex(size, count, buffer);
                } else {
                    count -= 14;
                }
            } else if (token_type == 1799.0f) {
                if (printout) {
                    logger.info((Object)" GL.GL_LINE_RESET_TOKEN ");
                    count = this.print3DcolorVertex(size, count, buffer);
                    count = this.print3DcolorVertex(size, count, buffer);
                } else {
                    count -= 14;
                }
            } else if (token_type == 1795.0f) {
                int n = (int)buffer[size - count];
                --count;
                if (printout) {
                    logger.info((Object)(" GL.GL_POLYGON_TOKEN: " + n + " vertices"));
                }
                for (int i = 0; i < n; ++i) {
                    if (printout) {
                        count = this.print3DcolorVertex(size, count, buffer);
                        continue;
                    }
                    count -= 7;
                }
            } else {
                if (token_type == EMPTY_TOKEN) {
                    if (prevtoken_type != 1792.0f) break;
                    prevtoken_id = (int)prevpassthrough_value;
                    isempty[prevtoken_id] = true;
                    break;
                }
                if (token_type == 1796.0f) {
                    throw new RuntimeException("Unknown token:" + token_type + ". This function is not intended to work with GL_BITMAP_TOKEN.");
                }
                if (token_type == 1797.0f) {
                    throw new RuntimeException("Unknown token:" + token_type + ". This function is not intended to work with GL_DRAW_PIXEL_TOKEN.");
                }
                if (token_type == 1798.0f) {
                    throw new RuntimeException("Unknown token:" + token_type + ". This function is not intended to work with GL_COPY_PIXEL_TOKEN.");
                }
                throw new RuntimeException("Unknown token type: " + token_type + "\n count= " + count);
            }
            prevtoken_type = token_type;
        }
        return isempty;
    }

    @Override
    protected int print3DcolorVertex(int size, int count, float[] buffer) {
        int id = size - count;
        int veclength = 7;
        System.out.print("  [" + id + "]");
        for (int i = 0; i < veclength; ++i) {
            System.out.print(" " + buffer[size - count]);
            --count;
        }
        System.out.println();
        return count;
    }

    @Override
    protected void printHiddenQuads() {
        for (int t = 0; t < this.quadIsHidden.length; ++t) {
            if (this.quadIsHidden[t]) {
                System.out.println("Quad[" + t + "] is not displayed");
                continue;
            }
            System.out.println("Quad[" + t + "] is displayed");
        }
    }
}

