/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.text.overlay.TextOverlay;

public class AxeBoxWithTxtRenderer
extends AxeBox
implements IAxe {
    protected TextOverlay txtRenderer;

    public AxeBoxWithTxtRenderer(BoundingBox3d bbox, IAxeLayout layout) {
        super(bbox, layout);
    }

    public AxeBoxWithTxtRenderer(BoundingBox3d bbox) {
        super(bbox);
    }

    @Override
    public void dispose() {
        if (this.txtRenderer != null) {
            this.txtRenderer.dispose();
        }
    }

    public TextOverlay getExperimentalTextRenderer() {
        return this.txtRenderer;
    }

    public void setExperimentalTextOverlayRenderer(ICanvas canvas) {
        this.txtRenderer = new TextOverlay(canvas);
    }

    @Override
    protected BoundingBox3d drawTicks(GL gl, GLU glu, Camera cam, int axis, int direction, Color color, Halign hal, Valign val) {
        String axeLabel;
        double zlab;
        double ylab;
        double xlab;
        int quad_1;
        int quad_0;
        float tickLength = 20.0f;
        float axeLabelDist = 2.5f;
        BoundingBox3d ticksTxtBounds = new BoundingBox3d();
        if (direction == 0) {
            quad_0 = this.axeXquads[axis][0];
            quad_1 = this.axeXquads[axis][1];
        } else if (direction == 1) {
            quad_0 = this.axeYquads[axis][0];
            quad_1 = this.axeYquads[axis][1];
        } else {
            quad_0 = this.axeZquads[axis][0];
            quad_1 = this.axeZquads[axis][1];
        }
        double xpos = this.normx[quad_0] + this.normx[quad_1];
        double ypos = this.normy[quad_0] + this.normy[quad_1];
        double zpos = this.normz[quad_0] + this.normz[quad_1];
        float xdir = this.normx[quad_0] + this.normx[quad_1] - this.center.x;
        float ydir = this.normy[quad_0] + this.normy[quad_1] - this.center.y;
        float zdir = this.normz[quad_0] + this.normz[quad_1] - this.center.z;
        xdir = xdir == 0.0f ? 0.0f : xdir / Math.abs(xdir);
        ydir = ydir == 0.0f ? 0.0f : ydir / Math.abs(ydir);
        zdir = zdir == 0.0f ? 0.0f : zdir / Math.abs(zdir);
        boolean dist = true;
        if (direction == 0) {
            xlab = this.center.x;
            ylab = (double)(axeLabelDist * (this.yrange / tickLength) * (float)dist * ydir) + ypos;
            zlab = (double)(axeLabelDist * (this.zrange / tickLength) * (float)dist * zdir) + zpos;
            axeLabel = this.layout.getXAxeLabel();
        } else if (direction == 1) {
            xlab = (double)(axeLabelDist * (this.xrange / tickLength) * (float)dist * xdir) + xpos;
            ylab = this.center.y;
            zlab = (double)(axeLabelDist * (this.zrange / tickLength) * (float)dist * zdir) + zpos;
            axeLabel = this.layout.getYAxeLabel();
        } else {
            xlab = (double)(axeLabelDist * (this.xrange / tickLength) * (float)dist * xdir) + xpos;
            ylab = (double)(axeLabelDist * (this.yrange / tickLength) * (float)dist * ydir) + ypos;
            zlab = this.center.z;
            axeLabel = this.layout.getZAxeLabel();
        }
        if (direction == 0 && this.layout.isXAxeLabelDisplayed() || direction == 1 && this.layout.isYAxeLabelDisplayed() || direction == 2 && this.layout.isZAxeLabelDisplayed()) {
            Coord3d labelPosition = new Coord3d(xlab, ylab, zlab);
            if (this.txtRenderer != null) {
                this.txtRenderer.appendText(gl, glu, cam, axeLabel, labelPosition, Halign.CENTER, Valign.CENTER, color);
            } else {
                BoundingBox3d labelBounds = this.txt.drawText(gl, glu, cam, axeLabel, labelPosition, Halign.CENTER, Valign.CENTER, color, 0);
                if (labelBounds != null) {
                    ticksTxtBounds.add(labelBounds);
                }
            }
        }
        double[] ticks = direction == 0 ? this.layout.getXTicks() : (direction == 1 ? this.layout.getYTicks() : this.layout.getZTicks());
        String tickLabel = "";
        for (int t = 0; t < ticks.length; ++t) {
            if (direction == 0) {
                xlab = xpos = ticks[t];
                ylab = (double)(this.yrange / tickLength * ydir) + ypos;
                zlab = (double)(this.zrange / tickLength * zdir) + zpos;
                tickLabel = this.layout.getXTickRenderer().format(xpos);
            } else if (direction == 1) {
                ypos = ticks[t];
                xlab = (double)(this.xrange / tickLength * xdir) + xpos;
                ylab = ypos;
                zlab = (double)(this.zrange / tickLength * zdir) + zpos;
                tickLabel = this.layout.getYTickRenderer().format(ypos);
            } else {
                zpos = ticks[t];
                xlab = (double)(this.xrange / tickLength * xdir) + xpos;
                ylab = (double)(this.yrange / tickLength * ydir) + ypos;
                zlab = zpos;
                tickLabel = this.layout.getZTickRenderer().format(zpos);
            }
            Coord3d tickPosition = new Coord3d(xlab, ylab, zlab);
            if (gl.isGL2()) {
                gl.getGL2().glColor3f(color.r, color.g, color.b);
                gl.getGL2().glLineWidth(1.0f);
                gl.getGL2().glBegin(1);
                gl.getGL2().glVertex3d(xpos, ypos, zpos);
                gl.getGL2().glVertex3d(xlab, ylab, zlab);
                gl.getGL2().glEnd();
            }
            Halign hAlign = hal == null ? (cam.side(tickPosition) ? Halign.LEFT : Halign.RIGHT) : hal;
            Valign vAlign = val == null ? (direction == 2 ? Valign.CENTER : (zdir > 0.0f ? Valign.TOP : Valign.BOTTOM)) : val;
            if (this.txtRenderer != null) {
                this.txtRenderer.appendText(gl, glu, cam, tickLabel, tickPosition, hAlign, vAlign, color);
                continue;
            }
            BoundingBox3d tickBounds = this.txt.drawText(gl, glu, cam, tickLabel, tickPosition, hAlign, vAlign, color, 0);
            if (tickBounds == null) continue;
            ticksTxtBounds.add(tickBounds);
        }
        return ticksTxtBounds;
    }
}

