/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class Sphere
extends AbstractWireframeable
implements ISingleColorable {
    protected Coord3d position;
    protected float radius;
    protected int slices;
    protected int stacks;
    protected Color color;
    protected static GLUT glut = new GLUT();

    public Sphere() {
        this.bbox = new BoundingBox3d();
        this.setPosition(Coord3d.ORIGIN);
        this.setVolume(10.0f);
        this.setSlicing(15, 15);
        this.setColor(Color.BLACK);
    }

    public Sphere(Coord3d position, float radius, int slicing, Color color) {
        this.bbox = new BoundingBox3d();
        this.setPosition(position);
        this.setVolume(radius);
        this.setSlicing(slicing, slicing);
        this.setColor(color);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            gl.getGL2().glTranslatef(this.position.x, this.position.y, this.position.z);
            if (this.facestatus) {
                gl.getGL2().glPolygonMode(1032, 6914);
                gl.getGL2().glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
                glut.glutSolidSphere(this.radius, this.slices, this.stacks);
            }
            if (this.wfstatus) {
                gl.getGL2().glPolygonMode(1032, 6913);
                gl.getGL2().glLineWidth(this.wfwidth);
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                glut.glutSolidSphere(this.radius, this.slices, this.stacks);
            }
        } else {
            GLES2CompatUtils.glTranslatef(this.position.x, this.position.y, this.position.z);
            if (this.facestatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6914);
                GLES2CompatUtils.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
                glut.glutSolidSphere(this.radius, this.slices, this.stacks);
            }
            if (this.wfstatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6913);
                GLES2CompatUtils.glLineWidth(this.wfwidth);
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                glut.glutSolidSphere(this.radius, this.slices, this.stacks);
            }
        }
        this.doDrawBounds(gl, glu, cam);
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        this.position.set(transform.compute(this.position));
        this.updateBounds();
    }

    public void setData(Coord3d position, float radius, float height, int slices, int stacks) {
        this.setPosition(position);
        this.setVolume(radius);
        this.setSlicing(slices, stacks);
    }

    public void setPosition(Coord3d position) {
        this.position = position;
        this.updateBounds();
    }

    public Coord3d getPosition() {
        return this.position;
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        this.bbox.add(this.position.x + this.radius, this.position.y + this.radius, this.position.z + this.radius);
        this.bbox.add(this.position.x - this.radius, this.position.y - this.radius, this.position.z - this.radius);
    }

    public void setVolume(float radius) {
        this.radius = radius;
        this.updateBounds();
    }

    public void setSlicing(int verticalWires, int horizontalWires) {
        this.slices = verticalWires;
        this.stacks = horizontalWires;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String toString(int depth) {
        return Utils.blanks(depth) + "(Sphere) x=" + this.position.x + " y=" + this.position.y + " z=" + this.position.z + " r=" + this.color.r + " g=" + this.color.g + " b=" + this.color.b + " a=" + this.color.a;
    }
}

