/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.algorithms.interpolation.IInterpolator;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;

public class LineStripInterpolated
extends AbstractComposite {
    protected LineStrip line;
    protected List<Point> controlPoints;
    protected List<Point> interpolatedPoints;
    protected List<Coord3d> controlCoords;
    protected List<Coord3d> interpolatedCoords;
    protected int resolution;

    protected LineStripInterpolated() {
    }

    public LineStripInterpolated(IInterpolator interpolator, List<Coord3d> controlPoints, int resolution) {
        this.controlCoords = controlPoints;
        this.resolution = resolution;
        this.interpolatedCoords = interpolator.interpolate(controlPoints, resolution);
        this.interpolatedPoints = this.toPoints(this.interpolatedCoords, Color.BLUE, 3.0f);
        this.controlPoints = this.toPoints(this.controlCoords, Color.RED, 5.0f);
        this.line = new LineStrip(this.interpolatedCoords);
        this.line.setWireframeColor(Color.BLACK);
        this.add(this.line);
        this.add(this.controlPoints);
        this.add(this.interpolatedPoints);
    }

    protected Point toPoint(Coord3d coord, Color color, float width) {
        return new Point(coord, color, width);
    }

    protected List<Point> toPoints(List<Coord3d> coords, Color color, float width) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Coord3d coord : coords) {
            points.add(this.toPoint(coord, color, width));
        }
        return points;
    }

    public LineStrip getLine() {
        return this.line;
    }

    public List<Point> getControlPoints() {
        return this.controlPoints;
    }

    public List<Point> getInterpolatedPoints() {
        return this.interpolatedPoints;
    }

    public List<Coord3d> getControlCoords() {
        return this.controlCoords;
    }

    public List<Coord3d> getInterpolatedCoords() {
        return this.interpolatedCoords;
    }

    public int getResolution() {
        return this.resolution;
    }
}

