/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.LightPoint;
import org.jzy3d.plot3d.primitives.ScatterPoint;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.Transform;

public class ConcurrentScatterPoint
extends ScatterPoint {
    public ConcurrentScatterPoint() {
    }

    public ConcurrentScatterPoint(List<LightPoint> points, float width) {
        super(points, width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.points != null) {
            List list = this.points;
            synchronized (list) {
                for (LightPoint p : this.points) {
                    GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                    GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                }
            }
        }
        GLES2CompatUtils.glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.points != null) {
            List list = this.points;
            synchronized (list) {
                for (LightPoint p : this.points) {
                    gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                    gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
                }
            }
        }
        gl.getGL2().glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyGeometryTransform(Transform transform) {
        List list = this.points;
        synchronized (list) {
            for (LightPoint p : this.points) {
                Coord3d c = p.xyz;
                c.set(transform.compute(c));
            }
        }
        this.updateBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(LightPoint point) {
        List list = this.points;
        synchronized (list) {
            this.points.add(point);
        }
        this.updateBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBounds() {
        this.bbox.reset();
        List list = this.points;
        synchronized (list) {
            for (LightPoint c : this.points) {
                this.bbox.add(c.xyz);
            }
        }
    }
}

