/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.ScatterMultiColor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.Transform;

public class ConcurrentScatterMultiColor
extends ScatterMultiColor
implements IMultiColorable {
    public ConcurrentScatterMultiColor(Coord3d[] coordinates, Color[] colors, ColorMapper mapper) {
        this(coordinates, colors, mapper, 1.0f);
    }

    public ConcurrentScatterMultiColor(Coord3d[] coordinates, ColorMapper mapper) {
        this(coordinates, null, mapper, 1.0f);
    }

    public ConcurrentScatterMultiColor(Coord3d[] coordinates, Color[] colors, ColorMapper mapper, float width) {
        super(coordinates, colors, mapper, width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.coordinates != null) {
            Coord3d[] coord3dArray = this.coordinates;
            // MONITORENTER : this.coordinates
            for (Coord3d coord : this.coordinates) {
                Color color = this.mapper.getColor(coord);
                GLES2CompatUtils.glColor4f(color.r, color.g, color.b, color.a);
                GLES2CompatUtils.glVertex3f(coord.x, coord.y, coord.z);
            }
            // MONITOREXIT : coord3dArray
        }
        GLES2CompatUtils.glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.coordinates != null) {
            Coord3d[] coord3dArray = this.coordinates;
            // MONITORENTER : this.coordinates
            for (Coord3d coord : this.coordinates) {
                Color color = this.mapper.getColor(coord);
                gl.getGL2().glColor4f(color.r, color.g, color.b, color.a);
                gl.getGL2().glVertex3f(coord.x, coord.y, coord.z);
            }
            // MONITOREXIT : coord3dArray
        }
        gl.getGL2().glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyGeometryTransform(Transform transform) {
        Coord3d[] coord3dArray = this.coordinates;
        synchronized (this.coordinates) {
            for (Coord3d c : this.coordinates) {
                c.set(transform.compute(c));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.updateBounds();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBounds() {
        this.bbox.reset();
        Coord3d[] coord3dArray = this.coordinates;
        synchronized (this.coordinates) {
            for (Coord3d c : this.coordinates) {
                this.bbox.add(c);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

