/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public abstract class AbstractGeometry
extends AbstractWireframeable
implements ISingleColorable,
IMultiColorable {
    protected PolygonMode polygonMode;
    protected boolean polygonOffsetFillEnable = true;
    protected ColorMapper mapper;
    protected List<Point> points = new ArrayList<Point>(4);
    protected Color color;
    protected Coord3d center;

    public AbstractGeometry() {
        this.bbox = new BoundingBox3d();
        this.center = new Coord3d();
        this.polygonOffsetFillEnable = true;
        this.polygonMode = PolygonMode.FRONT_AND_BACK;
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (this.mapper != null) {
            this.mapper.preDraw(this);
        }
        if (this.facestatus) {
            this.applyPolygonModeFill(gl);
            if (this.wfstatus && this.polygonOffsetFillEnable) {
                this.polygonOffseFillEnable(gl);
            }
            this.callPointsForFace(gl);
            if (this.wfstatus && this.polygonOffsetFillEnable) {
                this.polygonOffsetFillDisable(gl);
            }
        }
        if (this.wfstatus) {
            this.applyPolygonModeLine(gl);
            if (this.polygonOffsetFillEnable) {
                this.polygonOffseFillEnable(gl);
            }
            this.callPointForWireframe(gl);
            if (this.polygonOffsetFillEnable) {
                this.polygonOffsetFillDisable(gl);
            }
        }
        if (this.mapper != null) {
            this.mapper.postDraw(this);
        }
        this.doDrawBounds(gl, glu, cam);
    }

    protected void callPointForWireframe(GL gl) {
        if (gl.isGL2()) {
            this.callPointsForWireframeGL2(gl);
        }
    }

    public void callPointsForWireframeGL2(GL gl) {
        this.colorGL2(gl, this.wfcolor);
        gl.glLineWidth(this.wfwidth);
        this.begin(gl);
        for (Point p : this.points) {
            this.vertexGL2(gl, p.xyz);
        }
        this.end(gl);
    }

    protected void callPointsForFace(GL gl) {
        if (gl.isGL2()) {
            this.callPointsForFaceGL2(gl);
        } else {
            this.callPointsForFaceGLES2(gl);
        }
    }

    public void callPointsForFaceGLES2(GL gl) {
        this.callPointsForFaceGLES2(gl, this.points);
    }

    public void callPointsForFaceGLES2(GL gl, List<Point> points) {
        this.begin(gl);
        for (Point p : points) {
            if (this.mapper != null) {
                Color c = this.mapper.getColor(p.xyz);
                this.colorGLES2(c);
            } else {
                this.colorGLES2(p.rgb);
            }
            this.vertexGLES2(p.xyz);
        }
        this.end(gl);
    }

    public void callPointsForFaceGL2(GL gl) {
        this.begin(gl);
        for (Point p : this.points) {
            if (this.mapper != null) {
                Color c = this.mapper.getColor(p.xyz);
                this.colorGL2(gl, c);
            } else {
                this.colorGL2(gl, p.rgb);
            }
            this.vertexGL2(gl, p.xyz);
        }
        this.end(gl);
    }

    protected abstract void begin(GL var1);

    protected void end(GL gl) {
        if (gl.isGL2()) {
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glEnd();
        }
    }

    protected void applyPolygonModeLine(GL gl) {
        if (gl.isGL2()) {
            this.applyPolygonModeLineGL2(gl);
        } else {
            this.applyPolygonModeLineGLES2();
        }
    }

    protected void applyPolygonModeLineGLES2() {
        switch (this.polygonMode) {
            case FRONT: {
                GLES2CompatUtils.glPolygonMode(1028, 6913);
                break;
            }
            case BACK: {
                GLES2CompatUtils.glPolygonMode(1029, 6913);
                break;
            }
            case FRONT_AND_BACK: {
                GLES2CompatUtils.glPolygonMode(1032, 6913);
                break;
            }
        }
    }

    protected void applyPolygonModeLineGL2(GL gl) {
        switch (this.polygonMode) {
            case FRONT: {
                gl.getGL2().glPolygonMode(1028, 6913);
                break;
            }
            case BACK: {
                gl.getGL2().glPolygonMode(1029, 6913);
                break;
            }
            case FRONT_AND_BACK: {
                gl.getGL2().glPolygonMode(1032, 6913);
                break;
            }
        }
    }

    protected void applyPolygonModeFill(GL gl) {
        if (gl.isGL2()) {
            this.applyPolygonModeFillGL2(gl);
        } else {
            this.applyPolygonModeFillGLES2();
        }
    }

    public void applyPolygonModeFillGLES2() {
        switch (this.polygonMode) {
            case FRONT: {
                GLES2CompatUtils.glPolygonMode(1028, 6914);
                break;
            }
            case BACK: {
                GLES2CompatUtils.glPolygonMode(1029, 6914);
                break;
            }
            case FRONT_AND_BACK: {
                GLES2CompatUtils.glPolygonMode(1032, 6914);
                break;
            }
        }
    }

    public void applyPolygonModeFillGL2(GL gl) {
        switch (this.polygonMode) {
            case FRONT: {
                gl.getGL2().glPolygonMode(1028, 6914);
                break;
            }
            case BACK: {
                gl.getGL2().glPolygonMode(1029, 6914);
                break;
            }
            case FRONT_AND_BACK: {
                gl.getGL2().glPolygonMode(1032, 6914);
                break;
            }
        }
    }

    protected void polygonOffseFillEnable(GL gl) {
        gl.glEnable(32823);
        gl.glPolygonOffset(1.0f, 1.0f);
    }

    protected void polygonOffsetFillDisable(GL gl) {
        gl.glDisable(32823);
    }

    public void add(Point point) {
        this.add(point, true);
    }

    public void add(Point point, boolean updateBounds) {
        this.points.add(point);
        if (updateBounds) {
            this.updateBounds();
        }
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        for (Point p : this.points) {
            p.xyz = transform.compute(p.xyz);
        }
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        this.bbox.add(this.getPoints());
        this.center = new Coord3d();
        for (Point p : this.points) {
            this.center = this.center.add(p.xyz);
        }
        this.center = this.center.div(this.points.size());
    }

    @Override
    public Coord3d getBarycentre() {
        return this.center;
    }

    public Point get(int p) {
        return this.points.get(p);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public int size() {
        return this.points.size();
    }

    @Override
    public double getDistance(Camera camera) {
        return this.getBarycentre().distance(camera.getEye());
    }

    @Override
    public double getShortestDistance(Camera camera) {
        double min = 3.4028234663852886E38;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist < min)) continue;
            min = dist;
        }
        dist = this.getBarycentre().distance(camera.getEye());
        if (dist < min) {
            min = dist;
        }
        return min;
    }

    @Override
    public double getLongestDistance(Camera camera) {
        double max = 0.0;
        double dist = 0.0;
        for (Point point : this.points) {
            dist = point.getDistance(camera);
            if (!(dist > max)) continue;
            max = dist;
        }
        return max;
    }

    public PolygonMode getPolygonMode() {
        return this.polygonMode;
    }

    public void setPolygonMode(PolygonMode polygonMode) {
        this.polygonMode = polygonMode;
    }

    public boolean isPolygonOffsetFillEnable() {
        return this.polygonOffsetFillEnable;
    }

    public void setPolygonOffsetFillEnable(boolean polygonOffsetFillEnable) {
        this.polygonOffsetFillEnable = polygonOffsetFillEnable;
    }

    public static void setPolygonOffsetFillEnable(AbstractComposite composite, boolean polygonOffsetFillEnable) {
        for (AbstractDrawable d : composite.getDrawables()) {
            if (d instanceof AbstractGeometry) {
                ((AbstractGeometry)d).setPolygonOffsetFillEnable(polygonOffsetFillEnable);
                continue;
            }
            if (!(d instanceof AbstractComposite)) continue;
            AbstractGeometry.setPolygonOffsetFillEnable((AbstractComposite)d, polygonOffsetFillEnable);
        }
    }

    @Override
    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (Point p : this.points) {
            p.setColor(color);
        }
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String toString(int depth) {
        return Utils.blanks(depth) + "(" + this.getClass().getSimpleName() + ") #points:" + this.points.size();
    }

    public static enum PolygonMode {
        FRONT,
        BACK,
        FRONT_AND_BACK;

    }
}

