/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.picking;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.maths.TicToc;
import org.jzy3d.picking.IObjectPickedListener;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.pickable.Pickable;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.modes.CameraMode;
import org.jzy3d.plot3d.transform.Scale;
import org.jzy3d.plot3d.transform.Transform;

public class PickingSupport {
    protected TicToc perf = new TicToc();
    protected static int method = 0;
    protected static int pickId = 0;
    protected Map<Integer, Pickable> pickables = new HashMap<Integer, Pickable>();
    protected List<IObjectPickedListener> verticesListener = new ArrayList<IObjectPickedListener>(1);
    protected Map<Pickable, Object> pickableTargets = new HashMap<Pickable, Object>();
    protected int brushSize;
    protected int bufferSize;

    public PickingSupport() {
        this(10);
    }

    public PickingSupport(int brushSize) {
        this(brushSize, 2048);
    }

    public PickingSupport(int brushSize, int bufferSize) {
        this.brushSize = brushSize;
        this.bufferSize = bufferSize;
    }

    public boolean addObjectPickedListener(IObjectPickedListener listener) {
        return this.verticesListener.add(listener);
    }

    public boolean removeObjectPickedListener(IObjectPickedListener listener) {
        return this.verticesListener.remove(listener);
    }

    protected void fireObjectPicked(List<? extends Object> v) {
        for (IObjectPickedListener listener : this.verticesListener) {
            listener.objectPicked(v, this);
        }
    }

    public void registerDrawableObject(AbstractDrawable drawable, Object model) {
        if (drawable instanceof Pickable) {
            this.registerPickableObject((Pickable)((Object)drawable), model);
        }
    }

    public synchronized void registerPickableObject(Pickable pickable, Object model) {
        pickable.setPickingId(pickId++);
        this.pickables.put(pickable.getPickingId(), pickable);
        this.pickableTargets.put(pickable, model);
    }

    public synchronized void getPickableObject(int id) {
        this.pickables.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickObjects(GL gl, GLU glu, View view, Graph graph, IntegerCoord2d pickPoint) {
        this.perf.tic();
        int[] viewport = new int[4];
        int[] selectBuf = new int[this.bufferSize];
        IntBuffer selectBuffer = Buffers.newDirectIntBuffer(this.bufferSize);
        if (!gl.isGL2()) {
            throw new UnsupportedOperationException();
        }
        gl.getGL2().glGetIntegerv(2978, viewport, 0);
        gl.getGL2().glSelectBuffer(this.bufferSize, selectBuffer);
        gl.getGL2().glRenderMode(7170);
        gl.getGL2().glInitNames();
        gl.getGL2().glPushName(0);
        Camera camera = view.getCamera();
        CameraMode cMode = view.getCameraMode();
        Coord3d viewScaling = view.getLastViewScaling();
        Transform viewTransform = new Transform(new Scale(viewScaling));
        double xpick = pickPoint.x;
        double ypick = pickPoint.y;
        gl.getGL2().glMatrixMode(5889);
        gl.getGL2().glPushMatrix();
        gl.getGL2().glLoadIdentity();
        glu.gluPickMatrix(xpick, ypick, (double)this.brushSize, (double)this.brushSize, viewport, 0);
        camera.doShoot(gl, glu, cMode);
        gl.getGL2().glMatrixMode(5888);
        PickingSupport pickingSupport = this;
        synchronized (pickingSupport) {
            for (Pickable pickable : this.pickables.values()) {
                this.setCurrentName(gl, pickable);
                pickable.setTransform(viewTransform);
                pickable.draw(gl, glu, camera);
                this.releaseCurrentName(gl);
            }
        }
        gl.getGL2().glMatrixMode(5889);
        gl.getGL2().glPopMatrix();
        gl.glFlush();
        int hits = gl.getGL2().glRenderMode(7168);
        selectBuffer.get(selectBuf);
        List<Pickable> picked = this.processHits(hits, selectBuf);
        ArrayList<Object> clickedObjects = new ArrayList<Object>(hits);
        for (Pickable pickable : picked) {
            Object vertex = this.pickableTargets.get(pickable);
            clickedObjects.add(vertex);
        }
        this.perf.toc();
        this.fireObjectPicked(clickedObjects);
    }

    public double getLastPickPerfMs() {
        return this.perf.elapsedMilisecond();
    }

    protected void setCurrentName(GL gl, Pickable pickable) {
        if (method == 0) {
            gl.getGL2().glLoadName(pickable.getPickingId());
        } else {
            gl.getGL2().glPushName(pickable.getPickingId());
        }
    }

    protected void releaseCurrentName(GL gl) {
        if (method != 0) {
            gl.getGL2().glPopName();
        }
    }

    protected List<Pickable> processHits(int hits, int[] buffer) {
        int ptr = 0;
        int z2 = 0;
        ArrayList<Pickable> picked = new ArrayList<Pickable>();
        for (int i = 0; i < hits; ++i) {
            int names = buffer[ptr];
            int z1 = buffer[++ptr];
            z2 = buffer[++ptr];
            ++ptr;
            for (int j = 0; j < names; ++j) {
                int idj = buffer[ptr];
                ++ptr;
                if (!this.pickables.containsKey(idj)) {
                    throw new RuntimeException("internal error: pickable id not found in registry!");
                }
                picked.add(this.pickables.get(idj));
            }
        }
        return picked;
    }

    public synchronized void unRegisterAllPickableObjects() {
        this.pickables.clear();
        this.pickableTargets.clear();
    }
}

