/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths.algorithms.convexhull.algorithms;

import org.jzy3d.maths.Coord2d;

public class Converter {
    private int ww;
    private int hh;
    private double w;
    private double h;

    public Converter(int screen_w, int screen_h, double world_w, double world_h) {
        this.ww = screen_w;
        this.hh = screen_h;
        this.h = world_h;
        this.w = world_w;
    }

    public Coord2d to(Coord2d p) {
        double x = (double)(p.getX() * 2.0f / (float)this.ww) * this.w - this.w;
        double y = (double)(-p.getY() * 2.0f / (float)this.hh) * this.h + this.h;
        return new Coord2d(x, y);
    }

    public Coord2d from(Coord2d p) {
        int x = (int)((double)(this.ww / 2) + (double)p.getX() / this.w * (double)this.ww / 2.0);
        int y = (int)((double)(this.hh / 2) - (double)p.getY() / this.h * (double)this.hh / 2.0);
        return new Coord2d(x, y);
    }
}

