/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import org.jzy3d.maths.Coord3d;

public class Vector3d {
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private float z1;
    private float z2;

    public Vector3d(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.z1 = z1;
        this.z2 = z2;
    }

    public Vector3d(Coord3d p1, Coord3d p2) {
        this.x1 = p1.x;
        this.x2 = p2.x;
        this.y1 = p1.y;
        this.y2 = p2.y;
        this.z1 = p1.z;
        this.z2 = p2.z;
    }

    public Coord3d vector() {
        return new Coord3d(this.x2 - this.x1, this.y2 - this.y1, this.z2 - this.z1);
    }

    public float dot(Vector3d v) {
        Coord3d v1 = this.vector();
        Coord3d v2 = v.vector();
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public Coord3d cross(Vector3d v) {
        Coord3d v1 = this.vector();
        Coord3d v2 = v.vector();
        Coord3d v3 = new Coord3d();
        v3.x = v1.y * v2.z - v1.z * v2.y;
        v3.y = v1.z * v2.x - v1.x * v2.z;
        v3.z = v1.x * v2.y - v1.y * v2.x;
        return v3;
    }

    public float norm() {
        return (float)Math.sqrt(Math.pow(this.x2 - this.x1, 2.0) + Math.pow(this.y2 - this.y1, 2.0) + Math.pow(this.z2 - this.z1, 2.0));
    }

    public double distance(Coord3d c) {
        return this.getCenter().distance(c);
    }

    public Coord3d getCenter() {
        float cx = (this.x1 + this.x2) / 2.0f;
        float cy = (this.y1 + this.y2) / 2.0f;
        float cz = (this.z1 + this.z2) / 2.0f;
        return new Coord3d(cx, cy, cz);
    }
}

