/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.demos.vbo.scatter;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Range;

public class ScatterGenerator {
    public static List<Coord3d> getScatter(int size) {
        ArrayList<Coord3d> coords = new ArrayList<Coord3d>(size);
        Random r = new Random();
        r.setSeed(0L);
        for (int i = 0; i < size; ++i) {
            double x = 2.0 * r.nextDouble();
            double y = 2.0 * r.nextDouble();
            double s = r.nextDouble();
            if (s > 0.75) {
                x *= -1.0;
                y *= -1.0;
            }
            if (s > 0.5 && s <= 0.75) {
                x *= -1.0;
            }
            if (s > 0.25 && s <= 0.5) {
                y *= -1.0;
            }
            double f1 = Math.cos(2.0 * (x * x + y * y));
            double f2 = Math.cos(x / 4.0) * Math.sin(y);
            double f3 = x * x + y * y;
            double z = Math.pow(Math.E, -f3) * f2 * f1;
            coords.add(new Coord3d(x, y, z));
        }
        return coords;
    }

    public static ColorMapper coloring(List<Coord3d> coords) {
        Range zrange = Coord3d.getZRange(coords);
        ColorMapper coloring = new ColorMapper(new ColorMapRainbow(), zrange.getMin(), zrange.getMax(), new Color(1.0f, 1.0f, 1.0f, 0.5f));
        return coloring;
    }
}

