/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.demos.drawing.vbo.barmodel.builder;

import com.jogamp.opengl.GL;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.demos.drawing.vbo.barmodel.color.KeyRankColorMapper;
import org.jzy3d.io.KeyVal;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.vbo.buffers.FloatVBO;
import org.jzy3d.plot3d.primitives.vbo.builders.VBOBuilder;
import org.jzy3d.plot3d.primitives.vbo.drawable.DrawableVBO;

public class VBOBuilderTableColumnsScatter3d
extends VBOBuilder {
    List<List<KeyVal<String, Float>>> rows;

    public VBOBuilderTableColumnsScatter3d(List<List<KeyVal<String, Float>>> rows) {
        this.rows = rows;
    }

    @Override
    public void load(GL gl, DrawableVBO drawable) throws Exception {
        this.preConfigureDrawable(drawable);
        FloatVBO vbo = this.initFloatVBO(drawable, true, this.countKv(this.rows));
        this.fill(this.rows, vbo);
        drawable.setData(gl, vbo);
    }

    private void preConfigureDrawable(DrawableVBO drawable) {
        drawable.setGeometry(0);
        drawable.setHasColorBuffer(true);
        drawable.setWidth(1.0f);
    }

    protected int countKv(List<List<KeyVal<String, Float>>> rows) {
        int n = 0;
        for (int i = 0; i < rows.size(); ++i) {
            List<KeyVal<String, Float>> row = rows.get(i);
            for (int j = 0; j < row.size(); ++j) {
                ++n;
            }
        }
        return n;
    }

    protected void fill(List<List<KeyVal<String, Float>>> rows, FloatVBO vbo) {
        int size = 0;
        KeyRankColorMapper coloring = new KeyRankColorMapper(rows, new ColorMapRainbow());
        for (int i = 0; i < rows.size(); ++i) {
            List row = rows.get(i);
            for (int j = 0; j < row.size(); ++j) {
                KeyVal k = row.get(j);
                Color color = coloring.getColor(k);
                Coord3d c1 = new Coord3d(i, j, ((Float)k.val).floatValue());
                this.putPoint(vbo, size++, color, c1);
            }
        }
        vbo.getVertices().rewind();
        vbo.getIndices().rewind();
    }
}

