/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse.camera;

import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.mouse.NewtMouseUtilities;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.maths.Coord2d;

public class NewtCameraMouseController
extends AbstractCameraController
implements MouseListener {
    public NewtCameraMouseController() {
    }

    public NewtCameraMouseController(Chart chart) {
        this.register(chart);
        this.addSlaveThreadController(new CameraThreadController(chart));
    }

    @Override
    public void register(Chart chart) {
        super.register(chart);
        chart.getCanvas().addMouseController(this);
    }

    @Override
    public void dispose() {
        for (Chart c : this.targets) {
            c.getCanvas().removeMouseController(this);
        }
        super.dispose();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.handleSlaveThread(e)) {
            return;
        }
        this.prevMouse.x = e.getX();
        this.prevMouse.y = e.getY();
    }

    public boolean handleSlaveThread(MouseEvent e) {
        if (NewtCameraMouseController.isDoubleClick(e) && this.threadController != null) {
            this.threadController.start();
            return true;
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Coord2d mouse = new Coord2d(e.getX(), e.getY());
        if (NewtCameraMouseController.isLeftDown(e)) {
            Coord2d move = mouse.sub(this.prevMouse).div(100.0f);
            this.rotate(move);
        } else if (NewtCameraMouseController.isRightDown(e)) {
            Coord2d move = mouse.sub(this.prevMouse);
            if (move.y != 0.0f) {
                this.shift(move.y / 500.0f);
            }
        }
        this.prevMouse = mouse;
    }

    public static boolean isLeftDown(MouseEvent e) {
        return (e.getModifiers() & 0x20) == 32;
    }

    public static boolean isRightDown(MouseEvent e) {
        return (e.getModifiers() & 0x80) == 128;
    }

    public static boolean isDoubleClick(MouseEvent e) {
        return e.getClickCount() > 1;
    }

    @Override
    public void mouseWheelMoved(MouseEvent e) {
        this.stopThreadController();
        float factor = NewtMouseUtilities.convertWheelRotation(e, 1.0f, 10.0f);
        this.zoomZ(factor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

