/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.camera;

import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.AbstractController;
import org.jzy3d.chart.controllers.ControllerType;
import org.jzy3d.chart.controllers.mouse.camera.ICameraMouseController;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.maths.Coord2d;

public abstract class AbstractCameraController
extends AbstractController
implements ICameraMouseController {
    public static boolean DEFAULT_UPDATE_VIEW = false;
    protected CameraThreadController threadController;
    protected Coord2d prevMouse = Coord2d.ORIGIN;

    public AbstractCameraController() {
    }

    public AbstractCameraController(Chart chart) {
        super(chart);
    }

    @Override
    public void dispose() {
        if (this.threadController != null) {
            this.threadController.stop();
        }
        super.dispose();
    }

    protected void rotate(Coord2d move) {
        this.rotate(move, DEFAULT_UPDATE_VIEW);
    }

    protected void rotate(Coord2d move, boolean updateView) {
        for (Chart c : this.targets) {
            c.getView().rotate(move, updateView);
        }
        this.fireControllerEvent(ControllerType.ROTATE, move);
    }

    protected void shift(float factor) {
        this.shift(factor, DEFAULT_UPDATE_VIEW);
    }

    protected void shift(float factor, boolean updateView) {
        for (Chart c : this.targets) {
            c.getView().shift(factor, updateView);
        }
        this.fireControllerEvent(ControllerType.SHIFT, Float.valueOf(factor));
    }

    protected void zoomX(float factor) {
        this.zoomX(factor, DEFAULT_UPDATE_VIEW);
    }

    protected void zoomX(float factor, boolean updateView) {
        for (Chart c : this.targets) {
            c.getView().zoomX(factor, updateView);
        }
        this.fireControllerEvent(ControllerType.ZOOM, Float.valueOf(factor));
    }

    protected void zoomY(float factor) {
        this.zoomY(factor, DEFAULT_UPDATE_VIEW);
    }

    protected void zoomY(float factor, boolean updateView) {
        for (Chart c : this.targets) {
            c.getView().zoomY(factor, updateView);
        }
        this.fireControllerEvent(ControllerType.ZOOM, Float.valueOf(factor));
    }

    protected void zoomZ(float factor) {
        this.zoomZ(factor, DEFAULT_UPDATE_VIEW);
    }

    protected void zoomZ(float factor, boolean updateView) {
        for (Chart c : this.targets) {
            c.getView().zoomZ(factor, updateView);
        }
        this.fireControllerEvent(ControllerType.ZOOM, Float.valueOf(factor));
    }

    @Override
    public void addSlaveThreadController(CameraThreadController controller) {
        this.removeSlaveThreadController();
        this.threadController = controller;
    }

    public void removeSlaveThreadController() {
        if (this.threadController != null) {
            this.threadController.stop();
            this.threadController = null;
        }
    }

    public void stopThreadController() {
        if (this.threadController != null) {
            this.threadController.stop();
        }
    }

    public void startThreadController() {
        if (this.threadController != null) {
            this.threadController.start();
        }
    }
}

