/*
 * Decompiled with CFR 0.152.
 */
package il.ac.idc.jdt;

import il.ac.idc.jdt.BoundingBox;
import il.ac.idc.jdt.DelaunayTriangulation;
import il.ac.idc.jdt.Point;
import il.ac.idc.jdt.Triangle;
import java.util.Iterator;

public class GridIndex {
    private DelaunayTriangulation indexDelaunay;
    private double xSize;
    private double ySize;
    private BoundingBox indexRegion;
    private Triangle[][] grid;

    public GridIndex(DelaunayTriangulation delaunay, int xCellCount, int yCellCount) {
        this(delaunay, xCellCount, yCellCount, delaunay.getBoundingBox());
    }

    public GridIndex(DelaunayTriangulation delaunay, int xCellCount, int yCellCount, BoundingBox region) {
        this.init(delaunay, xCellCount, yCellCount, region);
    }

    private void init(DelaunayTriangulation delaunay, int xCellCount, int yCellCount, BoundingBox region) {
        this.indexDelaunay = delaunay;
        this.indexRegion = region;
        this.xSize = region.getWidth() / (double)yCellCount;
        this.ySize = region.getHeight() / (double)xCellCount;
        this.grid = new Triangle[xCellCount][yCellCount];
        Triangle colStartTriangle = this.indexDelaunay.find(this.middleOfCell(0, 0));
        this.updateCellValues(0, 0, xCellCount - 1, yCellCount - 1, colStartTriangle);
    }

    public Triangle findCellTriangleOf(Point point) {
        int xIndex = (int)((point.getX() - this.indexRegion.minX()) / this.xSize);
        int yIndex = (int)((point.getY() - this.indexRegion.minY()) / this.ySize);
        return this.grid[xIndex][yIndex];
    }

    public void updateIndex(Iterator<Triangle> updatedTriangles) {
        BoundingBox updatedRegion = new BoundingBox();
        while (updatedTriangles.hasNext()) {
            updatedRegion = updatedRegion.unionWith(updatedTriangles.next().getBoundingBox());
        }
        if (updatedRegion.isNull()) {
            return;
        }
        if (!this.indexRegion.contains(updatedRegion)) {
            this.init(this.indexDelaunay, (int)(this.indexRegion.getWidth() / this.xSize), (int)(this.indexRegion.getHeight() / this.ySize), this.indexRegion.unionWith(updatedRegion));
        } else {
            PointInt minInvalidCell = this.getCellOf(updatedRegion.getMinPoint());
            PointInt maxInvalidCell = this.getCellOf(updatedRegion.getMaxPoint());
            Triangle adjacentValidTriangle = this.findValidTriangle(minInvalidCell);
            this.updateCellValues(minInvalidCell.x, minInvalidCell.y, maxInvalidCell.x, maxInvalidCell.y, adjacentValidTriangle);
        }
    }

    private void updateCellValues(int startXCell, int startYCell, int lastXCell, int lastYCell, Triangle startTriangle) {
        for (int i = startXCell; i <= lastXCell; ++i) {
            this.grid[i][startYCell] = startTriangle = this.indexDelaunay.find(this.middleOfCell(i, startYCell), startTriangle);
            Triangle prevRowTriangle = startTriangle;
            for (int j = startYCell + 1; j <= lastYCell; ++j) {
                this.grid[i][j] = this.indexDelaunay.find(this.middleOfCell(i, j), prevRowTriangle);
                prevRowTriangle = this.grid[i][j];
            }
        }
    }

    private Triangle findValidTriangle(PointInt minInvalidCell) {
        if (minInvalidCell.x == 0 && minInvalidCell.y == 0) {
            return this.indexDelaunay.find(this.middleOfCell(minInvalidCell.getX(), minInvalidCell.getY()), null);
        }
        return this.grid[Math.min(0, minInvalidCell.getX())][Math.min(0, minInvalidCell.getY())];
    }

    private PointInt getCellOf(Point coordinate) {
        int xCell = (int)((coordinate.getX() - this.indexRegion.minX()) / this.xSize);
        int yCell = (int)((coordinate.getY() - this.indexRegion.minY()) / this.ySize);
        return new PointInt(xCell, yCell);
    }

    private Point middleOfCell(int xIndex, int yIndex) {
        double middleXCell = this.indexRegion.minX() + (double)xIndex * this.xSize + this.xSize / 2.0;
        double middleYCell = this.indexRegion.minY() + (double)yIndex * this.ySize + this.ySize / 2.0;
        return new Point(middleXCell, middleYCell);
    }

    private class PointInt {
        private int x;
        private int y;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public PointInt(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

