/*
 * Decompiled with CFR 0.152.
 */
package il.ac.idc.jdt;

import il.ac.idc.jdt.BoundingBox;
import il.ac.idc.jdt.GridIndex;
import il.ac.idc.jdt.Point;
import il.ac.idc.jdt.Triangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class DelaunayTriangulation {
    private Point firstP;
    private Point lastP;
    private boolean allCollinear = true;
    private Triangle firstT;
    private Triangle lastT;
    private Triangle currT;
    private Triangle startTriangle;
    private Triangle startTriangleHull;
    private Set<Point> vertices = new TreeSet<Point>();
    private Vector<Triangle> triangles = new Vector();
    private Vector<Triangle> deletedTriangles = null;
    private Vector<Triangle> addedTriangles = new Vector();
    private int modCount = 0;
    private int modCount2 = 0;
    private Point bbMin = null;
    private Point bbMax = null;
    private GridIndex gridIndex = null;

    public DelaunayTriangulation() {
        this(new Point[0]);
    }

    public DelaunayTriangulation(Point[] ps) {
        this(Arrays.asList(ps));
    }

    public DelaunayTriangulation(Collection<Point> points) {
        this.insertPoints(points);
    }

    public int size() {
        if (this.vertices == null) {
            return 0;
        }
        return this.vertices.size();
    }

    public int trianglesSize() {
        this.initTriangles();
        return this.triangles.size();
    }

    public int getModeCounter() {
        return this.modCount;
    }

    public void insertPoints(Collection<Point> points) {
        for (Point p : points) {
            this.insertPoint(p);
        }
    }

    public void insertPoint(Point p) {
        if (this.vertices.contains(p)) {
            return;
        }
        ++this.modCount;
        this.updateBoundingBox(p);
        this.vertices.add(p);
        Triangle t = this.insertPointSimple(p);
        if (t == null) {
            return;
        }
        Triangle tt = t;
        this.currT = t;
        do {
            this.flip(tt, this.modCount);
        } while ((tt = tt.getCaTriangle()) != t && !tt.isHalfplane());
        if (this.gridIndex != null) {
            this.gridIndex.updateIndex(this.getLastUpdatedTriangles());
        }
    }

    public void deletePoint(Point pointToDelete) {
        Vector<Point> pointsVec = this.findConnectedVertices(pointToDelete, true);
        if (pointsVec == null) {
            return;
        }
        block0: while (pointsVec.size() >= 3) {
            Triangle triangle = this.findTriangle(pointsVec, pointToDelete);
            this.addedTriangles.add(triangle);
            Point p = this.findDiagonal(triangle, pointToDelete);
            for (Point tmpP : pointsVec) {
                if (!tmpP.equals(p)) continue;
                pointsVec.removeElement(tmpP);
                continue block0;
            }
        }
        this.deleteUpdate(pointToDelete);
        for (Triangle t : this.deletedTriangles) {
            if (t != this.startTriangle) continue;
            this.startTriangle = this.addedTriangles.elementAt(0);
            break;
        }
        this.triangles.removeAll(this.deletedTriangles);
        this.triangles.addAll(this.addedTriangles);
        this.vertices.remove(pointToDelete);
        this.addedTriangles.removeAllElements();
        this.deletedTriangles.removeAllElements();
    }

    public Point findClosePoint(Point pointToDelete) {
        Triangle triangle = this.find(pointToDelete);
        Point p1 = triangle.getA();
        Point p2 = triangle.getB();
        double d1 = p1.distance(pointToDelete);
        double d2 = p2.distance(pointToDelete);
        if (triangle.isHalfplane()) {
            if (d1 <= d2) {
                return p1;
            }
            return p2;
        }
        Point p3 = triangle.getC();
        double d3 = p3.distance(pointToDelete);
        if (d1 <= d2 && d1 <= d3) {
            return p1;
        }
        if (d2 <= d1 && d2 <= d3) {
            return p2;
        }
        return p3;
    }

    private void deleteUpdate(Point pointToDelete) {
        for (Triangle addedTriangle1 : this.addedTriangles) {
            for (Triangle deletedTriangle : this.deletedTriangles) {
                if (!this.shareSegment(addedTriangle1, deletedTriangle)) continue;
                this.updateNeighbor(addedTriangle1, deletedTriangle, pointToDelete);
            }
        }
        for (Triangle addedTriangle1 : this.addedTriangles) {
            for (Triangle addedTriangle2 : this.addedTriangles) {
                if (addedTriangle1 == addedTriangle2 || !this.shareSegment(addedTriangle1, addedTriangle2)) continue;
                this.updateNeighbor(addedTriangle1, addedTriangle2);
            }
        }
        if (this.gridIndex != null) {
            this.gridIndex.updateIndex(this.addedTriangles.iterator());
        }
    }

    private boolean shareSegment(Triangle t1, Triangle t2) {
        int counter = 0;
        Point t1P1 = t1.getA();
        Point t1P2 = t1.getB();
        Point t1P3 = t1.getC();
        Point t2P1 = t2.getA();
        Point t2P2 = t2.getB();
        Point t2P3 = t2.getC();
        if (t1P1.equals(t2P1)) {
            ++counter;
        }
        if (t1P1.equals(t2P2)) {
            ++counter;
        }
        if (t1P1.equals(t2P3)) {
            ++counter;
        }
        if (t1P2.equals(t2P1)) {
            ++counter;
        }
        if (t1P2.equals(t2P2)) {
            ++counter;
        }
        if (t1P2.equals(t2P3)) {
            ++counter;
        }
        if (t1P3.equals(t2P1)) {
            ++counter;
        }
        if (t1P3.equals(t2P2)) {
            ++counter;
        }
        if (t1P3.equals(t2P3)) {
            ++counter;
        }
        return counter >= 2;
    }

    private void updateNeighbor(Triangle addedTriangle, Triangle deletedTriangle, Point pointToDelete) {
        Point delA = deletedTriangle.getA();
        Point delB = deletedTriangle.getB();
        Point delC = deletedTriangle.getC();
        Point addA = addedTriangle.getA();
        Point addB = addedTriangle.getB();
        Point addC = addedTriangle.getC();
        if (pointToDelete.equals(delA)) {
            deletedTriangle.getBcTriangle().switchneighbors(deletedTriangle, addedTriangle);
            if (addA.equals(delB) && addB.equals(delC) || addB.equals(delB) && addA.equals(delC)) {
                addedTriangle.setAbTriangle(deletedTriangle.getBcTriangle());
            } else if (addA.equals(delB) && addC.equals(delC) || addC.equals(delB) && addA.equals(delC)) {
                addedTriangle.setCanext(deletedTriangle.getBcTriangle());
            } else {
                addedTriangle.setBcTriangle(deletedTriangle.getBcTriangle());
            }
        } else if (pointToDelete.equals(delB)) {
            deletedTriangle.getCaTriangle().switchneighbors(deletedTriangle, addedTriangle);
            if (addA.equals(delA) && addB.equals(delC) || addB.equals(delA) && addA.equals(delC)) {
                addedTriangle.setAbTriangle(deletedTriangle.getCaTriangle());
            } else if (addA.equals(delA) && addC.equals(delC) || addC.equals(delA) && addA.equals(delC)) {
                addedTriangle.setCanext(deletedTriangle.getCaTriangle());
            } else {
                addedTriangle.setBcTriangle(deletedTriangle.getCaTriangle());
            }
        } else {
            deletedTriangle.getAbTriangle().switchneighbors(deletedTriangle, addedTriangle);
            if (addA.equals(delA) && addB.equals(delB) || addB.equals(delA) && addA.equals(delB)) {
                addedTriangle.setAbTriangle(deletedTriangle.getAbTriangle());
            } else if (addA.equals(delA) && addC.equals(delB) || addC.equals(delA) && addA.equals(delB)) {
                addedTriangle.setCanext(deletedTriangle.getAbTriangle());
            } else {
                addedTriangle.setBcTriangle(deletedTriangle.getAbTriangle());
            }
        }
    }

    private void updateNeighbor(Triangle addedTriangle1, Triangle addedTriangle2) {
        Point A1 = addedTriangle1.getA();
        Point B1 = addedTriangle1.getB();
        Point C1 = addedTriangle1.getC();
        Point A2 = addedTriangle2.getA();
        Point B2 = addedTriangle2.getB();
        Point C2 = addedTriangle2.getC();
        if (A1.equals(A2)) {
            if (B1.equals(B2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else if (B1.equals(C2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            } else if (C1.equals(B2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            }
        } else if (A1.equals(B2)) {
            if (B1.equals(A2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else if (B1.equals(C2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            } else if (C1.equals(A2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
        } else if (A1.equals(C2)) {
            if (B1.equals(A2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            }
            if (B1.equals(B2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
            if (C1.equals(A2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            } else {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
        } else if (B1.equals(A2)) {
            if (A1.equals(B2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else if (A1.equals(C2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            } else if (C1.equals(B2)) {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            }
        } else if (B1.equals(B2)) {
            if (A1.equals(A2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else if (A1.equals(C2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            } else if (C1.equals(A2)) {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
        } else if (B1.equals(C2)) {
            if (A1.equals(A2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            }
            if (A1.equals(B2)) {
                addedTriangle1.setAbTriangle(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
            if (C1.equals(A2)) {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            } else {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
        } else if (C1.equals(A2)) {
            if (A1.equals(B2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            } else if (A1.equals(C2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            } else if (B1.equals(B2)) {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            }
        } else if (C1.equals(B2)) {
            if (A1.equals(A2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else if (A1.equals(C2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            } else if (B1.equals(A2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setAbTriangle(addedTriangle1);
            } else {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
        } else if (C1.equals(C2)) {
            if (A1.equals(A2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            }
            if (A1.equals(B2)) {
                addedTriangle1.setCanext(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
            if (B1.equals(A2)) {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setCanext(addedTriangle1);
            } else {
                addedTriangle1.setBcTriangle(addedTriangle2);
                addedTriangle2.setBcTriangle(addedTriangle1);
            }
        }
    }

    private Point findDiagonal(Triangle triangle, Point point) {
        Point p1 = triangle.getA();
        Point p2 = triangle.getB();
        Point p3 = triangle.getC();
        if (p1.pointLineTest(point, p3) == 1 && p2.pointLineTest(point, p3) == 2) {
            return p3;
        }
        if (p3.pointLineTest(point, p2) == 1 && p1.pointLineTest(point, p2) == 2) {
            return p2;
        }
        if (p2.pointLineTest(point, p1) == 1 && p3.pointLineTest(point, p1) == 2) {
            return p1;
        }
        return null;
    }

    public Point[] calcVoronoiCell(Triangle triangle, Point p) {
        if (!triangle.isHalfplane()) {
            Vector<Triangle> neighbors = this.findTriangleNeighborhood(triangle, p);
            Iterator<Triangle> itn = neighbors.iterator();
            Point[] vertices = new Point[neighbors.size()];
            int index = 0;
            while (itn.hasNext()) {
                Triangle tmp = itn.next();
                vertices[index++] = tmp.circumcircle().center();
            }
            return vertices;
        }
        Triangle halfplane = triangle;
        Point third = null;
        Triangle neighbor = null;
        if (!halfplane.getAbTriangle().isHalfplane()) {
            neighbor = halfplane.getAbTriangle();
        } else if (!halfplane.getBcTriangle().isHalfplane()) {
            neighbor = halfplane.getBcTriangle();
        } else if (!halfplane.getBcTriangle().isHalfplane()) {
            neighbor = halfplane.getCaTriangle();
        }
        if (!neighbor.getA().equals(halfplane.getA()) && !neighbor.getA().equals(halfplane.getB())) {
            third = neighbor.getA();
        }
        if (!neighbor.getB().equals(halfplane.getA()) && !neighbor.getB().equals(halfplane.getB())) {
            third = neighbor.getB();
        }
        if (!neighbor.getC().equals(halfplane.getA()) && !neighbor.getC().equals(halfplane.getB())) {
            third = neighbor.getC();
        }
        double halfplaneDelta = (halfplane.getA().getY() - halfplane.getB().getY()) / (halfplane.getA().getX() - halfplane.getB().getX());
        double perpDelta = 1.0 / halfplaneDelta * -1.0;
        double yOrient = halfplaneDelta * (third.getX() - halfplane.getA().getX()) + halfplane.getA().getY();
        boolean above = true;
        if (yOrient > third.getY()) {
            above = false;
        }
        double sign = 1.0;
        if (perpDelta < 0.0 && !above || perpDelta > 0.0 && above) {
            sign = -1.0;
        }
        Point circumcircle = neighbor.circumcircle().center();
        double xCellLine = circumcircle.getX() + 500.0 * sign;
        double yCellLine = perpDelta * (xCellLine - circumcircle.getX()) + circumcircle.getY();
        Point[] result = new Point[]{circumcircle, new Point(xCellLine, yCellLine)};
        return result;
    }

    public Iterator<Triangle> getLastUpdatedTriangles() {
        Vector<Triangle> tmp = new Vector<Triangle>();
        if (this.trianglesSize() > 1) {
            Triangle t = this.currT;
            this.allTriangles(t, tmp, this.modCount);
        }
        return tmp.iterator();
    }

    private void allTriangles(Triangle curr, Vector<Triangle> front, int mc) {
        if (curr != null && curr.getMc() == mc && !front.contains(curr)) {
            front.add(curr);
            this.allTriangles(curr.getAbTriangle(), front, mc);
            this.allTriangles(curr.getBcTriangle(), front, mc);
            this.allTriangles(curr.getCaTriangle(), front, mc);
        }
    }

    private Triangle insertPointSimple(Point p) {
        if (!this.allCollinear) {
            Triangle t = DelaunayTriangulation.find(this.startTriangle, p);
            this.startTriangle = t.isHalfplane() ? this.extendOutside(t, p) : this.extendInside(t, p);
            return this.startTriangle;
        }
        if (this.vertices.size() == 1) {
            this.firstP = p;
            return null;
        }
        if (this.vertices.size() == 2) {
            this.startTriangulation(this.firstP, p);
            return null;
        }
        switch (p.pointLineTest(this.firstP, this.lastP)) {
            case 1: {
                this.startTriangle = this.extendOutside(this.firstT.getAbTriangle(), p);
                this.allCollinear = false;
                break;
            }
            case 2: {
                this.startTriangle = this.extendOutside(this.firstT, p);
                this.allCollinear = false;
                break;
            }
            case 0: {
                this.insertCollinear(p, 0);
                break;
            }
            case 3: {
                this.insertCollinear(p, 3);
                break;
            }
            case 4: {
                this.insertCollinear(p, 4);
            }
        }
        return null;
    }

    private void insertCollinear(Point p, int res) {
        switch (res) {
            case 3: {
                Triangle t = new Triangle(this.firstP, p);
                Triangle tp = new Triangle(p, this.firstP);
                t.setAbTriangle(tp);
                tp.setAbTriangle(t);
                t.setBcTriangle(tp);
                tp.setCanext(t);
                t.setCanext(this.firstT);
                this.firstT.setBcTriangle(t);
                tp.setBcTriangle(this.firstT.getAbTriangle());
                this.firstT.getAbTriangle().setCanext(tp);
                this.firstT = t;
                this.firstP = p;
                break;
            }
            case 4: {
                Triangle t = new Triangle(p, this.lastP);
                Triangle tp = new Triangle(this.lastP, p);
                t.setAbTriangle(tp);
                tp.setAbTriangle(t);
                t.setBcTriangle(this.lastT);
                this.lastT.setCanext(t);
                t.setCanext(tp);
                tp.setBcTriangle(t);
                tp.setCanext(this.lastT.getAbTriangle());
                this.lastT.getAbTriangle().setBcTriangle(tp);
                this.lastT = t;
                this.lastP = p;
                break;
            }
            case 0: {
                Triangle u = this.firstT;
                while (p.isGreater(u.getA())) {
                    u = u.getCaTriangle();
                }
                Triangle t = new Triangle(p, u.getB());
                Triangle tp = new Triangle(u.getB(), p);
                u.setB(p);
                u.getAbTriangle().setA(p);
                t.setAbTriangle(tp);
                tp.setAbTriangle(t);
                t.setBcTriangle(u.getBcTriangle());
                u.getBcTriangle().setCanext(t);
                t.setCanext(u);
                u.setBcTriangle(t);
                tp.setCanext(u.getAbTriangle().getCaTriangle());
                u.getAbTriangle().getCaTriangle().setBcTriangle(tp);
                tp.setBcTriangle(u.getAbTriangle());
                u.getAbTriangle().setCanext(tp);
                if (this.firstT != u) break;
                this.firstT = t;
            }
        }
    }

    private void startTriangulation(Point p1, Point p2) {
        Point pb;
        Point ps;
        if (p1.isLess(p2)) {
            ps = p1;
            pb = p2;
        } else {
            ps = p2;
            pb = p1;
        }
        this.lastT = this.firstT = new Triangle(pb, ps);
        Triangle t = new Triangle(ps, pb);
        this.firstT.setAbTriangle(t);
        t.setAbTriangle(this.firstT);
        this.firstT.setBcTriangle(t);
        t.setCanext(this.firstT);
        this.firstT.setCanext(t);
        t.setBcTriangle(this.firstT);
        this.firstP = this.firstT.getB();
        this.lastP = this.lastT.getA();
        this.startTriangleHull = this.firstT;
    }

    private Triangle extendInside(Triangle t, Point p) {
        Triangle h1 = this.treatDegeneracyInside(t, p);
        if (h1 != null) {
            return h1;
        }
        h1 = new Triangle(t.getC(), t.getA(), p);
        Triangle h2 = new Triangle(t.getB(), t.getC(), p);
        t.setC(p);
        t.circumcircle();
        h1.setAbTriangle(t.getCaTriangle());
        h1.setBcTriangle(t);
        h1.setCanext(h2);
        h2.setAbTriangle(t.getBcTriangle());
        h2.setBcTriangle(h1);
        h2.setCanext(t);
        h1.getAbTriangle().switchneighbors(t, h1);
        h2.getAbTriangle().switchneighbors(t, h2);
        t.setBcTriangle(h2);
        t.setCanext(h1);
        return t;
    }

    private Triangle treatDegeneracyInside(Triangle t, Point p) {
        if (t.getAbTriangle().isHalfplane() && p.pointLineTest(t.getB(), t.getA()) == 0) {
            return this.extendOutside(t.getAbTriangle(), p);
        }
        if (t.getBcTriangle().isHalfplane() && p.pointLineTest(t.getC(), t.getB()) == 0) {
            return this.extendOutside(t.getBcTriangle(), p);
        }
        if (t.getCaTriangle().isHalfplane() && p.pointLineTest(t.getA(), t.getC()) == 0) {
            return this.extendOutside(t.getCaTriangle(), p);
        }
        return null;
    }

    private Triangle extendOutside(Triangle t, Point p) {
        if (p.pointLineTest(t.getA(), t.getB()) == 0) {
            Triangle dg = new Triangle(t.getA(), t.getB(), p);
            Triangle hp = new Triangle(p, t.getB());
            t.setB(p);
            dg.setAbTriangle(t.getAbTriangle());
            dg.getAbTriangle().switchneighbors(t, dg);
            dg.setBcTriangle(hp);
            hp.setAbTriangle(dg);
            dg.setCanext(t);
            t.setAbTriangle(dg);
            hp.setBcTriangle(t.getBcTriangle());
            hp.getBcTriangle().setCanext(hp);
            hp.setCanext(t);
            t.setBcTriangle(hp);
            return dg;
        }
        Triangle ccT = this.extendcounterclock(t, p);
        Triangle cT = this.extendclock(t, p);
        ccT.setBcTriangle(cT);
        cT.setCanext(ccT);
        this.startTriangleHull = cT;
        return cT.getAbTriangle();
    }

    private Triangle extendcounterclock(Triangle t, Point p) {
        t.setHalfplane(false);
        t.setC(p);
        t.circumcircle();
        Triangle tca = t.getCaTriangle();
        if (p.pointLineTest(tca.getA(), tca.getB()) >= 2) {
            Triangle nT = new Triangle(t.getA(), p);
            nT.setAbTriangle(t);
            t.setCanext(nT);
            nT.setCanext(tca);
            tca.setBcTriangle(nT);
            return nT;
        }
        return this.extendcounterclock(tca, p);
    }

    private Triangle extendclock(Triangle t, Point p) {
        t.setHalfplane(false);
        t.setC(p);
        t.circumcircle();
        Triangle tbc = t.getBcTriangle();
        if (p.pointLineTest(tbc.getA(), tbc.getB()) >= 2) {
            Triangle nT = new Triangle(p, t.getB());
            nT.setAbTriangle(t);
            t.setBcTriangle(nT);
            nT.setBcTriangle(tbc);
            tbc.setCanext(nT);
            return nT;
        }
        return this.extendclock(tbc, p);
    }

    private void flip(Triangle t, int mc) {
        Triangle v;
        Triangle u = t.getAbTriangle();
        t.setMc(mc);
        if (u.isHalfplane() || !u.circumcircleContains(t.getC())) {
            return;
        }
        if (t.getA() == u.getA()) {
            v = new Triangle(u.getB(), t.getB(), t.getC());
            v.setAbTriangle(u.getBcTriangle());
            t.setAbTriangle(u.getAbTriangle());
        } else if (t.getA() == u.getB()) {
            v = new Triangle(u.getC(), t.getB(), t.getC());
            v.setAbTriangle(u.getCaTriangle());
            t.setAbTriangle(u.getBcTriangle());
        } else if (t.getA() == u.getC()) {
            v = new Triangle(u.getA(), t.getB(), t.getC());
            v.setAbTriangle(u.getAbTriangle());
            t.setAbTriangle(u.getCaTriangle());
        } else {
            throw new RuntimeException("Error in flip.");
        }
        v.setMc(mc);
        v.setBcTriangle(t.getBcTriangle());
        v.getAbTriangle().switchneighbors(u, v);
        v.getBcTriangle().switchneighbors(t, v);
        t.setBcTriangle(v);
        v.setCanext(t);
        t.setB(v.getA());
        t.getAbTriangle().switchneighbors(u, t);
        t.circumcircle();
        this.currT = v;
        this.flip(t, mc);
        this.flip(v, mc);
    }

    public int getConvexHullSize() {
        int ans = 0;
        Iterator<Point> it = this.getConvexHullVerticesIterator();
        while (it.hasNext()) {
            ++ans;
            it.next();
        }
        return ans;
    }

    public Triangle find(Point p) {
        Triangle indexTriangle;
        Triangle searchTriangle = this.startTriangle;
        if (this.gridIndex != null && (indexTriangle = this.gridIndex.findCellTriangleOf(p)) != null) {
            searchTriangle = indexTriangle;
        }
        return DelaunayTriangulation.find(searchTriangle, p);
    }

    public Triangle find(Point p, Triangle start) {
        if (start == null) {
            start = this.startTriangle;
        }
        Triangle T = DelaunayTriangulation.find(start, p);
        return T;
    }

    private static Triangle find(Triangle curr, Point p) {
        Triangle nextT;
        if (p == null) {
            return null;
        }
        if (curr.isHalfplane()) {
            nextT = DelaunayTriangulation.findnext2(p, curr);
            if (nextT == null || nextT.isHalfplane()) {
                return curr;
            }
            curr = nextT;
        }
        while ((nextT = DelaunayTriangulation.findnext1(p, curr)) != null) {
            if (nextT.isHalfplane()) {
                return nextT;
            }
            curr = nextT;
        }
        return curr;
    }

    private static Triangle findnext1(Point p, Triangle v) {
        if (p.pointLineTest(v.getA(), v.getB()) == 2 && !v.getAbTriangle().isHalfplane()) {
            return v.getAbTriangle();
        }
        if (p.pointLineTest(v.getB(), v.getC()) == 2 && !v.getBcTriangle().isHalfplane()) {
            return v.getBcTriangle();
        }
        if (p.pointLineTest(v.getC(), v.getA()) == 2 && !v.getCaTriangle().isHalfplane()) {
            return v.getCaTriangle();
        }
        if (p.pointLineTest(v.getA(), v.getB()) == 2) {
            return v.getAbTriangle();
        }
        if (p.pointLineTest(v.getB(), v.getC()) == 2) {
            return v.getBcTriangle();
        }
        if (p.pointLineTest(v.getC(), v.getA()) == 2) {
            return v.getCaTriangle();
        }
        return null;
    }

    private static Triangle findnext2(Point p, Triangle v) {
        if (v.getAbTriangle() != null && !v.getAbTriangle().isHalfplane()) {
            return v.getAbTriangle();
        }
        if (v.getBcTriangle() != null && !v.getBcTriangle().isHalfplane()) {
            return v.getBcTriangle();
        }
        if (v.getCaTriangle() != null && !v.getCaTriangle().isHalfplane()) {
            return v.getCaTriangle();
        }
        return null;
    }

    private Vector<Point> findConnectedVertices(Point point, boolean saveTriangles) {
        HashSet<Point> pointsSet = new HashSet<Point>();
        Vector<Point> pointsVec = new Vector<Point>();
        Vector<Triangle> triangles = null;
        Triangle triangle = this.find(point);
        if (!triangle.isCorner(point)) {
            System.err.println("findConnectedVertices: Could not find connected vertices since the first found triangle doesn't share the given point.");
            return null;
        }
        triangles = this.findTriangleNeighborhood(triangle, point);
        if (triangles == null) {
            System.err.println("Error: can't delete a point on the perimeter");
            return null;
        }
        if (saveTriangles) {
            this.deletedTriangles = triangles;
        }
        for (Triangle tmpTriangle : triangles) {
            Point point1 = tmpTriangle.getA();
            Point point2 = tmpTriangle.getB();
            Point point3 = tmpTriangle.getC();
            if (point1.equals(point) && !pointsSet.contains(point2)) {
                pointsSet.add(point2);
                pointsVec.add(point2);
            }
            if (point2.equals(point) && !pointsSet.contains(point3)) {
                pointsSet.add(point3);
                pointsVec.add(point3);
            }
            if (!point3.equals(point) || pointsSet.contains(point1)) continue;
            pointsSet.add(point1);
            pointsVec.add(point1);
        }
        return pointsVec;
    }

    public Vector<Triangle> findTriangleNeighborhood(Triangle firstTriangle, Point point) {
        Vector<Triangle> triangles = new Vector<Triangle>(30);
        triangles.add(firstTriangle);
        Triangle prevTriangle = null;
        Triangle currentTriangle = firstTriangle;
        Triangle nextTriangle = currentTriangle.nextNeighbor(point, prevTriangle);
        while (nextTriangle != firstTriangle) {
            if (nextTriangle.isHalfplane()) {
                return null;
            }
            triangles.add(nextTriangle);
            prevTriangle = currentTriangle;
            currentTriangle = nextTriangle;
            nextTriangle = currentTriangle.nextNeighbor(point, prevTriangle);
        }
        return triangles;
    }

    private Triangle findTriangle(Vector<Point> pointsVec, Point p) {
        Point[] arrayPoints = new Point[pointsVec.size()];
        pointsVec.toArray(arrayPoints);
        int size = arrayPoints.length;
        if (size < 3) {
            return null;
        }
        if (size == 3) {
            return new Triangle(arrayPoints[0], arrayPoints[1], arrayPoints[2]);
        }
        for (int i = 0; i <= size - 1; ++i) {
            Point p1 = arrayPoints[i];
            int j = i + 1;
            int k = i + 2;
            if (j >= size) {
                j = 0;
                k = 1;
            } else if (k >= size) {
                k = 0;
            }
            Point p2 = arrayPoints[j];
            Point p3 = arrayPoints[k];
            Triangle t = new Triangle(p1, p2, p3);
            if (this.calcDet(p1, p2, p3) >= 0.0 && !t.contains(p) && !t.fallInsideCircumcircle(arrayPoints)) {
                return t;
            }
            if (size != 4 || !(this.calcDet(p1, p2, p3) >= 0.0) || t.containsBoundaryIsOutside(p) || t.fallInsideCircumcircle(arrayPoints)) continue;
            return t;
        }
        return null;
    }

    private double calcDet(Point A, Point B, Point P) {
        return A.getX() * (B.getY() - P.getY()) - A.getY() * (B.getX() - P.getX()) + (B.getX() * P.getY() - B.getY() * P.getX());
    }

    public boolean contains(Point p) {
        Triangle tt = this.find(p);
        return !tt.isHalfplane();
    }

    public boolean contains(double x, double y) {
        return this.contains(new Point(x, y));
    }

    public Point z(Point q) {
        Triangle t = this.find(q);
        return t.getZ(q);
    }

    public double z(double x, double y) {
        Point q = new Point(x, y);
        Triangle t = this.find(q);
        return t.zValue(q);
    }

    private void updateBoundingBox(Point p) {
        double x = p.getX();
        double y = p.getY();
        double z = p.getZ();
        if (this.bbMin == null) {
            this.bbMin = new Point(p);
            this.bbMax = new Point(p);
        } else {
            if (x < this.bbMin.getX()) {
                this.bbMin.setX(x);
            } else if (x > this.bbMax.getX()) {
                this.bbMax.setX(x);
            }
            if (y < this.bbMin.getY()) {
                this.bbMin.setY(y);
            } else if (y > this.bbMax.getY()) {
                this.bbMax.setY(y);
            }
            if (z < this.bbMin.getZ()) {
                this.bbMin.setZ(z);
            } else if (z > this.bbMax.getZ()) {
                this.bbMax.setZ(z);
            }
        }
    }

    public BoundingBox getBoundingBox() {
        if (this.bbMin == null || this.bbMax == null) {
            return null;
        }
        return new BoundingBox(this.bbMin, this.bbMax);
    }

    public Point minBoundingBox() {
        return this.bbMin;
    }

    public Point maxBoundingBox() {
        return this.bbMax;
    }

    public Iterator<Triangle> trianglesIterator() {
        if (this.size() <= 2) {
            this.triangles = new Vector();
        }
        this.initTriangles();
        return this.triangles.iterator();
    }

    public Iterator<Point> getConvexHullVerticesIterator() {
        Vector<Point> ans = new Vector<Point>();
        Triangle curr = this.startTriangleHull;
        boolean cont = true;
        double x0 = this.bbMin.getX();
        double x1 = this.bbMax.getX();
        double y0 = this.bbMin.getY();
        double y1 = this.bbMax.getY();
        while (cont) {
            boolean sy;
            boolean sx = curr.getA().getX() == x0 || curr.getA().getX() == x1;
            boolean bl = sy = curr.getA().getY() == y0 || curr.getA().getY() == y1;
            if (sx && sy || !sx && !sy) {
                ans.add(curr.getA());
            }
            if (curr.getBcTriangle() != null && curr.getBcTriangle().isHalfplane()) {
                curr = curr.getBcTriangle();
            }
            if (curr != this.startTriangleHull) continue;
            cont = false;
        }
        return ans.iterator();
    }

    public Iterator<Point> verticesIterator() {
        return this.vertices.iterator();
    }

    private void initTriangles() {
        if (this.modCount == this.modCount2) {
            return;
        }
        if (this.size() > 2) {
            this.modCount2 = this.modCount;
            Vector<Triangle> front = new Vector<Triangle>();
            this.triangles = new Vector();
            front.add(this.startTriangle);
            while (front.size() > 0) {
                Triangle t = (Triangle)front.remove(0);
                if (t.isMark()) continue;
                t.setMark(true);
                this.triangles.add(t);
                if (t.getAbTriangle() != null && !t.getAbTriangle().isMark()) {
                    front.add(t.getAbTriangle());
                }
                if (t.getBcTriangle() != null && !t.getBcTriangle().isMark()) {
                    front.add(t.getBcTriangle());
                }
                if (t.getCaTriangle() == null || t.getCaTriangle().isMark()) continue;
                front.add(t.getCaTriangle());
            }
            for (int i = 0; i < this.triangles.size(); ++i) {
                this.triangles.elementAt(i).setMark(false);
            }
        }
    }

    public void indexData(int xCellCount, int yCellCount) {
        this.gridIndex = new GridIndex(this, xCellCount, yCellCount);
    }

    public void removeIndex() {
        this.gridIndex = null;
    }

    public List<Triangle> getTriangulation() {
        if (this.size() <= 2) {
            this.triangles = new Vector();
        }
        this.initTriangles();
        ArrayList<Triangle> triangulation = new ArrayList<Triangle>(this.triangles);
        return triangulation;
    }
}

