/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.feyncalc;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.graph.GraphType;
import cc.redberry.core.graph.PrimitiveSubgraph;
import cc.redberry.core.graph.PrimitiveSubgraphPartition;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.preprocessor.ChangeIndicesTypesAndTensorNames;
import cc.redberry.core.parser.preprocessor.TypesAndNamesTransformer;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.ExpandAndEliminateTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.physics.feyncalc.TraceUtils;
import cc.redberry.physics.feyncalc.UnitarySimplifyTransformation;

public final class UnitaryTraceTransformation
implements Transformation {
    private final int unitaryMatrix;
    private final IndexType matrixType;
    private final Expression pairProduct;
    private final Expression singleTrace;
    private final Transformation simplifications;
    private static final Parser parser = CC.current().getParseManager().getParser();
    private static final ParseToken pairProductToken = parser.parse("T_a^a'_c'*T_b^c'_b' = 1/(2*N)*g_ab*d^a'_b' + I/2*F_abc*T^ca'_b' + 1/2*D_abc*T^ca'_b'");
    private static final ParseToken singleTraceToken = parser.parse("T_a^a'_a' = 0");

    public UnitaryTraceTransformation(final SimpleTensor unitaryMatrix, final SimpleTensor structureConstant, final SimpleTensor symmetricConstant, final Tensor dimension) {
        TraceUtils.checkUnitaryInput(unitaryMatrix, structureConstant, symmetricConstant, dimension);
        this.unitaryMatrix = unitaryMatrix.getName();
        final IndexType[] types = TraceUtils.extractTypesFromMatrix(unitaryMatrix);
        this.matrixType = types[1];
        ChangeIndicesTypesAndTensorNames tokenTransformer = new ChangeIndicesTypesAndTensorNames(new TypesAndNamesTransformer(){

            @Override
            public IndexType newType(IndexType oldType, NameAndStructureOfIndices old) {
                if (oldType == IndexType.LatinLower) {
                    return types[0];
                }
                if (oldType == IndexType.Matrix1) {
                    return types[1];
                }
                return oldType;
            }

            @Override
            public String newName(NameAndStructureOfIndices old) {
                switch (old.getName()) {
                    case "T": {
                        return unitaryMatrix.getStringName();
                    }
                    case "F": {
                        return structureConstant.getStringName();
                    }
                    case "D": {
                        return symmetricConstant.getStringName();
                    }
                    case "N": {
                        if (dimension instanceof Complex) break;
                        return dimension.toString(OutputFormat.Redberry);
                    }
                }
                return old.getName();
            }
        });
        Expression pairProduct = (Expression)tokenTransformer.transform(pairProductToken).toTensor();
        if (dimension instanceof Complex) {
            pairProduct = (Expression)Tensors.parseExpression("N = " + dimension).transform(pairProduct);
        }
        this.pairProduct = pairProduct;
        this.singleTrace = (Expression)tokenTransformer.transform(singleTraceToken).toTensor();
        this.simplifications = new UnitarySimplifyTransformation(dimension, tokenTransformer);
    }

    @Override
    public Tensor transform(Tensor t) {
        Tensor c;
        FromChildToParentIterator iterator = new FromChildToParentIterator(t);
        while ((c = iterator.next()) != null) {
            if (c instanceof SimpleTensor) {
                if (((SimpleTensor)c).getName() != this.unitaryMatrix || c.getIndices().getOfType(this.matrixType).getFree().size() != 0) continue;
                iterator.set(Complex.ZERO);
                continue;
            }
            if (!(c instanceof Product)) continue;
            Product product = (Product)c;
            int sizeOfIndexless = product.sizeOfIndexlessPart();
            ProductContent productContent = product.getContent();
            PrimitiveSubgraph[] subgraphs = PrimitiveSubgraphPartition.calculatePartition(productContent, this.matrixType);
            if (subgraphs.length == 0) continue;
            IntArrayList positionsOfMatrices = new IntArrayList();
            ProductBuilder calculatedTraces = new ProductBuilder();
            block1: for (PrimitiveSubgraph subgraph : subgraphs) {
                if (subgraph.getGraphType() != GraphType.Cycle) continue;
                int[] partition = subgraph.getPartition();
                for (int i = partition.length - 1; i >= 0; --i) {
                    partition[i] = sizeOfIndexless + partition[i];
                    if (!UnitaryTraceTransformation.isUnitaryMatrix(product.get(partition[i]), this.unitaryMatrix)) continue block1;
                }
                calculatedTraces.put(this.traceOfProduct(product.select(partition)));
                positionsOfMatrices.addAll(partition);
            }
            c = product.remove(positionsOfMatrices.toArray());
            c = Tensors.multiply(c, calculatedTraces.build());
            iterator.set(this.simplifications.transform(c));
        }
        return this.simplifications.transform(iterator.result());
    }

    private Tensor traceOfProduct(Tensor tensor) {
        Tensor newTensor;
        Tensor oldTensor = tensor;
        while (true) {
            newTensor = oldTensor;
            newTensor = this.simplifications.transform(newTensor);
            newTensor = this.singleTrace.transform(newTensor);
            newTensor = this.pairProduct.transform(newTensor);
            if ((newTensor = ExpandAndEliminateTransformation.expandAndEliminate(newTensor)) == oldTensor) break;
            oldTensor = newTensor;
        }
        return newTensor;
    }

    private static final boolean isUnitaryMatrix(Tensor tensor, int unitaryMatrix) {
        return tensor instanceof SimpleTensor && ((SimpleTensor)tensor).getName() == unitaryMatrix;
    }
}

