/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.feyncalc;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.TensorUtils;

final class TraceUtils {
    static final String unitaryMatrixName = "T";
    static final String structureConstantName = "F";
    static final String symmetricConstantName = "D";
    static final String dimensionName = "N";

    TraceUtils() {
    }

    static final IndexType[] extractTypesFromMatrix(SimpleTensor matrix) {
        if (matrix.getIndices().size() != 3) {
            throw new IllegalArgumentException("Not a matrix: " + matrix + ".");
        }
        NameDescriptor descriptor = CC.getNameDescriptor(matrix.getName());
        StructureOfIndices typeStructure = descriptor.getStructureOfIndices();
        byte metricType = -1;
        byte matrixType = -1;
        for (byte type = 0; type < 8; type = (byte)(type + 1)) {
            int typeCount = typeStructure.typeCount(type);
            if (typeCount == 0) continue;
            if (typeCount == 2) {
                if (matrixType != -1) {
                    throw new IllegalArgumentException("Not a matrix: " + matrix + ".");
                }
                matrixType = type;
                if (!CC.isMetric(matrixType)) continue;
                throw new IllegalArgumentException("Not a matrix: " + matrix + ".");
            }
            if (typeCount == 1) {
                if (metricType != -1) {
                    throw new IllegalArgumentException("Not a matrix: " + matrix + ".");
                }
                metricType = type;
                if (CC.isMetric(metricType)) continue;
                throw new IllegalArgumentException("Not a matrix: " + matrix + ".");
            }
            throw new IllegalArgumentException("Not a matrix: " + matrix + ".");
        }
        return new IndexType[]{IndexType.getType(metricType), IndexType.getType(matrixType)};
    }

    static void checkUnitaryInput(SimpleTensor unitaryMatrix, SimpleTensor structureConstant, SimpleTensor symmetricConstant, Tensor dimension) {
        SimpleTensor[] ss;
        if (dimension instanceof Complex && !TensorUtils.isNaturalNumber(dimension)) {
            throw new IllegalArgumentException("Non natural degree.");
        }
        if (unitaryMatrix.getIndices().size() != 3) {
            throw new IllegalArgumentException("Not a unitary matrix: " + unitaryMatrix);
        }
        IndexType[] types = TraceUtils.extractTypesFromMatrix(unitaryMatrix);
        IndexType metricType = types[0];
        if (!TensorUtils.isScalar(dimension)) {
            throw new IllegalArgumentException("Non scalar degree.");
        }
        if (structureConstant.getName() == symmetricConstant.getName()) {
            throw new IllegalArgumentException("Structure and symmetric constants have same names.");
        }
        for (SimpleTensor st : ss = new SimpleTensor[]{structureConstant, symmetricConstant}) {
            if (st.getIndices().size() != 3) {
                throw new IllegalArgumentException("Illegal input for SU(N) constants: " + st);
            }
            for (int i = 0; i < 3; ++i) {
                if (IndicesUtils.getTypeEnum(st.getIndices().get(i)) == metricType) continue;
                throw new IllegalArgumentException("Different indices metric types: " + unitaryMatrix + " and " + st);
            }
        }
    }
}

