/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

public final class Timing {
    private Timing() {
    }

    public static Object[] timing(TimingJob job, boolean printMessage) {
        long start = System.currentTimeMillis();
        Object result = job.doJob();
        long elapsed = System.currentTimeMillis() - start;
        if (printMessage) {
            System.out.println("Timing: " + elapsed + "ms");
        }
        return new Object[]{elapsed, result};
    }

    public static Object[] microTiming(TimingJob job, boolean printMessage) {
        long start = System.nanoTime();
        Object result = job.doJob();
        long elapsed = (System.nanoTime() - start) / 1000L;
        if (printMessage) {
            System.out.println("Timing: " + elapsed + "\u00b5s");
        }
        return new Object[]{elapsed, result};
    }

    public static Object[] timing(TimingJob job) {
        return Timing.timing(job, true);
    }

    public static Object[] microTiming(TimingJob job) {
        return Timing.microTiming(job, true);
    }

    public static interface TimingJob<T> {
        public T doJob();
    }
}

