/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.TensorWrapperWithEquals;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class THashMap<K extends Tensor, V>
extends AbstractMap<K, V> {
    private final HashMap<TensorWrapperWithEquals, V> map;

    public THashMap() {
        this.map = new HashMap();
    }

    public THashMap(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public THashMap(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(new TensorWrapperWithEquals((Tensor)key), value);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.map.get(key);
        }
        if (!(key instanceof Tensor)) {
            return null;
        }
        return this.map.get(new TensorWrapperWithEquals((Tensor)key));
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.map.containsKey(key);
        }
        if (!(key instanceof Tensor)) {
            return false;
        }
        return this.map.containsKey(new TensorWrapperWithEquals((Tensor)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        THashMap other = (THashMap)obj;
        return this.map.equals(other.map);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final Set<Map.Entry<TensorWrapperWithEquals, V>> innerSet;

        public EntrySet() {
            this.innerSet = THashMap.this.map.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return this.innerSet.size();
        }

        private final class EntrySetIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<TensorWrapperWithEquals, V>> innerIterator;

            public EntrySetIterator() {
                this.innerIterator = EntrySet.this.innerSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.innerIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry e = this.innerIterator.next();
                return new EntryImpl(this, e.getKey().tensor, e.getValue());
            }

            @Override
            public void remove() {
                this.innerIterator.remove();
            }

            private static class EntryImpl
            implements Map.Entry<K, V> {
                final K k;
                final V v;
                final /* synthetic */ EntrySetIterator this$2;

                public EntryImpl(K k, V v) {
                    this.this$2 = var1_1;
                    this.k = k;
                    this.v = v;
                }

                @Override
                public K getKey() {
                    return this.k;
                }

                @Override
                public V getValue() {
                    return this.v;
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        final Set<TensorWrapperWithEquals> innerSet;

        public KeySet() {
            this.innerSet = THashMap.this.map.keySet();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return this.innerSet.size();
        }

        private final class KeySetIterator
        implements Iterator<K> {
            final Iterator<TensorWrapperWithEquals> innerIterator;

            public KeySetIterator() {
                this.innerIterator = KeySet.this.innerSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.innerIterator.hasNext();
            }

            @Override
            public K next() {
                return this.innerIterator.next().tensor;
            }

            @Override
            public void remove() {
                this.innerIterator.remove();
            }
        }
    }
}

