/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import java.util.Arrays;

public final class MathUtils {
    private MathUtils() {
    }

    public static int[] getSortedDistinct(int[] values) {
        if (values.length == 0) {
            return values;
        }
        Arrays.sort(values);
        int shift = 0;
        int i = 0;
        while (i + shift + 1 < values.length) {
            if (values[i + shift] == values[i + shift + 1]) {
                ++shift;
                continue;
            }
            values[i] = values[i + shift];
            ++i;
        }
        values[i] = values[i + shift];
        return Arrays.copyOf(values, i + 1);
    }

    public static int[] intSetDifference(int[] a, int[] b) {
        int bPointer = 0;
        int aPointer = 0;
        int counter = 0;
        while (aPointer < a.length && bPointer < b.length) {
            if (a[aPointer] == b[bPointer]) {
                ++aPointer;
                ++bPointer;
                continue;
            }
            if (a[aPointer] < b[bPointer]) {
                ++aPointer;
                continue;
            }
            if (a[aPointer] <= b[bPointer]) continue;
            ++counter;
            ++bPointer;
        }
        int[] result = new int[counter += b.length - bPointer];
        counter = 0;
        aPointer = 0;
        bPointer = 0;
        while (aPointer < a.length && bPointer < b.length) {
            if (a[aPointer] == b[bPointer]) {
                ++aPointer;
                ++bPointer;
                continue;
            }
            if (a[aPointer] < b[bPointer]) {
                ++aPointer;
                continue;
            }
            if (a[aPointer] <= b[bPointer]) continue;
            result[counter++] = b[bPointer++];
        }
        System.arraycopy(b, bPointer, result, counter, b.length - bPointer);
        return result;
    }

    public static int[] intSetUnion(int[] a, int[] b) {
        int bPointer = 0;
        int aPointer = 0;
        int counter = 0;
        while (aPointer < a.length && bPointer < b.length) {
            if (a[aPointer] == b[bPointer]) {
                ++aPointer;
                ++bPointer;
                ++counter;
                continue;
            }
            if (a[aPointer] < b[bPointer]) {
                ++aPointer;
                ++counter;
                continue;
            }
            if (a[aPointer] <= b[bPointer]) continue;
            ++counter;
            ++bPointer;
        }
        int[] result = new int[counter += a.length - aPointer + (b.length - bPointer)];
        counter = 0;
        aPointer = 0;
        bPointer = 0;
        while (aPointer < a.length && bPointer < b.length) {
            if (a[aPointer] == b[bPointer]) {
                result[counter++] = b[bPointer];
                ++aPointer;
                ++bPointer;
                continue;
            }
            if (a[aPointer] < b[bPointer]) {
                result[counter++] = a[aPointer++];
                continue;
            }
            if (a[aPointer] <= b[bPointer]) continue;
            result[counter++] = b[bPointer++];
        }
        if (aPointer == a.length) {
            System.arraycopy(b, bPointer, result, counter, b.length - bPointer);
        } else {
            System.arraycopy(a, aPointer, result, counter, a.length - aPointer);
        }
        return result;
    }
}

