/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArray;
import java.util.Arrays;

public final class IntArrayList {
    int[] data;
    int size = 0;

    public IntArrayList() {
        this.data = new int[10];
    }

    public IntArrayList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public IntArrayList(IntArrayList list) {
        this.data = (int[])list.data.clone();
        this.size = list.size;
    }

    public IntArrayList(int[] data) {
        this.data = data;
        this.size = data.length;
    }

    private IntArrayList(int[] data, int size) {
        this.data = data;
        this.size = size;
    }

    public void clear() {
        this.size = 0;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    public void add(int num) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = num;
    }

    public void add(int position, int num) {
        if (position < 0 || position >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, position, this.data, position + 1, this.size - position);
        this.data[position] = num;
        ++this.size;
    }

    public void addAll(int[] arr) {
        int arrLen = arr.length;
        this.ensureCapacity(arrLen + this.size);
        System.arraycopy(arr, 0, this.data, this.size, arrLen);
        this.size += arrLen;
    }

    public void addAll(IntArray intArray) {
        this.addAll(intArray.innerArray);
    }

    public void addAll(IntArrayList intArrayList) {
        int arrLen = intArrayList.size();
        this.ensureCapacity(arrLen + this.size);
        System.arraycopy(intArrayList.data, 0, this.data, this.size, arrLen);
        this.size += arrLen;
    }

    public void set(int position, int num) {
        if (position < 0 || position >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[position] = num;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public void sort(IntArrayList cosort) {
        if (this.size != cosort.size) {
            throw new IllegalArgumentException();
        }
        ArraysUtils.quickSort(this.data, 0, this.size, cosort.data);
    }

    public void push(int value) {
        this.add(value);
    }

    public int peek() {
        return this.data[this.size - 1];
    }

    public int pop() {
        return this.data[--this.size];
    }

    public void add(int[] src, int fromIndex, int lenght) {
        this.ensureCapacity(this.size + lenght);
        System.arraycopy(src, fromIndex, this.data, this.size, lenght);
        this.size += lenght;
    }

    public int get(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[i];
    }

    public boolean replaceFirst(int from, int to) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != from) continue;
            this.data[i] = to;
            return true;
        }
        return false;
    }

    public boolean replaceAll(int from, int to) {
        boolean replaced = false;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != from) continue;
            this.data[i] = to;
            replaced = true;
        }
        return replaced;
    }

    public int[] toArray() {
        return Arrays.copyOfRange(this.data, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public boolean contains(int value) {
        return this.indexOf(value) >= 0;
    }

    public void removeAfter(int point) {
        if (point < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.size = point;
    }

    public int remove(int index) {
        int oldValue = this.data[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numMoved);
        }
        --this.size;
        return oldValue;
    }

    public boolean removeElement(int element) {
        int i = this.indexOf(element);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public boolean removeAll(IntArrayList c) {
        return this.removeAll(c, 0, c.size);
    }

    public boolean removeAll(IntArrayList c, int cbegin, int cend) {
        return this.removeAll(c.data, cbegin, cend);
    }

    public boolean removeAll(int[] c) {
        return this.removeAll(c, 0, c.length);
    }

    public boolean removeAll(int[] c, int cbegin, int cend) {
        int w = 0;
        boolean modified = false;
        for (int r = 0; r < this.size; ++r) {
            modified = false;
            for (int i = cbegin; i < cend; ++i) {
                if (c[i] != this.data[r]) continue;
                modified = true;
                break;
            }
            if (modified) continue;
            this.data[w++] = this.data[r];
        }
        if (w != this.size) {
            this.size = w;
            modified = true;
        }
        return modified;
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public IntArrayList clone() {
        return new IntArrayList(Arrays.copyOf(this.data, this.data.length), this.size);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntArrayList other = (IntArrayList)obj;
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        for (int i = 0; i < this.size; ++i) {
            hash = 31 * hash + this.data[i];
        }
        return hash;
    }

    public String toString() {
        int iMax = this.size() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.data[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

