/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.symmetrization;

import cc.redberry.core.groups.permutations.Permutation;
import cc.redberry.core.groups.permutations.PermutationGroup;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.Rational;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.FastTensors;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.ArrayIterator;
import cc.redberry.core.utils.TensorUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;

public final class SymmetrizeTransformation
implements Transformation {
    private final SimpleIndices indices;
    private final int[] indicesArray;
    private final int[] sortedIndicesNames;
    private final boolean multiplyBySymmetryFactor;
    private final PermutationGroup indicesGroup;
    private static final BigInteger SMALL_ORDER_MAX_VALUE = BigInteger.valueOf(1000L);

    public SymmetrizeTransformation(SimpleIndices indices, boolean multiplyBySymmetryFactor) {
        this.indices = indices;
        this.indicesArray = indices.toArray();
        this.sortedIndicesNames = IndicesUtils.getIndicesNames(indices);
        Arrays.sort(this.sortedIndicesNames);
        this.indicesGroup = indices.getSymmetries().getPermutationGroup();
        this.multiplyBySymmetryFactor = multiplyBySymmetryFactor;
    }

    @Override
    public Tensor transform(Tensor t) {
        BigInteger factor;
        Iterator<Permutation> cosetRepresentatives;
        Permutation[] reps;
        PermutationGroup union;
        PermutationGroup t_group;
        if (t.getIndices().size() == 0) {
            return t;
        }
        if (!SymmetrizeTransformation.containsSubIndices(t.getIndices(), this.indices)) {
            throw new IllegalArgumentException("Indices of specified tensor do not contain indices that should be symmetrized.");
        }
        if (t instanceof SimpleTensor) {
            t_group = this.conjugatedSymmetriesOfSubIndices(((SimpleTensor)t).getIndices());
            union = t_group.union(this.indicesGroup);
            reps = union.leftCosetRepresentatives(t_group);
            cosetRepresentatives = new ArrayIterator<Permutation>(reps);
            factor = BigInteger.valueOf(reps.length);
        } else if (this.indicesGroup.order().compareTo(SMALL_ORDER_MAX_VALUE) < 0) {
            cosetRepresentatives = this.indicesGroup.iterator();
            factor = this.indicesGroup.order();
        } else {
            t_group = PermutationGroup.createPermutationGroup(TensorUtils.findIndicesSymmetries(this.indices, t));
            union = t_group.union(this.indicesGroup);
            reps = union.leftCosetRepresentatives(t_group);
            cosetRepresentatives = new ArrayIterator<Permutation>(reps);
            factor = BigInteger.valueOf(reps.length);
        }
        SumBuilder sb = new SumBuilder();
        while (cosetRepresentatives.hasNext()) {
            Permutation permutation = cosetRepresentatives.next();
            sb.put(ApplyIndexMapping.applyIndexMappingAutomatically(t, new Mapping(this.indicesArray, permutation.permute(this.indicesArray), permutation.antisymmetry())));
        }
        t = sb.build();
        if (this.multiplyBySymmetryFactor) {
            Complex frac = new Complex(new Rational(BigInteger.ONE, factor));
            if (t instanceof Sum) {
                return FastTensors.multiplySumElementsOnFactor((Sum)t, frac);
            }
            return Tensors.multiply(frac, t);
        }
        return sb.build();
    }

    private static boolean containsSubIndices(Indices indices, Indices subIndices) {
        int[] indicesArray = IndicesUtils.getIndicesNames(indices);
        Arrays.sort(indicesArray);
        int size = subIndices.size();
        for (int i = 0; i < size; ++i) {
            if (Arrays.binarySearch(indicesArray, IndicesUtils.getNameWithType(subIndices.get(i))) >= 0) continue;
            return false;
        }
        return true;
    }

    private PermutationGroup conjugatedSymmetriesOfSubIndices(SimpleIndices allIndices) {
        int[] stabilizedPoints = new int[allIndices.size() - this.indices.size()];
        int[] nonStabilizedPoints = new int[this.indices.size()];
        int[] mapping = new int[this.indices.size()];
        int sPointer = 0;
        int nPointer = 0;
        for (int s = 0; s < allIndices.size(); ++s) {
            int index = Arrays.binarySearch(this.sortedIndicesNames, IndicesUtils.getNameWithType(allIndices.get(s)));
            if (index < 0) {
                stabilizedPoints[sPointer++] = s;
                continue;
            }
            nonStabilizedPoints[nPointer] = s;
            mapping[nPointer++] = index;
        }
        PermutationGroup result = allIndices.getSymmetries().getPermutationGroup().pointwiseStabilizerRestricted(stabilizedPoints);
        return result.conjugate(Permutations.createPermutation(mapping));
    }
}

