/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.substitutions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorField;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.substitutions.PrimitiveProductSubstitution;
import cc.redberry.core.transformations.substitutions.PrimitiveSimpleTensorSubstitution;
import cc.redberry.core.transformations.substitutions.PrimitiveSubstitution;
import cc.redberry.core.transformations.substitutions.PrimitiveSumSubstitution;
import cc.redberry.core.transformations.substitutions.PrimitiveTensorFieldSubstitution;
import cc.redberry.core.transformations.substitutions.SubstitutionIterator;
import cc.redberry.core.utils.TensorUtils;

public final class SubstitutionTransformation
implements Transformation {
    private final PrimitiveSubstitution[] primitiveSubstitutions;
    private final boolean applyIfModified;

    private SubstitutionTransformation(PrimitiveSubstitution[] primitiveSubstitutions, boolean applyIfModified) {
        this.primitiveSubstitutions = primitiveSubstitutions;
        this.applyIfModified = applyIfModified;
    }

    public SubstitutionTransformation(Expression[] expressions, boolean applyIfModified) {
        this.applyIfModified = applyIfModified;
        this.primitiveSubstitutions = new PrimitiveSubstitution[expressions.length];
        for (int i = expressions.length - 1; i >= 0; --i) {
            this.primitiveSubstitutions[i] = SubstitutionTransformation.createPrimitiveSubstitution(expressions[i].get(0), expressions[i].get(1));
        }
    }

    public SubstitutionTransformation(Expression expression) {
        this(expression.get(0), expression.get(1));
    }

    public SubstitutionTransformation(Expression ... expressions) {
        this(expressions, expressions.length == 1 ? !TensorUtils.shareSimpleTensors(expressions[0].get(0), expressions[0].get(1)) : false);
    }

    public SubstitutionTransformation(Tensor from, Tensor to, boolean applyIfModified) {
        SubstitutionTransformation.checkConsistence(from, to);
        this.primitiveSubstitutions = new PrimitiveSubstitution[1];
        this.primitiveSubstitutions[0] = SubstitutionTransformation.createPrimitiveSubstitution(from, to);
        this.applyIfModified = applyIfModified;
    }

    public SubstitutionTransformation(Tensor[] from, Tensor[] to) {
        this(from, to, from.length == 1 ? !TensorUtils.shareSimpleTensors(from[0], to[0]) : false);
    }

    public SubstitutionTransformation(Tensor from, Tensor to) {
        this(from, to, !TensorUtils.shareSimpleTensors(from, to));
    }

    public SubstitutionTransformation(Tensor[] from, Tensor[] to, boolean applyIfModified) {
        SubstitutionTransformation.checkConsistence(from, to);
        this.primitiveSubstitutions = new PrimitiveSubstitution[from.length];
        for (int i = 0; i < from.length; ++i) {
            this.primitiveSubstitutions[i] = SubstitutionTransformation.createPrimitiveSubstitution(from[i], to[i]);
        }
        this.applyIfModified = applyIfModified;
    }

    public SubstitutionTransformation asSimpleSubstitution() {
        SubstitutionTransformation ss = new SubstitutionTransformation((PrimitiveSubstitution[])this.primitiveSubstitutions.clone(), this.applyIfModified);
        for (int i = this.primitiveSubstitutions.length - 1; i >= 0; --i) {
            ss.primitiveSubstitutions[i] = new PrimitiveSimpleTensorSubstitution(ss.primitiveSubstitutions[i].from, ss.primitiveSubstitutions[i].to);
        }
        return ss;
    }

    private static void checkConsistence(Tensor[] from, Tensor[] to) {
        if (from.length != to.length) {
            throw new IllegalArgumentException("from array and to array have different length.");
        }
        for (int i = from.length - 1; i >= 0; --i) {
            SubstitutionTransformation.checkConsistence(from[i], to[i]);
        }
    }

    private static void checkConsistence(Tensor from, Tensor to) {
        if (!TensorUtils.isZeroOrIndeterminate(to) && !from.getIndices().getFree().equalsRegardlessOrder(to.getIndices().getFree())) {
            throw new IllegalArgumentException("Tensor from free indices not equal to tensor to free indices: " + from.getIndices().getFree() + "  " + to.getIndices().getFree());
        }
    }

    private static PrimitiveSubstitution createPrimitiveSubstitution(Tensor from, Tensor to) {
        if (from.getClass() == SimpleTensor.class) {
            return new PrimitiveSimpleTensorSubstitution(from, to);
        }
        if (from.getClass() == TensorField.class) {
            boolean argumentIsNotSimple = false;
            for (Tensor t : from) {
                if (t instanceof SimpleTensor) continue;
                argumentIsNotSimple = true;
                break;
            }
            if (argumentIsNotSimple) {
                return new PrimitiveSimpleTensorSubstitution(from, to);
            }
            return new PrimitiveTensorFieldSubstitution(from, to);
        }
        if (from.getClass() == Product.class) {
            if (from.size() == 2 && from.get(0) instanceof Complex) {
                to = Tensors.divide(to, from.get(0));
                from = from.get(1);
                return SubstitutionTransformation.createPrimitiveSubstitution(from, to);
            }
            return new PrimitiveProductSubstitution(from, to);
        }
        if (from.getClass() == Sum.class) {
            return new PrimitiveSumSubstitution(from, to);
        }
        return new PrimitiveSimpleTensorSubstitution(from, to);
    }

    @Override
    public Tensor transform(Tensor t) {
        Tensor current;
        SubstitutionIterator iterator = new SubstitutionIterator(t);
        while ((current = iterator.next()) != null) {
            if (!this.applyIfModified && iterator.isCurrentModified()) continue;
            Tensor old = current;
            boolean supposeIndicesAreAdded = false;
            for (PrimitiveSubstitution primitiveSubstitution : this.primitiveSubstitutions) {
                current = primitiveSubstitution.newTo(old, iterator);
                if (current != old) {
                    supposeIndicesAreAdded |= primitiveSubstitution.possiblyAddsDummies;
                    if (!this.applyIfModified) break;
                }
                old = current;
            }
            iterator.set(current, supposeIndicesAreAdded);
        }
        return iterator.result();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        int i = 0;
        while (true) {
            PrimitiveSubstitution tr = this.primitiveSubstitutions[i];
            builder.append(tr.from).append(" -> ").append(tr.to);
            if (i == this.primitiveSubstitutions.length - 1) break;
            builder.append(',');
            ++i;
        }
        return builder.append('}').toString();
    }
}

