/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.reverse;

import cc.redberry.core.context.CC;
import cc.redberry.core.graph.GraphType;
import cc.redberry.core.graph.PrimitiveSubgraph;
import cc.redberry.core.graph.PrimitiveSubgraphPartition;
import cc.redberry.core.indexmapping.IndexMapping;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.ArraysUtils;
import java.util.Arrays;

public final class ReverseTransformation
implements Transformation {
    private final IndexType type;

    public ReverseTransformation(IndexType type) {
        ReverseTransformation.assertType(type);
        this.type = type;
    }

    @Override
    public Tensor transform(Tensor t) {
        return ReverseTransformation.inverseOrderOfMatrices1(t, this.type);
    }

    public static void assertType(IndexType type) {
        if (CC.isMetric(type.getType())) {
            throw new IllegalArgumentException("Type should be non-metric.");
        }
    }

    public static Tensor inverseOrderOfMatrices(Tensor t, IndexType type) {
        ReverseTransformation.assertType(type);
        return ReverseTransformation.inverseOrderOfMatrices1(t, type);
    }

    private static Tensor inverseOrderOfMatrices1(Tensor t, IndexType type) {
        Tensor c;
        FromChildToParentIterator iterator = new FromChildToParentIterator(t);
        while ((c = iterator.next()) != null) {
            if (!(c instanceof Product)) continue;
            iterator.set(ReverseTransformation.inverseOrderInProduct((Product)c, type));
        }
        return iterator.result();
    }

    private static Tensor inverseOrderInProduct(Product product, IndexType type) {
        ProductContent pc = product.getContent();
        PrimitiveSubgraph[] subgraphs = PrimitiveSubgraphPartition.calculatePartition(pc, type);
        Tensor[] data = pc.getDataCopy();
        boolean somethingDone = false;
        for (PrimitiveSubgraph ps : subgraphs) {
            if (ps.getGraphType() == GraphType.Graph) {
                throw new IllegalArgumentException("Not a product of matrices.");
            }
            if (ps.getGraphType() != GraphType.Line) continue;
            int[] partition = ps.getPartition();
            Tensor left = null;
            Tensor right = null;
            Indices leftIndices = null;
            Indices rightIndices = null;
            Indices leftSubIndices = null;
            Indices rightSubIndices = null;
            int luCount = -1;
            boolean leftSkip = false;
            boolean rightSkip = false;
            boolean leftMatrix = false;
            boolean rightMatrix = false;
            int leftPointer = 0;
            for (int rightPointer = partition.length - 1; leftPointer < rightPointer; ++leftPointer, --rightPointer) {
                if (!leftSkip) {
                    int leftLowerCount;
                    left = data[partition[leftPointer]];
                    leftIndices = left.getIndices();
                    leftSubIndices = leftIndices.getOfType(type);
                    int leftUpperCount = leftSubIndices.getUpper().size();
                    if (leftUpperCount != (leftLowerCount = leftSubIndices.getLower().size())) {
                        if (leftLowerCount != 0 && leftUpperCount != 0) {
                            throw new IllegalArgumentException("Not a product of matrices.");
                        }
                        leftMatrix = false;
                    } else {
                        if (luCount == -1) {
                            luCount = leftUpperCount;
                        } else if (luCount != leftUpperCount) {
                            throw new IllegalArgumentException("Not a product of matrices.");
                        }
                        leftMatrix = true;
                    }
                }
                if (!rightSkip) {
                    int rightLowerCount;
                    right = data[partition[rightPointer]];
                    rightIndices = right.getIndices();
                    rightSubIndices = rightIndices.getOfType(type);
                    int rightUpperCount = rightSubIndices.getUpper().size();
                    if (rightUpperCount != (rightLowerCount = rightSubIndices.getLower().size())) {
                        if (rightUpperCount != 0 && rightLowerCount != 0) {
                            throw new IllegalArgumentException("Not a product of matrices.");
                        }
                        rightMatrix = false;
                    } else {
                        if (luCount == -1) {
                            luCount = rightUpperCount;
                        } else if (luCount != rightUpperCount) {
                            throw new IllegalArgumentException("Not a product of matrices.");
                        }
                        rightMatrix = true;
                    }
                }
                rightSkip = false;
                leftSkip = false;
                if (!leftMatrix && !rightMatrix) continue;
                if (leftMatrix && !rightMatrix) {
                    leftSkip = true;
                    --leftPointer;
                    continue;
                }
                if (!leftMatrix && rightMatrix) {
                    rightSkip = true;
                    ++rightPointer;
                    continue;
                }
                somethingDone = true;
                left = ReverseTransformation.setIndices(left, leftIndices, ReverseTransformation.renameOfType(leftIndices, leftSubIndices, rightSubIndices));
                data[partition[leftPointer]] = right = ReverseTransformation.setIndices(right, rightIndices, ReverseTransformation.renameOfType(rightIndices, rightSubIndices, leftSubIndices));
                data[partition[rightPointer]] = left;
            }
        }
        if (!somethingDone) {
            return product;
        }
        return Tensors.multiply(product.getIndexlessSubProduct(), Tensors.multiply(data));
    }

    private static Tensor setIndices(Tensor t, Indices from, Indices to) {
        return ApplyIndexMapping.applyIndexMapping(t, new Mapping(from.getAllIndices().copy(), to.getAllIndices().copy()), new int[0]);
    }

    private static final Indices renameOfType(Indices indices, Indices fromSubIndices, Indices toSubIndices) {
        return indices.applyIndexMapping(new Mapper(fromSubIndices, toSubIndices));
    }

    private static final class Mapper
    implements IndexMapping {
        private final int[] from;
        private final int[] to;

        private Mapper(Indices fromSubIndices, Indices toSubIndices) {
            this.from = fromSubIndices.getAllIndices().copy();
            this.to = toSubIndices.getAllIndices().copy();
            ArraysUtils.quickSort(this.from, this.to);
        }

        @Override
        public int map(int from) {
            int position = Arrays.binarySearch(this.from, from);
            if (position >= 0) {
                return this.to[position];
            }
            return from;
        }
    }
}

