/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.powerexpand;

import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.powerexpand.PowerExpandUtils;
import cc.redberry.core.transformations.substitutions.SubstitutionIterator;
import cc.redberry.core.utils.Indicator;

public final class PowerUnfoldTransformation
implements Transformation {
    public static final PowerUnfoldTransformation POWER_UNFOLD_TRANSFORMATION = new PowerUnfoldTransformation();
    private final Indicator<Tensor> toExpandIndicator;

    private PowerUnfoldTransformation() {
        this(Indicator.TRUE_INDICATOR);
    }

    public PowerUnfoldTransformation(Indicator<Tensor> toExpandIndicator) {
        this.toExpandIndicator = toExpandIndicator;
    }

    public PowerUnfoldTransformation(SimpleTensor[] vars) {
        this(Indicator.Utils.iterativeIndicator(PowerExpandUtils.varsToIndicator(vars)));
    }

    @Override
    public Tensor transform(Tensor t) {
        Tensor c;
        SubstitutionIterator iterator = new SubstitutionIterator(t);
        while ((c = iterator.next()) != null) {
            if (!PowerExpandUtils.powerUnfoldApplicable(c, this.toExpandIndicator)) continue;
            iterator.set(Tensors.multiply(PowerExpandUtils.powerExpandIntoChainToArray1(c, iterator.getForbidden(), this.toExpandIndicator)));
        }
        return iterator.result();
    }
}

