/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.powerexpand;

import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.powerexpand.PowerExpandUtils;
import cc.redberry.core.utils.Indicator;

public final class PowerExpandTransformation
implements Transformation {
    public static final PowerExpandTransformation POWER_EXPAND_TRANSFORMATION = new PowerExpandTransformation();
    private final Indicator<Tensor> toExpandIndicator;

    private PowerExpandTransformation() {
        this(Indicator.TRUE_INDICATOR);
    }

    public PowerExpandTransformation(Indicator<Tensor> toExpandIndicator) {
        this.toExpandIndicator = toExpandIndicator;
    }

    public PowerExpandTransformation(SimpleTensor ... vars) {
        this(PowerExpandUtils.varsToIndicator(vars));
    }

    @Override
    public Tensor transform(Tensor t) {
        Tensor c;
        FromChildToParentIterator iterator = new FromChildToParentIterator(t);
        while ((c = iterator.next()) != null) {
            if (!PowerExpandUtils.powerExpandApplicable(c, this.toExpandIndicator)) continue;
            iterator.set(Tensors.multiply(PowerExpandUtils.powerExpandToArray1(c, this.toExpandIndicator)));
        }
        return iterator.result();
    }
}

