/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GCDFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.Quotient;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.QuotientRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeFiniteFieldCharP;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeInfiniteAlgebraicFieldCharP;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class SquarefreeFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeAbstract<C> {
    protected final RingFactory<C> coFac;
    protected final AlgebraicNumberRing<C> aCoFac;
    protected final QuotientRing<C> qCoFac;

    public SquarefreeFieldCharP(RingFactory<C> fac) {
        super(GCDFactory.getProxy(fac));
        if (!fac.isField()) {
            // empty if block
        }
        if (fac.characteristic().signum() == 0) {
            throw new IllegalArgumentException("characterisic(fac) must be non-zero");
        }
        this.coFac = fac;
        RingFactory<C> oFac = this.coFac;
        if (oFac instanceof AlgebraicNumberRing) {
            this.aCoFac = (AlgebraicNumberRing)oFac;
            this.qCoFac = null;
        } else {
            this.aCoFac = null;
            this.qCoFac = oFac instanceof QuotientRing ? (QuotientRing)oFac : null;
        }
    }

    public String toString() {
        return this.getClass().getName() + " with " + this.engine + " over " + this.coFac;
    }

    @Override
    public GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> s = pfac.getONE();
        SortedMap<GenPolynomial<C>, Long> factors = this.baseSquarefreeFactors(P);
        for (GenPolynomial<C> sp : factors.keySet()) {
            s = s.multiply((GenPolynomial<GenPolynomial<C>>)sp);
        }
        return s.monic();
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> A) {
        TreeMap<GenPolynomial<C>, Long> sfactors = new TreeMap<GenPolynomial<C>, Long>();
        if (A == null || A.isZERO()) {
            return sfactors;
        }
        GenPolynomialRing pfac = A.ring;
        if (A.isConstant()) {
            GcdRingElem coeff = (GcdRingElem)A.leadingBaseCoefficient();
            SortedMap<GcdRingElem, Long> rfactors = this.squarefreeFactors(coeff);
            if (rfactors != null && rfactors.size() > 0) {
                for (Map.Entry<GcdRingElem, Long> me : rfactors.entrySet()) {
                    GcdRingElem c = me.getKey();
                    if (c.isONE()) continue;
                    GenPolynomial<GcdRingElem> cr = ((GenPolynomial)pfac.getONE()).multiply(c);
                    Long rk = me.getValue();
                    sfactors.put(cr, rk);
                }
            } else {
                sfactors.put(A, 1L);
            }
            return sfactors;
        }
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GcdRingElem ldbcf = (GcdRingElem)A.leadingBaseCoefficient();
        if (!ldbcf.isONE()) {
            A = A.divide(ldbcf);
            SortedMap<GcdRingElem, Long> rfactors = this.squarefreeFactors(ldbcf);
            if (rfactors != null && rfactors.size() > 0) {
                for (Map.Entry<GcdRingElem, Long> me : rfactors.entrySet()) {
                    GcdRingElem c = me.getKey();
                    if (c.isONE()) continue;
                    GenPolynomial<GcdRingElem> cr = ((GenPolynomial)pfac.getONE()).multiply(c);
                    Long rk = me.getValue();
                    sfactors.put(cr, rk);
                }
            } else {
                GenPolynomial<GcdRingElem> f1 = ((GenPolynomial)pfac.getONE()).multiply(ldbcf);
                sfactors.put(f1, 1L);
            }
            ldbcf = (GcdRingElem)pfac.coFac.getONE();
        }
        AbelianGroupElem T0 = A;
        long e = 1L;
        GenPolynomial<C> T = null;
        GenPolynomial<C> V = null;
        long k = 0L;
        long mp = 0L;
        boolean init = true;
        while (true) {
            if (init) {
                if (T0.isConstant() || T0.isZERO()) break;
                GenPolynomial<C> Tp = PolyUtil.baseDeriviative(T0);
                T = this.engine.baseGcd(T0, Tp);
                T = T.monic();
                V = PolyUtil.basePseudoDivide(T0, T);
                k = 0L;
                mp = 0L;
                init = false;
            }
            if (V.isConstant()) {
                mp = pfac.characteristic().longValue();
                T0 = this.baseRootCharacteristic(T);
                if (T0 == null) {
                    T0 = pfac.getZERO();
                }
                e *= mp;
                init = true;
                continue;
            }
            if (mp != 0L && ++k % mp == 0L) {
                T = PolyUtil.basePseudoDivide(T, V);
                ++k;
            }
            GenPolynomial<C> W = this.engine.baseGcd(T, V);
            W = W.monic();
            GenPolynomial<C> z = PolyUtil.basePseudoDivide(V, W);
            V = W;
            T = PolyUtil.basePseudoDivide(T, V);
            if (z.degree(0) <= 0L) continue;
            if (ldbcf.isONE() && !((GcdRingElem)z.leadingBaseCoefficient()).isONE()) {
                z = z.monic();
            }
            sfactors.put(z, e * k);
        }
        return sfactors;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for multivariate polynomials");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>> s = pfac.getONE();
        SortedMap<GenPolynomial<GenPolynomial<C>>, Long> factors = this.recursiveUnivariateSquarefreeFactors(P);
        for (GenPolynomial<GenPolynomial<C>> sp : factors.keySet()) {
            s = s.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)sp);
        }
        return PolyUtil.monic(s);
    }

    @Override
    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> P) {
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> sfactors = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (P == null || P.isZERO()) {
            return sfactors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing cfac = (GenPolynomialRing)pfac.coFac;
        GcdRingElem ldbcf = (GcdRingElem)P.leadingBaseCoefficient().leadingBaseCoefficient();
        if (!ldbcf.isONE()) {
            GenPolynomial<GcdRingElem> lc = ((GenPolynomial)cfac.getONE()).multiply(ldbcf);
            GenPolynomial<GenPolynomial<GcdRingElem>> pl = ((GenPolynomial)pfac.getONE()).multiply(lc);
            sfactors.put(pl, 1L);
            GcdRingElem li = (GcdRingElem)ldbcf.inverse();
            P = P.multiply((GenPolynomial<Object>)((GenPolynomial<GenPolynomial<Object>>)((GenPolynomial)cfac.getONE()).multiply(li)));
        }
        GenPolynomial Pc = this.engine.recursiveContent(P);
        if (!(Pc = Pc.monic()).isONE()) {
            P = PolyUtil.coefficientPseudoDivide(P, Pc);
        }
        SortedMap rsf = this.squarefreeFactors((C)Pc);
        for (Map.Entry entry : rsf.entrySet()) {
            GenPolynomial c = (GenPolynomial)entry.getKey();
            if (c.isONE()) continue;
            GenPolynomial<GenPolynomial> cr = ((GenPolynomial)pfac.getONE()).multiply(c);
            Long rk = (Long)entry.getValue();
            sfactors.put(cr, rk);
        }
        AbelianGroupElem<GenPolynomial<GenPolynomial<Object>>> T0 = P;
        long l = 1L;
        GenPolynomial T = null;
        GenPolynomial V = null;
        long k = 0L;
        long mp = 0L;
        boolean init = true;
        while (true) {
            if (init) {
                if (T0.isConstant() || T0.isZERO()) break;
                GenPolynomial Tp = PolyUtil.recursiveDeriviative(T0);
                T = this.engine.recursiveUnivariateGcd(T0, Tp);
                T = PolyUtil.monic(T);
                V = PolyUtil.recursivePseudoDivide(T0, T);
                k = 0L;
                mp = 0L;
                init = false;
            }
            if (V.isConstant()) {
                mp = pfac.characteristic().longValue();
                T0 = this.recursiveUnivariateRootCharacteristic(T);
                if (T0 == null) {
                    T0 = pfac.getZERO();
                }
                l *= mp;
                init = true;
            }
            if (mp != 0L && ++k % mp == 0L) {
                T = PolyUtil.recursivePseudoDivide(T, V);
                ++k;
            }
            GenPolynomial W = this.engine.recursiveUnivariateGcd(T, V);
            W = PolyUtil.monic(W);
            GenPolynomial z = PolyUtil.recursivePseudoDivide(V, W);
            V = W;
            T = PolyUtil.recursivePseudoDivide(T, V);
            if (z.isONE() || z.isZERO()) continue;
            z = PolyUtil.monic(z);
            sfactors.put(z, l * k);
        }
        if (sfactors.size() == 0) {
            sfactors.put((GenPolynomial<GenPolynomial<C>>)pfac.getONE(), 1L);
        }
        return sfactors;
    }

    @Override
    public GenPolynomial<C> squarefreePart(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseSquarefreePart(P);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> s = pfac.getONE();
        SortedMap<GenPolynomial<C>, Long> factors = this.squarefreeFactors((C)P);
        for (GenPolynomial<C> sp : factors.keySet()) {
            if (sp.isConstant()) continue;
            s = s.multiply((GenPolynomial<GenPolynomial<C>>)sp);
        }
        return s.monic();
    }

    @Override
    public SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseSquarefreeFactors(P);
        }
        TreeMap<GenPolynomial<C>, Long> sfactors = new TreeMap<GenPolynomial<C>, Long>();
        if (P.isZERO()) {
            return sfactors;
        }
        GenPolynomialRing cfac = pfac.contract(1);
        GenPolynomialRing rfac = new GenPolynomialRing(cfac, 1);
        GenPolynomial Pr = PolyUtil.recursive(rfac, P);
        SortedMap PP = this.recursiveUnivariateSquarefreeFactors(Pr);
        for (Map.Entry m : PP.entrySet()) {
            Long i = m.getValue();
            GenPolynomial Dr = m.getKey();
            GenPolynomial D = PolyUtil.distribute(pfac, Dr);
            sfactors.put(D, i);
        }
        return sfactors;
    }

    @Override
    public SortedMap<C, Long> squarefreeFactors(C coeff) {
        if (coeff == null) {
            return null;
        }
        TreeMap<Object, Long> factors = new TreeMap<Object, Long>();
        RingFactory cfac = (RingFactory)coeff.factory();
        if (this.aCoFac != null) {
            AlgebraicNumber an = (AlgebraicNumber)coeff;
            if (cfac.isFinite()) {
                SquarefreeFiniteFieldCharP reng = (SquarefreeFiniteFieldCharP)SquarefreeFactory.getImplementation(cfac);
                SortedMap<C, Long> rfactors = reng.rootCharacteristic(coeff);
                factors.putAll(rfactors);
            } else {
                SquarefreeInfiniteAlgebraicFieldCharP reng = (SquarefreeInfiniteAlgebraicFieldCharP)SquarefreeFactory.getImplementation(cfac);
                SortedMap rfactors = reng.squarefreeFactors(an);
                for (Map.Entry me : rfactors.entrySet()) {
                    AlgebraicNumber c = me.getKey();
                    if (c.isONE()) continue;
                    AlgebraicNumber cr = c;
                    Long rk = me.getValue();
                    factors.put(cr, rk);
                }
            }
        } else if (this.qCoFac != null) {
            Quotient q = (Quotient)coeff;
            SquarefreeInfiniteFieldCharP reng = (SquarefreeInfiniteFieldCharP)SquarefreeFactory.getImplementation(cfac);
            SortedMap rfactors = reng.squarefreeFactors(q);
            for (Map.Entry me : rfactors.entrySet()) {
                Quotient c = me.getKey();
                if (c.isONE()) continue;
                Quotient cr = c;
                Long rk = me.getValue();
                factors.put(cr, rk);
            }
        } else if (cfac.isFinite()) {
            SquarefreeFiniteFieldCharP reng = (SquarefreeFiniteFieldCharP)SquarefreeFactory.getImplementation(cfac);
            SortedMap<C, Long> rfactors = reng.rootCharacteristic(coeff);
            factors.putAll(rfactors);
        }
        return factors;
    }

    public abstract GenPolynomial<C> baseRootCharacteristic(GenPolynomial<C> var1);

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<C>> var1);
}

