/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GreatestCommonDivisorAbstract;

public class GreatestCommonDivisorPrimitive<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    @Override
    public GenPolynomial<C> baseGcd(GenPolynomial<C> P, GenPolynomial<C> S) {
        AbelianGroupElem<GenPolynomial<C>> q;
        AbelianGroupElem<GenPolynomial<C>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        r = ((GenPolynomial)r).abs();
        q = ((GenPolynomial)q).abs();
        C a = this.baseContent(r);
        C b = this.baseContent(q);
        C c = this.gcd(a, b);
        r = this.divide(r, a);
        q = this.divide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply((GenPolynomial<C>)c);
        }
        if (((GenPolynomial)q).isONE()) {
            return ((GenPolynomial)q).multiply((GenPolynomial<C>)c);
        }
        while (!((GenPolynomial)r).isZERO()) {
            GenPolynomial<GenPolynomial<C>> x = PolyUtil.baseSparsePseudoRemainder(q, r);
            q = r;
            r = this.basePrimitivePart(x);
        }
        return ((GenPolynomial)q).multiply((GenPolynomial<C>)c).abs();
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        AbelianGroupElem<GenPolynomial<Object>> q;
        AbelianGroupElem<GenPolynomial<Object>> r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        r = ((GenPolynomial)r).abs();
        q = q.abs();
        GenPolynomial<C> a = this.recursiveContent(r);
        GenPolynomial<C> b = this.recursiveContent(q);
        GenPolynomial<C> c = this.gcd(a, b);
        r = PolyUtil.recursiveDivide(r, a);
        q = PolyUtil.recursiveDivide(q, b);
        if (((GenPolynomial)r).isONE()) {
            return ((GenPolynomial)r).multiply(c);
        }
        if (q.isONE()) {
            return q.multiply(c);
        }
        while (!((GenPolynomial)r).isZERO()) {
            GenPolynomial x = PolyUtil.recursivePseudoRemainder(q, r);
            q = r;
            r = this.recursivePrimitivePart(x);
        }
        return ((GenPolynomial)q.abs()).multiply(c);
    }
}

