/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModIntegerRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModLong;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModLongRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.Modular;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModularRingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.PrimeList;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.OptimizedPolynomialList;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.TermOrderOptimization;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Power;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GCDFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.GreatestCommonDivisorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.HenselApprox;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.HenselMultUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.HenselUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.NoLiftingException;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.TrialParts;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.util.KsubSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;

public class FactorInteger<MOD extends GcdRingElem<MOD> & Modular>
extends FactorAbstract<BigInteger> {
    private final boolean debug = false;
    protected final FactorAbstract<MOD> mfactor;
    protected final GreatestCommonDivisorAbstract<MOD> mengine;

    public FactorInteger() {
        this(BigInteger.ONE);
    }

    public FactorInteger(RingFactory<BigInteger> cfac) {
        super(cfac);
        ModLongRing mcofac = new ModLongRing(13L, true);
        this.mfactor = FactorFactory.getImplementation(mcofac);
        this.mengine = GCDFactory.getImplementation(mcofac);
    }

    @Override
    public List<GenPolynomial<BigInteger>> baseFactorsSquarefree(GenPolynomial<BigInteger> P) {
        int s;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        List<GenPolynomial<BigInteger>> factors = new ArrayList<GenPolynomial<BigInteger>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.isONE()) {
            factors.add(P);
            return factors;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " only for univariate polynomials");
        }
        if (!this.engine.baseContent(P).isONE()) {
            throw new IllegalArgumentException(this.getClass().getName() + " P not primitive");
        }
        if (P.degree(0) <= 1L) {
            factors.add(P);
            return factors;
        }
        BigInteger an = P.maxNorm();
        BigInteger ac = P.leadingBaseCoefficient();
        ExpVector degv = P.degreeVector();
        int degi = (int)P.degree(0);
        BigInteger M = an.multiply(PolyUtil.factorBound(degv));
        M = M.multiply(ac.abs().multiply(ac.fromInteger(8L)));
        PrimeList primes = new PrimeList(PrimeList.Range.small);
        int pn = 30;
        GenPolynomial<MonoidElem> am = null;
        GenPolynomialRing<ModLong> mfac = null;
        int TT = 5;
        List[] modfac = new List[5];
        List[] intfac = new List[5];
        List mlist = null;
        List ilist = null;
        int i = 0;
        Iterator<java.math.BigInteger> pit = primes.iterator();
        pit.next();
        pit.next();
        MonoidElem nf = null;
        for (int k = 0; k < 5; ++k) {
            if (k == 4) {
                primes = new PrimeList(PrimeList.Range.medium);
                pit = primes.iterator();
            }
            if (k == 6) {
                primes = new PrimeList(PrimeList.Range.large);
                pit = primes.iterator();
            }
            while (pit.hasNext()) {
                GenPolynomial<MonoidElem> g;
                GenPolynomial<MonoidElem> ap;
                java.math.BigInteger p = pit.next();
                if (++i >= pn) {
                    throw new ArithmeticException("prime list exhausted");
                }
                ModularRingFactory<ModLong> cofac = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
                nf = (GcdRingElem)cofac.fromInteger(ac.getVal());
                if (nf.isZERO() || !(am = PolyUtil.fromIntegerCoefficients(mfac = new GenPolynomialRing<ModLong>(cofac, pfac), P)).degreeVector().equals(degv) || (ap = PolyUtil.baseDeriviative(am)).isZERO() || !(g = this.mengine.baseGcd(am, ap)).isONE()) continue;
                break;
            }
            if (!nf.isONE()) {
                am = am.divide(nf);
            }
            if ((mlist = this.mfactor.baseFactorsSquarefree(am)).size() <= 1) {
                factors.add(P);
                return factors;
            }
            if (!nf.isONE()) {
                GenPolynomial<MonoidElem> mp = mfac.getONE();
                mp = mp.multiply(nf);
                mlist.add(0, mp);
            }
            modfac[k] = mlist;
        }
        int min = Integer.MAX_VALUE;
        BitSet AD = null;
        for (int k = 0; k < 5; ++k) {
            List<ExpVector> ev = PolyUtil.leadingExpVector(modfac[k]);
            BitSet D = this.factorDegrees(ev, degi);
            if (AD == null) {
                AD = D;
            } else {
                AD.and(D);
            }
            s = modfac[k].size();
            if (s >= min) continue;
            min = s;
            mlist = modfac[k];
        }
        if (mlist.size() <= 1) {
            factors.add(P);
            return factors;
        }
        if (AD.cardinality() <= 2) {
            factors.add(P);
            return factors;
        }
        boolean allLists = false;
        if (allLists) {
            for (int k = 0; k < 5; ++k) {
                mlist = modfac[k];
                if (P.leadingBaseCoefficient().isONE()) {
                    factors = this.searchFactorsMonic(P, M, mlist, AD);
                    if (factors.size() == 1) {
                        factors = this.searchFactorsNonMonic(P, M, mlist, AD);
                    }
                } else {
                    factors = this.searchFactorsNonMonic(P, M, mlist, AD);
                }
                intfac[k] = factors;
            }
        } else {
            if (P.leadingBaseCoefficient().isONE()) {
                long t = System.currentTimeMillis();
                try {
                    mlist = PolyUtil.monic(mlist);
                    factors = this.searchFactorsMonic(P, M, mlist, AD);
                }
                catch (RuntimeException e) {
                    factors = this.searchFactorsNonMonic(P, M, mlist, AD);
                }
            } else {
                long t = System.currentTimeMillis();
                factors = this.searchFactorsNonMonic(P, M, mlist, AD);
            }
            return this.normalizeFactorization(factors);
        }
        int max = 0;
        for (int k = 0; k < 5; ++k) {
            s = intfac[k].size();
            if (s <= max) continue;
            max = s;
            ilist = intfac[k];
        }
        factors = this.normalizeFactorization(ilist);
        return factors;
    }

    public BitSet factorDegrees(List<ExpVector> E, int deg) {
        BitSet D = new BitSet(deg + 1);
        D.set(0);
        for (ExpVector e : E) {
            int i = (int)e.getVal(0);
            BitSet s = new BitSet(deg + 1);
            for (int k = 0; k < deg + 1 - i; ++k) {
                s.set(i + k, D.get(k));
            }
            D.or(s);
        }
        return D;
    }

    public static <C extends RingElem<C>> long degreeSum(List<GenPolynomial<C>> L) {
        long s = 0L;
        for (GenPolynomial<C> p : L) {
            ExpVector e = p.leadingExpVector();
            long d = e.getVal(0);
            s += d;
        }
        return s;
    }

    List<GenPolynomial<BigInteger>> searchFactorsMonic(GenPolynomial<BigInteger> C, BigInteger M, List<GenPolynomial<MOD>> F, BitSet D) {
        List<GenPolynomial<Object>> lift;
        if (C == null || C.isZERO() || F == null || F.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing<BigInteger> pfac = C.ring;
        if (pfac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList factors = new ArrayList(F.size());
        List<GenPolynomial<MOD>> mlist = F;
        GenPolynomial<MOD> ct = mlist.get(0);
        if (ct.isConstant()) {
            mlist.remove(ct);
            if (mlist.size() <= 1) {
                factors.add(C);
                return factors;
            }
        }
        ModularRingFactory mcfac = (ModularRingFactory)ct.ring.coFac;
        BigInteger m = mcfac.getIntegerModul();
        long k = 1L;
        BigInteger pi = m;
        while (pi.compareTo(M) < 0) {
            ++k;
            pi = pi.multiply(m);
        }
        GenPolynomial<BigInteger> PP = C;
        GenPolynomial<BigInteger> P = C;
        try {
            lift = HenselUtil.liftHenselMonic(PP, mlist, k);
        }
        catch (NoLiftingException e) {
            throw new RuntimeException(e);
        }
        GenPolynomialRing mpfac = lift.get((int)0).ring;
        int dl = (lift.size() + 1) / 2;
        GenPolynomial<BigInteger> u = PP;
        long deg = (u.degree(0) + 1L) / 2L;
        block3: for (int j = 1; j <= dl; ++j) {
            KsubSet<GenPolynomial<MOD>> ps = new KsubSet<GenPolynomial<MOD>>(lift, j);
            for (List list : ps) {
                if (!D.get((int)FactorInteger.degreeSum(list))) continue;
                GenPolynomial mtrial = Power.multiply(mpfac, list);
                if (mtrial.degree(0) > deg) {
                    // empty if block
                }
                GenPolynomial<BigInteger> trial = PolyUtil.integerFromModularCoefficients(pfac, mtrial);
                if (!PolyUtil.baseSparsePseudoRemainder(u, trial = this.engine.basePrimitivePart(trial)).isZERO()) continue;
                factors.add(trial);
                u = PolyUtil.basePseudoDivide(u, trial);
                lift = FactorInteger.removeOnce(lift, list);
                dl = (lift.size() + 1) / 2;
                j = 0;
                continue block3;
            }
        }
        if (!u.isONE() && !u.equals(P)) {
            factors.add(u);
        }
        if (factors.size() == 0) {
            factors.add(PP);
        }
        return this.normalizeFactorization(factors);
    }

    List<GenPolynomial<BigInteger>> searchFactorsNonMonic(GenPolynomial<BigInteger> C, BigInteger M, List<GenPolynomial<MOD>> F, BitSet D) {
        GcdRingElem nf;
        if (C == null || C.isZERO() || F == null || F.size() == 0) {
            throw new IllegalArgumentException("C must be nonzero and F must be nonempty");
        }
        GenPolynomialRing pfac = C.ring;
        if (pfac.nvar != 1) {
            throw new IllegalArgumentException("polynomial ring not univariate");
        }
        ArrayList factors = new ArrayList(F.size());
        List<GenPolynomial<Object>> mlist = F;
        GenPolynomial<MOD> ct = mlist.get(0);
        if (ct.isConstant()) {
            nf = (GcdRingElem)ct.leadingBaseCoefficient();
            mlist.remove(ct);
            if (mlist.size() <= 1) {
                factors.add(C);
                return factors;
            }
        } else {
            nf = (GcdRingElem)ct.ring.coFac.getONE();
        }
        GenPolynomialRing mfac = ct.ring;
        GenPolynomial<GcdRingElem> Pm = PolyUtil.fromIntegerCoefficients(mfac, C);
        GenPolynomial<BigInteger> PP = C;
        GenPolynomial<BigInteger> P = C;
        int dl = (mlist.size() + 1) / 2;
        GenPolynomial<BigInteger> u = PP;
        long deg = (u.degree(0) + 1L) / 2L;
        GenPolynomial<GcdRingElem> um = Pm;
        block2: for (int j = 1; j <= dl; ++j) {
            KsubSet<GenPolynomial<MOD>> ps = new KsubSet<GenPolynomial<MOD>>(mlist, j);
            for (List list : ps) {
                HenselApprox<GcdRingElem> ilist;
                if (!D.get((int)FactorInteger.degreeSum(list))) continue;
                GenPolynomial trial = ((GenPolynomial)mfac.getONE()).multiply(nf);
                for (GenPolynomial fk : list) {
                    trial = trial.multiply((GcdRingElem)((Object)fk));
                }
                if (trial.degree(0) > deg) {
                    // empty if block
                }
                GenPolynomial<GcdRingElem> cofactor = um.divide(trial);
                try {
                    ilist = HenselUtil.liftHenselQuadratic(PP, M, trial, cofactor);
                }
                catch (NoLiftingException e) {
                    continue;
                }
                GenPolynomial<BigInteger> itrial = ilist.A;
                GenPolynomial<BigInteger> icofactor = ilist.B;
                if (!PolyUtil.baseSparsePseudoRemainder(u, itrial = this.engine.basePrimitivePart(itrial)).isZERO()) continue;
                factors.add(itrial);
                PP = u = icofactor;
                um = cofactor;
                mlist = FactorInteger.removeOnce(mlist, list);
                dl = (mlist.size() + 1) / 2;
                j = 0;
                continue block2;
            }
        }
        if (!u.isONE() && !u.equals(P)) {
            factors.add(u);
        }
        if (factors.size() == 0) {
            factors.add(PP);
        }
        return this.normalizeFactorization(factors);
    }

    @Override
    public List<GenPolynomial<BigInteger>> factorsSquarefree(GenPolynomial<BigInteger> P) {
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar <= 1) {
            return this.baseFactorsSquarefree(P);
        }
        ArrayList topt = new ArrayList(1);
        topt.add(P);
        OptimizedPolynomialList opt = TermOrderOptimization.optimizeTermOrder(pfac, topt);
        P = (GenPolynomial)opt.list.get(0);
        List<Integer> iperm = TermOrderOptimization.inversePermutation(opt.perm);
        ExpVector degv = P.degreeVector();
        int[] donv = degv.dependencyOnVariables();
        List<GenPolynomial<BigInteger>> facs = null;
        if (degv.length() == donv.length) {
            try {
                facs = this.factorsSquarefreeHensel(P);
            }
            catch (Exception exception) {}
        } else {
            GenPolynomial<BigInteger> pu = PolyUtil.removeUnusedUpperVariables(P);
            try {
                facs = this.factorsSquarefreeHensel(pu);
                ArrayList<GenPolynomial<BigInteger>> fs = new ArrayList<GenPolynomial<BigInteger>>(facs.size());
                GenPolynomialRing pf = P.ring;
                GenPolynomialRing pfu = pu.ring;
                for (GenPolynomial<BigInteger> p : facs) {
                    GenPolynomial<BigInteger> pel = p.extendLower(pfu, 0, 0L);
                    GenPolynomial<BigInteger> pe = pel.extend(pf, 0, 0L);
                    fs.add(pe);
                }
                facs = fs;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (facs == null) {
            facs = super.factorsSquarefree(P);
        }
        List iopt = TermOrderOptimization.permutation(iperm, pfac, facs);
        facs = this.normalizeFactorization(iopt);
        return facs;
    }

    public List<GenPolynomial<BigInteger>> factorsSquarefreeHensel(GenPolynomial<BigInteger> P) {
        List<Object> mlift;
        List lf;
        List<GenPolynomial<BigInteger>> ufactors;
        List<BigInteger> cei;
        GenPolynomial<BigInteger> pe;
        List<Object> V;
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing<BigInteger> pfac = P.ring;
        if (pfac.nvar == 1) {
            return this.baseFactorsSquarefree(P);
        }
        List<GenPolynomial<BigInteger>> factors = new ArrayList<GenPolynomial<BigInteger>>();
        if (P.isZERO()) {
            return factors;
        }
        if (P.degreeVector().totalDeg() <= 1L) {
            factors.add(P);
            return factors;
        }
        GenPolynomial<BigInteger> pd = P;
        BigInteger ac = pd.leadingBaseCoefficient();
        GenPolynomialRing rnfac = pfac.recursive(pfac.nvar - 1);
        GenPolynomial pr = PolyUtil.recursive(rnfac, pd);
        GenPolynomial prr = PolyUtil.switchVariables(pr);
        GenPolynomial<BigInteger> prrc = this.engine.recursiveContent(prr);
        List<GenPolynomial<BigInteger>> cfactors = null;
        if (!prrc.isONE()) {
            prr = PolyUtil.recursiveDivide(prr, prrc);
            GenPolynomial prrcu = prrc.extendLower(pfac, 0, 0L);
            pd = PolyUtil.basePseudoDivide(pd, prrcu);
            cfactors = this.factorsSquarefree(prrc);
            ArrayList<GenPolynomial<BigInteger>> cff = new ArrayList<GenPolynomial<BigInteger>>(cfactors.size());
            for (GenPolynomial<BigInteger> fs : cfactors) {
                GenPolynomial<BigInteger> fsp = fs.extendLower(pfac, 0, 0L);
                cff.add(fsp);
            }
            cfactors = cff;
        }
        GenPolynomial lprr = prr.leadingBaseCoefficient();
        boolean isMonic = false;
        if (lprr.isConstant()) {
            isMonic = true;
        }
        SortedMap lfactors = this.factors(lprr);
        ArrayList lfacs = new ArrayList(lfactors.keySet());
        ArrayList<TrialParts> tParts = new ArrayList<TrialParts>();
        ArrayList<GenPolynomial<BigInteger>> ln = null;
        ArrayList<GenPolynomial<BigInteger>> un = null;
        GenPolynomial<BigInteger> pes = null;
        long evStart = 0L;
        ArrayList<Long> Evs = new ArrayList<Long>(pfac.nvar + 1);
        for (int j = 0; j <= pfac.nvar; ++j) {
            Evs.add(evStart);
        }
        int trials = 4;
        int countSeparate = 0;
        int COUNT_MAX = 50;
        double ran = 1.001;
        boolean notLucky = true;
        while (notLucky) {
            int ii;
            BigInteger Vi;
            if (Math.abs(evStart) > 371L) {
                throw new RuntimeException("no lucky evaluation point found after " + Math.abs(evStart) + " iterations");
            }
            if (Math.abs(evStart) % 100L <= 3L) {
                ran *= 1.001592653589793;
            }
            notLucky = false;
            V = new ArrayList();
            GenPolynomialRing<BigInteger> cpfac = pfac;
            pe = pd;
            GenPolynomialRing ccpfac = lprr.ring;
            List<GenPolynomial<Object>> ce = lfacs;
            List<GenPolynomial<BigInteger>> cep = null;
            cei = null;
            BigInteger pec = null;
            BigInteger ped = null;
            long vi = 0L;
            for (int j = pfac.nvar; j > 1; --j) {
                long degp = pe.degree(cpfac.nvar - 2);
                cpfac = cpfac.contract(1);
                ccpfac = ccpfac.contract(1);
                vi = (Long)Evs.get(j);
                boolean doIt = true;
                Vi = null;
                GenPolynomial<BigInteger> pep = null;
                while (doIt) {
                    Vi = new BigInteger(vi);
                    pep = PolyUtil.evaluateMain(cpfac, pe, Vi);
                    if (degp == pep.degree(cpfac.nvar - 1) && this.sengine.isSquarefree(pep)) {
                        doIt = false;
                    }
                    if (vi > 0L) {
                        vi = -vi;
                        continue;
                    }
                    vi = 1L - vi;
                }
                if (ccpfac.nvar >= 1) {
                    cep = PolyUtil.evaluateMain(ccpfac, ce, Vi);
                } else {
                    cei = PolyUtil.evaluateMain(ccpfac.coFac, ce, Vi);
                }
                int jj = (int)Math.round(ran + 0.52 * Math.random());
                if (vi > 0L) {
                    Evs.set(j, vi + (long)jj);
                    evStart = vi + (long)jj;
                } else {
                    Evs.set(j, vi - (long)jj);
                    evStart = vi - (long)jj;
                }
                V.add(Vi);
                pe = pep;
                ce = cep;
            }
            BigInteger pecw = this.engine.baseContent(pe);
            boolean isPrimitive = pecw.isONE();
            ped = (BigInteger)ccpfac.coFac.getONE();
            pec = (BigInteger)pe.ring.coFac.getONE();
            if (!isMonic) {
                pec = countSeparate > 50 ? (BigInteger)pe.ring.coFac.getONE() : pecw;
                if (((GenPolynomial)lfacs.get(0)).isConstant()) {
                    ped = cei.remove(0);
                }
                ArrayList<BigInteger> dei = new ArrayList<BigInteger>();
                dei.add(pec.multiply(ped).abs());
                int i = 1;
                for (BigInteger ci : cei) {
                    if (ci.isZERO()) {
                        notLucky = true;
                        break;
                    }
                    BigInteger q = ci.abs();
                    for (ii = i - 1; ii >= 0; --ii) {
                        BigInteger r = (BigInteger)dei.get(ii);
                        while (!r.isONE()) {
                            r = r.gcd(q);
                            q = q.divide(r);
                        }
                    }
                    dei.add(q);
                    if (q.isONE()) {
                        if (this.testSeparate(cei, pecw) || ++countSeparate > 50) {
                            // empty if block
                        }
                        notLucky = true;
                        break;
                    }
                    ++i;
                }
            }
            if (notLucky) continue;
            ufactors = this.baseFactorsSquarefree(pe.divide(pecw));
            if (!pecw.isONE()) {
                ufactors.add(0, ((GenPolynomial)cpfac.getONE()).multiply(pecw));
            }
            if (ufactors.size() <= 1) {
                factors.add(pd);
                if (cfactors != null) {
                    cfactors.addAll(factors);
                    factors = cfactors;
                }
                return factors;
            }
            lf = new ArrayList<GenPolynomial<BigInteger>>();
            GenPolynomial<BigInteger> lpx = lprr.ring.getONE();
            for (GenPolynomial<BigInteger> unused : ufactors) {
                lf.add((GenPolynomial<BigInteger>)lprr.ring.getONE());
            }
            if (!isMonic || !pecw.isONE()) {
                if (lfacs.size() > 0 && ((GenPolynomial)lfacs.get(0)).isConstant()) {
                    GenPolynomial i = (GenPolynomial)lfacs.remove(0);
                }
                for (int i = ufactors.size() - 1; i >= 0; --i) {
                    GenPolynomial<BigInteger> pp = ufactors.get(i);
                    BigInteger ppl = pp.leadingBaseCoefficient();
                    ppl = ppl.multiply(pec);
                    GenPolynomial<BigInteger> lfp = lf.get(i);
                    ii = 0;
                    for (BigInteger ci : cei) {
                        if (ci.abs().isONE()) {
                            throw new RuntimeException("something is wrong, ci is a unit");
                        }
                        while (ppl.remainder(ci).isZERO() && lfacs.size() > ii) {
                            ppl = ppl.divide(ci);
                            lfp = lfp.multiply((BigInteger)((Object)((GenPolynomial)lfacs.get(ii))));
                        }
                        ++ii;
                    }
                    lfp = lfp.multiply(ppl);
                    lf.set(i, lfp);
                }
                pec = pecw;
                lpx = Power.multiply(lprr.ring, lf);
                if (!lprr.degreeVector().equals(lpx.degreeVector())) {
                    notLucky = true;
                    continue;
                }
                if (!pec.isONE()) {
                    GenPolynomial<BigInteger> up;
                    int jj;
                    List<GenPolynomial<Object>> lfe = lf;
                    List<BigInteger> lfei = null;
                    ccpfac = lprr.ring;
                    for (int j = lprr.ring.nvar; j > 0; --j) {
                        ccpfac = ccpfac.contract(1);
                        Vi = (BigInteger)V.get(lprr.ring.nvar - j);
                        if (ccpfac.nvar >= 1) {
                            lfe = PolyUtil.evaluateMain(ccpfac, lfe, Vi);
                            continue;
                        }
                        lfei = PolyUtil.evaluateMain(ccpfac.coFac, lfe, Vi);
                    }
                    ln = new ArrayList<GenPolynomial<BigInteger>>(lf.size());
                    un = new ArrayList<GenPolynomial<BigInteger>>(lf.size());
                    for (jj = 0; jj < lf.size(); ++jj) {
                        BigInteger pec1;
                        up = ufactors.get(jj);
                        BigInteger ui = up.leadingBaseCoefficient();
                        BigInteger li = lfei.get(jj);
                        BigInteger di = ui.gcd(li).abs();
                        BigInteger udi = ui.divide(di);
                        BigInteger ldi = li.divide(di);
                        GenPolynomial<BigInteger> lp = lf.get(jj);
                        GenPolynomial<BigInteger> lpd = lp.multiply(udi);
                        GenPolynomial<BigInteger> upd = up.multiply(ldi);
                        if (pec.isONE()) {
                            ln.add(lp);
                            un.add(up);
                            continue;
                        }
                        ln.add(lpd);
                        un.add(upd);
                        pec = pec1 = pec.divide(ldi);
                    }
                    if (!lf.equals(ln) || !un.equals(ufactors)) {
                        // empty if block
                    }
                    if (!pec.isONE()) {
                        ln = new ArrayList(lf.size());
                        un = new ArrayList(lf.size());
                        pes = pe;
                        for (jj = 0; jj < lf.size(); ++jj) {
                            up = ufactors.get(jj);
                            GenPolynomial<BigInteger> lp = lf.get(jj);
                            if (!up.isConstant()) {
                                up = up.multiply(pec);
                            }
                            lp = lp.multiply(pec);
                            if (jj != 0) {
                                pes = pes.multiply(pec);
                            }
                            un.add(up);
                            ln.add(lp);
                        }
                        if (pes.equals(Power.multiply(pe.ring, un))) {
                            isPrimitive = false;
                        }
                    }
                }
                if (notLucky) continue;
                lpx = Power.multiply(lprr.ring, lf);
                if (!((GenPolynomial)lprr.abs()).equals(lpx.abs()) && !lprr.degreeVector().equals(lpx.degreeVector())) {
                    notLucky = true;
                }
            }
            if (notLucky) continue;
            TrialParts tp = null;
            tp = isPrimitive ? new TrialParts(V, pe, ufactors, cei, lf) : new TrialParts(V, pes, un, cei, ln);
            if (tp.univPoly != null && tp.ldcfEval.size() != 0) {
                tParts.add(tp);
            }
            if (tParts.size() >= 4) continue;
            notLucky = true;
        }
        int min = Integer.MAX_VALUE;
        TrialParts tpmin = null;
        for (TrialParts tp : tParts) {
            if (tp.univFactors.size() >= min) continue;
            min = tp.univFactors.size();
            tpmin = tp;
        }
        for (TrialParts tp : tParts) {
            if (tp.univFactors.size() != min || tp.univFactors.get(0).isConstant()) continue;
            tpmin = tp;
            break;
        }
        V = tpmin.evalPoints;
        pe = tpmin.univPoly;
        ufactors = tpmin.univFactors;
        cei = tpmin.ldcfEval;
        lf = tpmin.ldcfFactors;
        GenPolynomialRing ufac = pe.ring;
        PrimeList primes = new PrimeList(PrimeList.Range.medium);
        Iterator<java.math.BigInteger> primeIter = primes.iterator();
        int pn = 50;
        BigInteger ae = pe.leadingBaseCoefficient();
        GenPolynomial<ModLong> Pm = null;
        ModularRingFactory<ModLong> cofac = null;
        GenPolynomialRing<ModLong> mufac = null;
        for (int i = 0; i < 11; ++i) {
            java.math.BigInteger p = null;
            if (i == 0) {
                primes = new PrimeList(PrimeList.Range.medium);
                primeIter = primes.iterator();
            }
            if (i == 5) {
                primes = new PrimeList(PrimeList.Range.small);
                primeIter = primes.iterator();
                primeIter.next();
                primeIter.next();
                primeIter.next();
                primeIter.next();
            }
            if (i == 7) {
                primes = new PrimeList(PrimeList.Range.large);
                primeIter = primes.iterator();
            }
            int pi = 0;
            while (pi < pn && primeIter.hasNext()) {
                p = primeIter.next();
                ModularRingFactory<ModLong> cf = ModLongRing.MAX_LONG.compareTo(p) > 0 ? new ModLongRing(p, true) : new ModIntegerRing(p, true);
                GcdRingElem nf = (GcdRingElem)cf.fromInteger(ae.getVal());
                if (nf.isZERO() || !this.mfactor.isSquarefree(Pm = PolyUtil.fromIntegerCoefficients(mufac = new GenPolynomialRing<ModLong>(cf, ufac), pe))) continue;
                cofac = cf;
                break;
            }
            if (cofac != null) break;
        }
        if (cofac == null) {
            throw new RuntimeException("giving up on Hensel preparation, no lucky prime found");
        }
        BigInteger an = pd.maxNorm();
        BigInteger mn = an.multiply(ac.abs()).multiply(new BigInteger(2L));
        long k = Power.logarithm(cofac.getIntegerModul(), mn) + 1L;
        BigInteger q = Power.positivePower(cofac.getIntegerModul(), k);
        ModularRingFactory<ModLong> muqfac = ModLongRing.MAX_LONG.compareTo(q.getVal()) > 0 ? new ModLongRing(q.getVal()) : new ModIntegerRing(q.getVal());
        GenPolynomialRing<ModLong> mucpfac = new GenPolynomialRing<ModLong>(muqfac, ufac);
        List muqfactors = PolyUtil.fromIntegerCoefficients(mucpfac, ufactors);
        GenPolynomialRing<ModLong> qcfac = new GenPolynomialRing<ModLong>(muqfac, pd.ring);
        GenPolynomial<ModLong> pq = PolyUtil.fromIntegerCoefficients(qcfac, pd);
        ArrayList<GcdRingElem> Vm = new ArrayList<GcdRingElem>(V.size());
        for (BigInteger bigInteger : V) {
            GcdRingElem vm = (GcdRingElem)muqfac.fromInteger(bigInteger.getVal());
            Vm.add(vm);
        }
        try {
            mlift = HenselMultUtil.liftHensel(pd, pq, muqfactors, Vm, k, lf);
        }
        catch (NoLiftingException noLiftingException) {
            mlift = new ArrayList();
            throw new RuntimeException(noLiftingException);
        }
        catch (ArithmeticException arithmeticException) {
            mlift = new ArrayList();
            throw arithmeticException;
        }
        if (mlift.size() <= 1) {
            factors.add(pd);
            if (cfactors != null) {
                cfactors.addAll(factors);
                factors = cfactors;
            }
            return factors;
        }
        GenPolynomialRing genPolynomialRing = ((GenPolynomial)mlift.get((int)0)).ring;
        int dl = (mlift.size() + 1) / 2;
        GenPolynomial<BigInteger> u = P;
        long deg = (u.degree() + 1L) / 2L;
        GenPolynomial<BigInteger> ui = pd;
        block23: for (int j = 1; j <= dl; ++j) {
            KsubSet<Object> subs = new KsubSet<Object>(mlift, j);
            for (List<Object> list : subs) {
                GenPolynomial mtrial = (GenPolynomial)Power.multiply(genPolynomialRing, list);
                if (mtrial.degree() > deg) {
                    // empty if block
                }
                GenPolynomial<BigInteger> trial = PolyUtil.integerFromModularCoefficients(pfac, mtrial);
                if (!PolyUtil.baseSparsePseudoRemainder(ui, trial = this.engine.basePrimitivePart(trial)).isZERO()) continue;
                factors.add(trial);
                ui = PolyUtil.basePseudoDivide(ui, trial);
                mlift = FactorInteger.removeOnce(mlift, list);
                if (mlift.size() > 1) {
                    dl = (mlift.size() + 1) / 2;
                    j = 0;
                    continue block23;
                }
                factors.add(ui);
                if (cfactors != null) {
                    cfactors.addAll(factors);
                    factors = cfactors;
                }
                return this.normalizeFactorization(factors);
            }
        }
        if (!ui.isONE() && !ui.equals(pd)) {
            factors.add(ui);
        }
        if (factors.size() == 0) {
            factors.add(pd);
        }
        if (cfactors != null) {
            cfactors.addAll(factors);
            factors = cfactors;
        }
        return this.normalizeFactorization(factors);
    }

    boolean testSeparate(List<BigInteger> A, BigInteger b) {
        int i = 0;
        for (BigInteger c : A) {
            BigInteger g = c.gcd(b).abs();
            if (g.isONE()) continue;
            ++i;
        }
        return i <= 1;
    }
}

