/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.Coefficients;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.TaylorFunction;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ps.UnivPowerSeries;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UnivPowerSeriesRing<C extends RingElem<C>>
implements RingFactory<UnivPowerSeries<C>> {
    protected static final Random random = new Random();
    public static final int DEFAULT_TRUNCATE = 11;
    int truncate;
    String var;
    public final RingFactory<C> coFac;
    public final UnivPowerSeries<C> ONE;
    public final UnivPowerSeries<C> ZERO;

    private UnivPowerSeriesRing() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    public UnivPowerSeriesRing(GenPolynomialRing<C> pfac) {
        this(pfac.coFac, 11, pfac.getVars()[0]);
    }

    public UnivPowerSeriesRing(RingFactory<C> cofac, int truncate, String name) {
        this.coFac = cofac;
        this.truncate = truncate;
        this.var = name;
        this.ONE = new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                if (i == 0) {
                    return (RingElem)UnivPowerSeriesRing.this.coFac.getONE();
                }
                return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
            }
        });
        this.ZERO = new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String scf = this.coFac.getClass().getSimpleName();
        sb.append(scf).append("((").append(this.var).append("))");
        return sb.toString();
    }

    public boolean equals(Object B) {
        UnivPowerSeriesRing a = null;
        try {
            a = (UnivPowerSeriesRing)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.coFac.equals(a.coFac)) {
            return false;
        }
        return this.var.equals(a.var);
    }

    public int hashCode() {
        int h = this.coFac.hashCode();
        h += this.var.hashCode() << 27;
        return h += this.truncate;
    }

    @Override
    public UnivPowerSeries<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public UnivPowerSeries<C> getONE() {
        return this.ONE;
    }

    @Override
    public List<UnivPowerSeries<C>> generators() {
        List rgens = this.coFac.generators();
        ArrayList<UnivPowerSeries<C>> gens = new ArrayList<UnivPowerSeries<C>>(rgens.size());
        for (final RingElem cg : rgens) {
            UnivPowerSeries g = new UnivPowerSeries(this, new Coefficients<C>(){

                @Override
                public C generate(int i) {
                    if (i == 0) {
                        return cg;
                    }
                    return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
                }
            });
            gens.add(g);
        }
        gens.add(this.ONE.shift(1));
        return gens;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    @Override
    public UnivPowerSeries<C> fromInteger(long a) {
        return this.ONE.multiply((RingElem)this.coFac.fromInteger(a));
    }

    @Override
    public UnivPowerSeries<C> fromInteger(BigInteger a) {
        return this.ONE.multiply((RingElem)this.coFac.fromInteger(a));
    }

    public UnivPowerSeries<C> random() {
        return this.random(5, 0.7f, random);
    }

    @Override
    public UnivPowerSeries<C> random(int k) {
        return this.random(k, 0.7f, random);
    }

    @Override
    public UnivPowerSeries<C> random(int k, Random rnd) {
        return this.random(k, 0.7f, rnd);
    }

    public UnivPowerSeries<C> random(int k, float d) {
        return this.random(k, d, random);
    }

    public UnivPowerSeries<C> random(final int k, final float d, final Random rnd) {
        return new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int i) {
                float f = rnd.nextFloat();
                RingElem c = f < d ? (RingElem)UnivPowerSeriesRing.this.coFac.random(k, rnd) : (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
                return c;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> copy(UnivPowerSeries<C> c) {
        return new UnivPowerSeries(this, c.lazyCoeffs);
    }

    public UnivPowerSeries<C> seriesOfTaylor(final TaylorFunction<C> f, C a) {
        return new UnivPowerSeries(this, new Coefficients<C>((RingElem)a){
            TaylorFunction<C> der;
            long k;
            long n;
            final /* synthetic */ RingElem val$a;
            {
                this.val$a = ringElem;
                this.der = f;
                this.k = 0L;
                this.n = 1L;
            }

            @Override
            public C generate(int i) {
                Object c2;
                if (i == 0) {
                    RingElem c2 = this.der.evaluate(this.val$a);
                    this.der = this.der.deriviative();
                    return c2;
                }
                if (i > 0) {
                    c2 = this.get(i - 1);
                }
                ++this.k;
                this.n *= this.k;
                c2 = this.der.evaluate(this.val$a);
                c2 = (RingElem)c2.divide((MonoidElem)((MonoidElem)UnivPowerSeriesRing.this.coFac.fromInteger(this.n)));
                this.der = this.der.deriviative();
                return c2;
            }
        });
    }
}

