/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigRational;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.Modular;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModularRingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgToPoly;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebToCompl;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumber;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.CoeffToAlg;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ComplToAlgeb;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Complex;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ComplexRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.DistToRec;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.EvalMain;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.EvalMainPol;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.FromInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.FromIntegerPoly;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ModSymToInt;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Monomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.RatToInt;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.RatToIntFactor;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.AbelianGroupElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.Element;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.MonoidElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.UnaryFunctor;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class PolyUtil {
    private static boolean debug = false;

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursive(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<C> A) {
        Element B = ((GenPolynomial)rfac.getZERO()).copy();
        if (A.isZERO()) {
            return B;
        }
        int i = rfac.nvar;
        GenPolynomial<RingElem> zero = rfac.getZEROCoefficient();
        SortedMap Bv = ((GenPolynomial)B).val;
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            RingElem a = (RingElem)y.getValue();
            ExpVector f = e.contract(0, i);
            ExpVector g = e.contract(i, e.length() - i);
            GenPolynomial<RingElem> p = (GenPolynomial<RingElem>)Bv.get(f);
            if (p == null) {
                p = zero;
            }
            p = p.sum(a, g);
            Bv.put(f, p);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> distribute(GenPolynomialRing<C> dfac, GenPolynomial<GenPolynomial<C>> B) {
        Element C = ((GenPolynomial)dfac.getZERO()).copy();
        if (B.isZERO()) {
            return C;
        }
        SortedMap Cm = ((GenPolynomial)C).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : B.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> A = y.getValue();
            for (Map.Entry x : A.val.entrySet()) {
                ExpVector f = x.getKey();
                RingElem b = (RingElem)x.getValue();
                ExpVector g = e.combine(f);
                Cm.put(g, b);
            }
        }
        return C;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> recursive(GenPolynomialRing<GenPolynomial<C>> rfac, List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new DistToRec<C>(rfac));
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<BigInteger> integerFromModularCoefficients(GenPolynomialRing<BigInteger> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new ModSymToInt());
    }

    public static <C extends RingElem<C> & Modular> List<GenPolynomial<BigInteger>> integerFromModularCoefficients(final GenPolynomialRing<BigInteger> fac, List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, GenPolynomial<BigInteger>>(){

            @Override
            public GenPolynomial<BigInteger> eval(GenPolynomial<C> c) {
                return PolyUtil.integerFromModularCoefficients((GenPolynomialRing<BigInteger>)fac, c);
            }
        });
    }

    public static GenPolynomial<BigInteger> integerFromRationalCoefficients(GenPolynomialRing<BigInteger> fac, GenPolynomial<BigRational> A) {
        if (A == null || A.isZERO()) {
            return fac.getZERO();
        }
        java.math.BigInteger c = null;
        int s = 0;
        for (BigRational y : A.val.values()) {
            java.math.BigInteger x = y.denominator();
            if (c == null) {
                c = x;
                s = x.signum();
                continue;
            }
            java.math.BigInteger d = c.gcd(x);
            c = c.multiply(x.divide(d));
        }
        if (s < 0) {
            c = c.negate();
        }
        return PolyUtil.map(fac, A, new RatToInt(c));
    }

    public static Object[] integerFromRationalCoefficientsFactor(GenPolynomialRing<BigInteger> fac, GenPolynomial<BigRational> A) {
        Object[] result = new Object[3];
        if (A == null || A.isZERO()) {
            result[0] = java.math.BigInteger.ONE;
            result[1] = java.math.BigInteger.ZERO;
            result[2] = fac.getZERO();
            return result;
        }
        java.math.BigInteger gcd = null;
        java.math.BigInteger lcm = null;
        int sLCM = 0;
        int sGCD = 0;
        for (BigRational y : A.val.values()) {
            java.math.BigInteger numerator = y.numerator();
            java.math.BigInteger denominator = y.denominator();
            if (lcm == null) {
                lcm = denominator;
                sLCM = denominator.signum();
            } else {
                java.math.BigInteger d = lcm.gcd(denominator);
                lcm = lcm.multiply(denominator.divide(d));
            }
            if (gcd == null) {
                gcd = numerator;
                sGCD = numerator.signum();
                continue;
            }
            gcd = gcd.gcd(numerator);
        }
        if (sLCM < 0) {
            lcm = lcm.negate();
        }
        if (sGCD < 0) {
            gcd = gcd.negate();
        }
        result[0] = gcd;
        result[1] = lcm;
        result[2] = PolyUtil.map(fac, A, new RatToIntFactor(gcd, lcm));
        return result;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> fromIntegerCoefficients(GenPolynomialRing<C> fac, GenPolynomial<BigInteger> A) {
        return PolyUtil.map(fac, A, new FromInteger(fac.coFac));
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> fromIntegerCoefficients(GenPolynomialRing<C> fac, List<GenPolynomial<BigInteger>> L) {
        return ListUtil.map(L, new FromIntegerPoly<C>(fac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> fromAlgebraicCoefficients(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<AlgebraicNumber<C>> A) {
        return PolyUtil.map(rfac, A, new AlgToPoly());
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToAlg(afac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Complex<C>> complexFromAlgebraic(GenPolynomialRing<Complex<C>> fac, GenPolynomial<AlgebraicNumber<C>> A) {
        ComplexRing cfac = (ComplexRing)fac.coFac;
        return PolyUtil.map(fac, A, new AlgebToCompl(cfac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> algebraicFromComplex(GenPolynomialRing<AlgebraicNumber<C>> fac, GenPolynomial<Complex<C>> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)fac.coFac;
        return PolyUtil.map(fac, A, new ComplToAlgeb(afac));
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<C> chineseRemainder(GenPolynomialRing<C> fac, GenPolynomial<C> A, C mi, GenPolynomial<C> B) {
        ExpVector e;
        ModularRingFactory cfac = (ModularRingFactory)fac.coFac;
        Element S = ((GenPolynomial)fac.getZERO()).copy();
        Element Ap = A.copy();
        SortedMap av = ((GenPolynomial)Ap).val;
        SortedMap<ExpVector, C> bv = B.getMap();
        SortedMap sv = ((GenPolynomial)S).val;
        RingElem c = null;
        for (Map.Entry<ExpVector, C> me : bv.entrySet()) {
            e = me.getKey();
            RingElem y = (RingElem)me.getValue();
            RingElem x = (RingElem)av.get(e);
            if (x != null) {
                av.remove(e);
                c = cfac.chineseRemainder(x, mi, y);
                if (c.isZERO()) continue;
                sv.put(e, c);
                continue;
            }
            c = cfac.chineseRemainder((RingElem)A.ring.coFac.getZERO(), mi, y);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        for (Map.Entry<ExpVector, C> me : av.entrySet()) {
            e = me.getKey();
            RingElem x = (RingElem)me.getValue();
            c = cfac.chineseRemainder(x, mi, (RingElem)B.ring.coFac.getZERO());
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        return S;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> monic(GenPolynomial<GenPolynomial<C>> p) {
        if (p == null || p.isZERO()) {
            return p;
        }
        C lc = p.leadingBaseCoefficient().leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return p;
        }
        RingElem lm = (RingElem)lc.inverse();
        GenPolynomial<RingElem> L = (GenPolynomial<RingElem>)p.ring.coFac.getONE();
        L = L.multiply(lm);
        return p.multiply((GenPolynomial<GenPolynomial<RingElem>>)L);
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> monic(List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> eval(GenPolynomial<C> c) {
                if (c == null) {
                    return null;
                }
                return c.monic();
            }
        });
    }

    public static <C extends RingElem<C>> List<ExpVector> leadingExpVector(List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, ExpVector>(){

            @Override
            public ExpVector eval(GenPolynomial<C> c) {
                if (c == null) {
                    return null;
                }
                return c.leadingExpVector();
            }
        });
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseSparsePseudoRemainder(GenPolynomial<C> P, GenPolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        if (P.isZERO()) {
            return P;
        }
        if (S.isONE()) {
            return P.ring.getZERO();
        }
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial<Object> h;
            C a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            RingElem x = (RingElem)a.remainder(c);
            if (x.isZERO()) {
                RingElem y = (RingElem)a.divide(c);
                h = S.multiply(y, f);
            } else {
                r = r.multiply(c);
                h = S.multiply((RingElem)a, f);
            }
            r = r.subtract((C)h);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDensePseudoRemainder(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P.isZERO()) {
            return P;
        }
        if (S.degree() <= 0L) {
            return P.ring.getZERO();
        }
        long m = P.degree(0);
        long n = S.degree(0);
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        for (long i = m; i >= n; --i) {
            if (r.isZERO()) {
                return r;
            }
            long k = r.degree(0);
            if (i == k) {
                ExpVector f = r.leadingExpVector();
                C a = r.leadingBaseCoefficient();
                f = f.subtract(e);
                r = r.multiply(c);
                GenPolynomial<C> h = S.multiply(a, f);
                r = r.subtract((C)h);
                continue;
            }
            r = r.multiply(c);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> basePseudoDivide(GenPolynomial<C> P, GenPolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        if (P.isZERO() || S.isONE()) {
            return P;
        }
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        GenPolynomial q = ((GenPolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial h;
            C a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            RingElem x = (RingElem)a.remainder(c);
            if (x.isZERO()) {
                RingElem y = (RingElem)a.divide(c);
                q = q.sum(y, f);
                h = S.multiply(y, f);
            } else {
                q = q.multiply(c);
                q = q.sum(a, f);
                r = r.multiply(c);
                h = S.multiply((RingElem)a, f);
            }
            r = r.subtract((C)h);
        }
        return q;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        Element p = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m1 : P.getMap().entrySet()) {
            GenPolynomial<C> c1 = m1.getValue();
            ExpVector e1 = m1.getKey();
            GenPolynomial<C> c = PolyUtil.basePseudoDivide(c1, s);
            if (!c.isZERO()) {
                pv.put(e1, c);
                continue;
            }
            throw new RuntimeException("something is wrong");
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> baseRecursiveDivide(GenPolynomial<GenPolynomial<C>> P, C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        Element p = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m1 : P.getMap().entrySet()) {
            GenPolynomial<C> c1 = m1.getValue();
            ExpVector e1 = m1.getKey();
            GenPolynomial<C> c = PolyUtil.coefficientBasePseudoDivide(c1, s);
            if (!c.isZERO()) {
                pv.put(e1, c);
                continue;
            }
            throw new RuntimeException("something is wrong");
        }
        return p;
    }

    @Deprecated
    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursivePseudoRemainder(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        return PolyUtil.recursiveSparsePseudoRemainder(P, S);
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveSparsePseudoRemainder(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isONE()) {
            return P.ring.getZERO();
        }
        GenPolynomial<C> c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial<GenPolynomial<C>> h;
            GenPolynomial<C> a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenPolynomial<C> x = c;
            if (x.isZERO()) {
                GenPolynomial<C> y = PolyUtil.basePseudoDivide(a, c);
                h = S.multiply(y, f);
            } else {
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
                h = S.multiply(a, f);
            }
            r = r.subtract(h);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDensePseudoRemainder(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.degree() <= 0L) {
            return P.ring.getZERO();
        }
        long m = P.degree(0);
        long n = S.degree(0);
        GenPolynomial<C> c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        for (long i = m; i >= n; --i) {
            if (r.isZERO()) {
                return r;
            }
            long k = r.degree(0);
            if (i == k) {
                ExpVector f = r.leadingExpVector();
                GenPolynomial<C> a = r.leadingBaseCoefficient();
                f = f.subtract(e);
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
                GenPolynomial<GenPolynomial<C>> h = S.multiply(a, f);
                r = r.subtract(h);
                continue;
            }
            r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursivePseudoDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isONE()) {
            return P;
        }
        GenPolynomial<C> c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> q = ((GenPolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial<GenPolynomial<C>> h;
            GenPolynomial<C> a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenPolynomial<C> x = PolyUtil.baseSparsePseudoRemainder(a, c);
            if (x.isZERO() && !c.isConstant()) {
                GenPolynomial<C> y = PolyUtil.basePseudoDivide(a, c);
                q = q.sum(y, f);
                h = S.multiply(y, f);
            } else {
                q = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)c);
                q = q.sum(a, f);
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
                h = S.multiply(a, f);
            }
            r = r.subtract(h);
        }
        return q;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> coefficientPseudoDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        Element p = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : P.getMap().entrySet()) {
            GenPolynomial<C> x;
            ExpVector e = m.getKey();
            GenPolynomial<C> c1 = m.getValue();
            GenPolynomial<C> c = PolyUtil.basePseudoDivide(c1, s);
            if (debug && !(x = c1.remainder(s)).isZERO()) {
                throw new ArithmeticException(" no exact division: " + c1 + "/" + s);
            }
            if (c.isZERO()) continue;
            pv.put(e, c);
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> coefficientBasePseudoDivide(GenPolynomial<C> P, C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        Element p = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            C x;
            ExpVector e = m.getKey();
            RingElem c1 = (RingElem)m.getValue();
            C c = c1.divide(s);
            if (debug && !(x = c1.remainder(s)).isZERO()) {
                throw new ArithmeticException(" no exact division: " + c1 + "/" + s);
            }
            if (c.isZERO()) continue;
            pv.put(e, c);
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDeriviative(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(0);
            if (fl <= 0L) continue;
            RingElem cf = (RingElem)rf.fromInteger(fl);
            RingElem a = (RingElem)m.getValue();
            RingElem x = a.multiply(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = ExpVector.create(1, 0, fl - 1L);
            dm.put(e, x);
        }
        return d;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDeriviative(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing pr = (GenPolynomialRing)pfac.coFac;
        RingFactory rf = pr.coFac;
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(0);
            if (fl <= 0L) continue;
            RingElem cf = (RingElem)rf.fromInteger(fl);
            GenPolynomial<RingElem> a = m.getValue();
            GenPolynomial<RingElem> x = a.multiply(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = ExpVector.create(1, 0, fl - 1L);
            dm.put(e, x);
        }
        return d;
    }

    public static BigInteger factorBound(ExpVector e) {
        java.math.BigInteger v;
        int n = 0;
        java.math.BigInteger p = java.math.BigInteger.ONE;
        if (e == null || e.isZERO()) {
            return BigInteger.ONE;
        }
        for (int i = 0; i < e.length(); ++i) {
            if (e.getVal(i) <= 0L) continue;
            n = (int)((long)n + (2L * e.getVal(i) - 1L));
            v = new java.math.BigInteger("" + (e.getVal(i) - 1L));
            p = p.multiply(v);
        }
        n += p.bitCount() + 1;
        v = new java.math.BigInteger("2");
        v = v.shiftLeft(n /= 2);
        BigInteger N = new BigInteger(v);
        return N;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateMainRecursive(GenPolynomialRing<C> cfac, GenPolynomial<GenPolynomial<C>> A, C a) {
        if (A == null || A.isZERO()) {
            return cfac.getZERO();
        }
        if (A.ring.nvar != 1) {
            throw new IllegalArgumentException("evaluateMain no univariate polynomial");
        }
        if (a == null || a.isZERO()) {
            return A.trailingBaseCoefficient();
        }
        SortedMap<ExpVector, GenPolynomial<C>> val = A.getMap();
        GenPolynomial<Object> B = null;
        long el1 = -1L;
        long el2 = -1L;
        for (Map.Entry me : val.entrySet()) {
            ExpVector e = (ExpVector)me.getKey();
            el2 = e.getVal(0);
            if (B == null) {
                B = (GenPolynomial<C>)me.getValue();
            } else {
                for (long i = el2; i < el1; ++i) {
                    B = B.multiply((Object)a);
                }
                B = B.sum((Object)((GenPolynomial)me.getValue()));
            }
            el1 = el2;
        }
        for (long i = 0L; i < el2; ++i) {
            B = B.multiply((Object)a);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateMain(GenPolynomialRing<C> cfac, GenPolynomial<C> A, C a) {
        if (A == null || A.isZERO()) {
            return cfac.getZERO();
        }
        GenPolynomialRing<GenPolynomial<C>> rfac = new GenPolynomialRing<GenPolynomial<C>>(cfac, 1);
        if (rfac.nvar + cfac.nvar != A.ring.nvar) {
            throw new IllegalArgumentException("evaluateMain number of variabes mismatch");
        }
        GenPolynomial<GenPolynomial<C>> Ap = PolyUtil.recursive(rfac, A);
        return PolyUtil.evaluateMainRecursive(cfac, Ap, a);
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> evaluateMain(GenPolynomialRing<C> cfac, List<GenPolynomial<C>> L, C a) {
        return ListUtil.map(L, new EvalMainPol<C>(cfac, a));
    }

    public static <C extends RingElem<C>> C evaluateMain(RingFactory<C> cfac, GenPolynomial<C> A, C a) {
        if (A == null || A.isZERO()) {
            return (C)((RingElem)cfac.getZERO());
        }
        if (A.ring.nvar != 1) {
            throw new IllegalArgumentException("evaluateMain no univariate polynomial");
        }
        if (a == null || a.isZERO()) {
            return A.trailingBaseCoefficient();
        }
        SortedMap<ExpVector, C> val = A.getMap();
        MonoidElem<AbelianGroupElem> B = null;
        long el1 = -1L;
        long el2 = -1L;
        for (Map.Entry me : val.entrySet()) {
            ExpVector e = (ExpVector)me.getKey();
            el2 = e.getVal(0);
            if (B == null) {
                B = (RingElem)me.getValue();
            } else {
                for (long i = el2; i < el1; ++i) {
                    B = (RingElem)B.multiply(a);
                }
                B = (RingElem)B.sum((AbelianGroupElem)me.getValue());
            }
            el1 = el2;
        }
        for (long i = 0L; i < el2; ++i) {
            B = B.multiply(a);
        }
        return (C)B;
    }

    public static <C extends RingElem<C>> List<C> evaluateMain(RingFactory<C> cfac, List<GenPolynomial<C>> L, C a) {
        return ListUtil.map(L, new EvalMain<C>(cfac, a));
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateFirstRec(GenPolynomialRing<C> cfac, GenPolynomialRing<C> dfac, GenPolynomial<GenPolynomial<C>> A, C a) {
        if (A == null || A.isZERO()) {
            return dfac.getZERO();
        }
        SortedMap<ExpVector, GenPolynomial<C>> Ap = A.getMap();
        Element B = ((GenPolynomial)dfac.getZERO()).copy();
        SortedMap Bm = ((GenPolynomial)B).val;
        for (Map.Entry m : Ap.entrySet()) {
            ExpVector e = (ExpVector)m.getKey();
            GenPolynomial b = (GenPolynomial)m.getValue();
            Object d = PolyUtil.evaluateMain(cfac.coFac, b, a);
            if (d == null || d.isZERO()) continue;
            Bm.put(e, d);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> substituteMain(GenPolynomial<C> A, GenPolynomial<C> s) {
        return PolyUtil.substituteUnivariate(A, s);
    }

    public static <C extends RingElem<C>> GenPolynomial<C> substituteUnivariate(GenPolynomial<C> f, GenPolynomial<C> t) {
        if (f == null || t == null) {
            return null;
        }
        GenPolynomialRing fac = f.ring;
        if (fac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomial f");
        }
        if (f.isZERO() || f.isConstant()) {
            return f;
        }
        if (t.ring.nvar > 1) {
            fac = t.ring;
        }
        SortedMap<ExpVector, C> val = f.getMap();
        GenPolynomial<RingElem<GenPolynomial<RingElem>>> s = null;
        long el1 = -1L;
        long el2 = -1L;
        for (Map.Entry me : val.entrySet()) {
            ExpVector e = (ExpVector)me.getKey();
            el2 = e.getVal(0);
            if (s == null) {
                s = ((GenPolynomial)fac.getZERO()).sum((RingElem)me.getValue());
            } else {
                for (long i = el2; i < el1; ++i) {
                    s = s.multiply((RingElem<GenPolynomial<RingElem>>)t);
                }
                s = s.sum((RingElem)me.getValue());
            }
            el1 = el2;
        }
        for (long i = 0L; i < el2; ++i) {
            s = s.multiply((RingElem<GenPolynomial<RingElem>>)t);
        }
        return s;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> interpolate(GenPolynomialRing<GenPolynomial<C>> fac, GenPolynomial<GenPolynomial<C>> A, GenPolynomial<C> M, C mi, GenPolynomial<C> B, C am) {
        ExpVector e;
        Element S = ((GenPolynomial)fac.getZERO()).copy();
        Element Ap = A.copy();
        SortedMap av = ((GenPolynomial)Ap).val;
        SortedMap<ExpVector, C> bv = B.getMap();
        SortedMap sv = ((GenPolynomial)S).val;
        GenPolynomialRing cfac = (GenPolynomialRing)fac.coFac;
        RingFactory bfac = cfac.coFac;
        GenPolynomial<RingElem> c = null;
        for (Map.Entry<ExpVector, C> me : bv.entrySet()) {
            e = me.getKey();
            RingElem y = (RingElem)me.getValue();
            GenPolynomial x = (GenPolynomial)av.get(e);
            if (x != null) {
                av.remove(e);
                c = PolyUtil.interpolate(cfac, x, M, mi, y, am);
                if (c.isZERO()) continue;
                sv.put(e, c);
                continue;
            }
            c = PolyUtil.interpolate(cfac, cfac.getZERO(), M, mi, y, am);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        for (Map.Entry<ExpVector, C> me : av.entrySet()) {
            e = me.getKey();
            GenPolynomial x = (GenPolynomial)me.getValue();
            c = PolyUtil.interpolate(cfac, x, M, mi, (RingElem)bfac.getZERO(), am);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        return S;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> interpolate(GenPolynomialRing<C> fac, GenPolynomial<C> A, GenPolynomial<C> M, C mi, C a, C am) {
        Object b = PolyUtil.evaluateMain(fac.coFac, A, am);
        RingElem d = (RingElem)a.subtract(b);
        if (d.isZERO()) {
            return A;
        }
        b = d.multiply(mi);
        GenPolynomial<GenPolynomial<C>> s = M.multiply(b);
        s = s.sum(A);
        return s;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> switchVariables(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        GenPolynomialRing rfac1 = P.ring;
        GenPolynomialRing cfac1 = (GenPolynomialRing)rfac1.coFac;
        GenPolynomialRing cfac2 = new GenPolynomialRing(cfac1.coFac, rfac1);
        AbelianGroupElem zero = cfac2.getZERO();
        GenPolynomialRing rfac2 = new GenPolynomialRing(cfac2, cfac1);
        GenPolynomial B = ((GenPolynomial)rfac2.getZERO()).copy();
        if (P.isZERO()) {
            return B;
        }
        for (Monomial<GenPolynomial<C>> monomial : P) {
            GenPolynomial cr = (GenPolynomial)monomial.c;
            for (Monomial mc : cr) {
                GenPolynomial c = ((GenPolynomial)zero).sum(mc.c, monomial.e);
                B = B.sum(c, mc.e);
            }
        }
        return B;
    }

    public static <C extends RingElem<C>> long coeffMaxDegree(GenPolynomial<GenPolynomial<C>> A) {
        if (A.isZERO()) {
            return 0L;
        }
        long deg = 0L;
        for (GenPolynomial<C> a : A.getMap().values()) {
            long d = a.degree();
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public static <C extends RingElem<C>, D extends RingElem<D>> GenPolynomial<D> map(GenPolynomialRing<D> ring, GenPolynomial<C> p, UnaryFunctor<C, D> f) {
        Element n = ((GenPolynomial)ring.getZERO()).copy();
        SortedMap nv = ((GenPolynomial)n).val;
        for (Monomial<C> m : p) {
            RingElem c = (RingElem)f.eval(m.c);
            if (c == null || c.isZERO()) continue;
            nv.put(m.e, c);
        }
        return n;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> removeUnusedUpperVariables(GenPolynomial<C> p) {
        GenPolynomialRing fac = p.ring;
        if (fac.nvar <= 1) {
            return p;
        }
        int[] dep = p.degreeVector().dependencyOnVariables();
        if (fac.nvar == dep.length) {
            return p;
        }
        if (dep.length == 0) {
            GenPolynomialRing fac0 = new GenPolynomialRing(fac.coFac, 0);
            GenPolynomial p0 = new GenPolynomial(fac0, p.leadingBaseCoefficient());
            return p0;
        }
        int l = dep[0];
        int r = dep[dep.length - 1];
        if (l == 0) {
            return p;
        }
        int n = l;
        GenPolynomialRing facr = fac.contract(n);
        Map<ExpVector, GenPolynomial<C>> mpr = p.contract(facr);
        if (mpr.size() != 1) {
            throw new RuntimeException("this should not happen " + mpr);
        }
        GenPolynomial<C> pr = mpr.values().iterator().next();
        n = fac.nvar - 1 - r;
        if (n == 0) {
            return pr;
        }
        return pr;
    }
}

