/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModIntegerRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.AlgebraicNumberRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialIterator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialMonomialIterator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolynomialComparator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.TermOrder;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class GenPolynomialRing<C extends RingElem<C>>
implements RingFactory<GenPolynomial<C>>,
Iterable<GenPolynomial<C>> {
    public final RingFactory<C> coFac;
    public final int nvar;
    public final TermOrder tord;
    protected boolean partial;
    protected String[] vars;
    private static Set<String> knownVars = new HashSet<String>();
    public final GenPolynomial<C> ZERO;
    public final GenPolynomial<C> ONE;
    public final ExpVector evzero;
    protected static final Random random = new Random();
    protected int isField = -1;

    public GenPolynomialRing(RingFactory<C> cf, int n) {
        this(cf, n, new TermOrder(), null);
    }

    public GenPolynomialRing(RingFactory<C> cf, int n, TermOrder t) {
        this(cf, n, t, null);
    }

    public GenPolynomialRing(RingFactory<C> cf, String[] v) {
        this(cf, v.length, v);
    }

    public GenPolynomialRing(RingFactory<C> cf, int n, String[] v) {
        this(cf, n, new TermOrder(), v);
    }

    public GenPolynomialRing(RingFactory<C> cf, TermOrder t, String[] v) {
        this(cf, v.length, t, v);
    }

    public GenPolynomialRing(RingFactory<C> cf, String[] v, TermOrder t) {
        this(cf, v.length, t, v);
    }

    public GenPolynomialRing(RingFactory<C> cf, int n, TermOrder t, String[] v) {
        this.coFac = cf;
        this.nvar = n;
        this.tord = t;
        this.partial = false;
        this.vars = v;
        this.ZERO = new GenPolynomial(this);
        RingElem coeff = (RingElem)this.coFac.getONE();
        this.evzero = ExpVector.create(this.nvar);
        this.ONE = new GenPolynomial<RingElem>(this, coeff, this.evzero);
        if (this.vars == null) {
            this.vars = GenPolynomialRing.newVars("x", this.nvar);
        } else {
            if (this.vars.length != this.nvar) {
                throw new IllegalArgumentException("incompatible variable size " + this.vars.length + ", " + this.nvar);
            }
            GenPolynomialRing.addVars(this.vars);
        }
    }

    public GenPolynomialRing(RingFactory<C> cf, GenPolynomialRing o) {
        this(cf, o.nvar, o.tord, o.vars);
    }

    public GenPolynomialRing(GenPolynomialRing<C> o, TermOrder to) {
        this(o.coFac, o.nvar, to, o.vars);
    }

    public GenPolynomialRing<C> copy() {
        return new GenPolynomialRing<C>(this.coFac, this);
    }

    public String toString() {
        String res = null;
        if (this.coFac != null) {
            String scf = this.coFac.getClass().getSimpleName();
            if (this.coFac instanceof AlgebraicNumberRing) {
                AlgebraicNumberRing an = (AlgebraicNumberRing)this.coFac;
                res = "AN[ (" + an.ring.varsToString() + ") (" + an.toString() + ") ]";
            }
            if (this.coFac instanceof GenPolynomialRing) {
                GenPolynomialRing rf = (GenPolynomialRing)this.coFac;
                res = "IntFunc( " + rf.toString() + " )";
            }
            if (this.coFac instanceof ModIntegerRing) {
                ModIntegerRing mn = (ModIntegerRing)this.coFac;
                res = "Mod " + mn.getModul() + " ";
            }
            if (res == null && (res = this.coFac.toString()).matches("[0-9].*")) {
                res = scf;
            }
            res = res + "( " + this.varsToString() + " ) " + this.tord.toString() + " ";
        } else {
            res = this.getClass().getSimpleName() + "[ " + this.coFac.toString() + " ";
            if (this.coFac instanceof AlgebraicNumberRing) {
                AlgebraicNumberRing an = (AlgebraicNumberRing)this.coFac;
                res = "AN[ (" + an.ring.varsToString() + ") (" + an.modul + ") ]";
            }
            if (this.coFac instanceof GenPolynomialRing) {
                GenPolynomialRing rf = (GenPolynomialRing)this.coFac;
                res = "IntFunc( " + rf.toString() + " )";
            }
            if (this.coFac instanceof ModIntegerRing) {
                ModIntegerRing mn = (ModIntegerRing)this.coFac;
                res = "Mod " + mn.getModul() + " ";
            }
            res = res + "( " + this.varsToString() + " ) " + this.tord.toString() + " ]";
        }
        return res;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GenPolynomialRing)) {
            return false;
        }
        GenPolynomialRing oring = null;
        try {
            oring = (GenPolynomialRing)other;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (oring == null) {
            return false;
        }
        if (this.nvar != oring.nvar) {
            return false;
        }
        if (!this.coFac.equals(oring.coFac)) {
            return false;
        }
        if (!this.tord.equals(oring.tord)) {
            return false;
        }
        return Arrays.equals(this.vars, oring.vars);
    }

    public int hashCode() {
        int h = this.nvar << 27;
        h += this.coFac.hashCode() << 11;
        return h += this.tord.hashCode();
    }

    public String[] getVars() {
        return this.vars;
    }

    public String[] setVars(String[] v) {
        if (v.length != this.nvar) {
            throw new IllegalArgumentException("v not matching number of variables: " + Arrays.toString(v) + ", nvar " + this.nvar);
        }
        String[] t = this.vars;
        this.vars = v;
        return t;
    }

    public String varsToString() {
        if (this.vars == null) {
            return "#" + this.nvar;
        }
        return ExpVector.varsToString(this.vars);
    }

    public C getZEROCoefficient() {
        return (C)((RingElem)this.coFac.getZERO());
    }

    public C getONECoefficient() {
        return (C)((RingElem)this.coFac.getONE());
    }

    @Override
    public GenPolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenPolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.coFac.isField() && this.nvar == 0) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public GenPolynomial<C> valueOf(C a) {
        return new GenPolynomial<C>(this, a);
    }

    public GenPolynomial<C> valueOf(ExpVector e) {
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.getONE(), e);
    }

    public GenPolynomial<C> valueOf(C a, ExpVector e) {
        return new GenPolynomial<C>(this, a, e);
    }

    @Override
    public GenPolynomial<C> fromInteger(long a) {
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public GenPolynomial<C> fromInteger(BigInteger a) {
        return new GenPolynomial<RingElem>(this, (RingElem)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public GenPolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public GenPolynomial<C> random(int n, Random rnd) {
        if (this.nvar == 1) {
            return this.random(3, n, n, 0.7f, rnd);
        }
        return this.random(5, n, 3, 0.3f, rnd);
    }

    public GenPolynomial<C> random(int k, int l, int d, float q) {
        return this.random(k, l, d, q, random);
    }

    public GenPolynomial<C> random(int k, int l, int d, float q, Random rnd) {
        GenPolynomial<RingElem> r = this.getZERO();
        for (int i = 0; i < l; ++i) {
            ExpVector e = ExpVector.EVRAND(this.nvar, d, q, rnd);
            RingElem a = (RingElem)this.coFac.random(k, rnd);
            r = r.sum(a, e);
        }
        return r;
    }

    @Override
    public GenPolynomial<C> copy(GenPolynomial<C> c) {
        return new GenPolynomial(this, c.val);
    }

    public GenPolynomial<C> univariate(int i) {
        return this.univariate(0, i, 1L);
    }

    public GenPolynomial<C> univariate(int i, long e) {
        return this.univariate(0, i, e);
    }

    public GenPolynomial<C> univariate(int modv, int i, long e) {
        GenPolynomial<RingElem> p = this.getZERO();
        int r = this.nvar - modv;
        if (0 <= i && i < r) {
            RingElem one = (RingElem)this.coFac.getONE();
            ExpVector f = ExpVector.create(r, i, e);
            if (modv > 0) {
                f = f.extend(modv, 0, 0L);
            }
            p = p.sum(one, f);
        }
        return p;
    }

    @Override
    public List<GenPolynomial<C>> generators() {
        List cogens = this.coFac.generators();
        List<GenPolynomial<C>> univs = this.univariateList();
        ArrayList<GenPolynomial<C>> gens = new ArrayList<GenPolynomial<C>>(univs.size() + cogens.size());
        for (RingElem c : cogens) {
            gens.add(((GenPolynomial)this.getONE()).multiply(c));
        }
        gens.addAll(univs);
        return gens;
    }

    @Override
    public boolean isFinite() {
        return this.nvar == 0 && this.coFac.isFinite();
    }

    public List<? extends GenPolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    public List<? extends GenPolynomial<C>> univariateList(int modv, long e) {
        ArrayList<GenPolynomial<C>> pols = new ArrayList<GenPolynomial<C>>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            GenPolynomial<C> p = this.univariate(modv, nm - 1 - i, e);
            pols.add(p);
        }
        return pols;
    }

    public GenPolynomialRing<C> extend(int i) {
        String[] v = GenPolynomialRing.newVars("e", i);
        return this.extend(v);
    }

    public GenPolynomialRing<C> extend(String[] vn) {
        if (vn == null || this.vars == null) {
            throw new IllegalArgumentException("vn and vars may not be null");
        }
        int i = vn.length;
        String[] v = new String[this.vars.length + i];
        System.arraycopy(this.vars, 0, v, 0, this.vars.length);
        System.arraycopy(vn, 0, v, this.vars.length, vn.length);
        TermOrder to = this.tord.extend(this.nvar, i);
        GenPolynomialRing<C> pfac = new GenPolynomialRing<C>(this.coFac, this.nvar + i, to, v);
        return pfac;
    }

    public GenPolynomialRing<C> contract(int i) {
        String[] v = null;
        if (this.vars != null) {
            v = new String[this.vars.length - i];
            System.arraycopy(this.vars, 0, v, 0, this.vars.length - i);
        }
        TermOrder to = this.tord.contract(i, this.nvar - i);
        GenPolynomialRing<C> pfac = new GenPolynomialRing<C>(this.coFac, this.nvar - i, to, v);
        return pfac;
    }

    public GenPolynomialRing<GenPolynomial<C>> recursive(int i) {
        if (i <= 0 || i >= this.nvar) {
            throw new IllegalArgumentException("wrong: 0 < " + i + " < " + this.nvar);
        }
        GenPolynomialRing<C> cfac = this.contract(i);
        String[] v = null;
        if (this.vars != null) {
            v = new String[i];
            int k = 0;
            for (int j = this.nvar - i; j < this.nvar; ++j) {
                v[k++] = this.vars[j];
            }
        }
        TermOrder to = this.tord.contract(0, i);
        GenPolynomialRing<GenPolynomial<C>> pfac = new GenPolynomialRing<GenPolynomial<C>>(cfac, i, to, v);
        return pfac;
    }

    public GenPolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    public GenPolynomialRing<C> reverse(boolean partial) {
        String[] v = null;
        if (this.vars != null) {
            int j;
            v = new String[this.vars.length];
            int k = this.tord.getSplit();
            if (partial && k < this.vars.length) {
                for (j = 0; j < k; ++j) {
                    v[this.vars.length - k + j] = this.vars[this.vars.length - 1 - j];
                }
                System.arraycopy(this.vars, 0, v, 0, this.vars.length - k);
            } else {
                for (j = 0; j < this.vars.length; ++j) {
                    v[j] = this.vars[this.vars.length - 1 - j];
                }
            }
        }
        TermOrder to = this.tord.reverse(partial);
        GenPolynomialRing<C> pfac = new GenPolynomialRing<C>(this.coFac, this.nvar, to, v);
        pfac.partial = partial;
        return pfac;
    }

    public PolynomialComparator<C> getComparator() {
        return new PolynomialComparator(this.tord, false);
    }

    public static String[] newVars(String prefix, int n) {
        String[] vars = new String[n];
        int m = knownVars.size();
        String name = prefix + m;
        for (int i = 0; i < n; ++i) {
            while (knownVars.contains(name)) {
                name = prefix + ++m;
            }
            vars[i] = name;
            knownVars.add(name);
            name = prefix + ++m;
        }
        return vars;
    }

    public String[] newVars(String prefix) {
        return GenPolynomialRing.newVars(prefix, this.nvar);
    }

    public static void addVars(String[] vars) {
        if (vars == null) {
            return;
        }
        Collections.addAll(knownVars, vars);
    }

    @Override
    public Iterator<GenPolynomial<C>> iterator() {
        if (this.coFac.isFinite()) {
            return new GenPolynomialIterator(this);
        }
        return new GenPolynomialMonomialIterator(this);
    }
}

