/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.gb;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.gb.Reduction;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.gb.ReductionSeq;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.vector.BasicLinAlg;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;

public class GroebnerBase<C extends RingElem<C>>
implements Serializable {
    public final Reduction<C> red;
    public final BasicLinAlg<GenPolynomial<C>> blas;

    public GroebnerBase() {
        this(new ReductionSeq());
    }

    public GroebnerBase(Reduction<C> red) {
        this.red = red;
        this.blas = new BasicLinAlg();
    }

    public int commonZeroTest(List<GenPolynomial<C>> F) {
        if (F == null || F.isEmpty()) {
            return 1;
        }
        GenPolynomialRing pfac = F.get((int)0).ring;
        if (pfac.nvar <= 0) {
            return -1;
        }
        HashSet<Integer> v = new HashSet<Integer>();
        for (GenPolynomial<C> p : F) {
            int[] u;
            if (p.isZERO()) continue;
            if (p.isConstant()) {
                return -1;
            }
            ExpVector e = p.leadingExpVector();
            if (e == null || (u = e.dependencyOnVariables()) == null || u.length != 1) continue;
            v.add(u[0]);
        }
        if (pfac.nvar == v.size()) {
            return 0;
        }
        return 1;
    }
}

