/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModIntegerIterator;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.ModularRingFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class ModIntegerRing
implements ModularRingFactory<ModInteger>,
Iterable<ModInteger> {
    public final java.math.BigInteger modul;
    private static final Random random = new Random();
    private int isField = -1;

    public ModIntegerRing(java.math.BigInteger m) {
        this.modul = m;
    }

    public ModIntegerRing(java.math.BigInteger m, boolean isField) {
        this.modul = m;
        this.isField = isField ? 1 : 0;
    }

    public java.math.BigInteger getModul() {
        return this.modul;
    }

    @Override
    public BigInteger getIntegerModul() {
        return new BigInteger(this.modul);
    }

    public ModInteger create(java.math.BigInteger c) {
        return new ModInteger(this, c);
    }

    public ModInteger create(long c) {
        return new ModInteger(this, c);
    }

    @Override
    public ModInteger copy(ModInteger c) {
        return new ModInteger(this, c.val);
    }

    @Override
    public ModInteger getZERO() {
        return new ModInteger(this, java.math.BigInteger.ZERO);
    }

    @Override
    public ModInteger getONE() {
        return new ModInteger(this, java.math.BigInteger.ONE);
    }

    @Override
    public List<ModInteger> generators() {
        ArrayList<ModInteger> g = new ArrayList<ModInteger>(1);
        g.add(this.getONE());
        return g;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        if (this.modul.isProbablePrime(this.modul.bitLength())) {
            this.isField = 1;
            return true;
        }
        this.isField = 0;
        return false;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return this.modul;
    }

    @Override
    public ModInteger fromInteger(java.math.BigInteger a) {
        return new ModInteger(this, a);
    }

    @Override
    public ModInteger fromInteger(long a) {
        return new ModInteger(this, a);
    }

    public String toString() {
        return " bigMod(" + this.modul.toString() + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof ModIntegerRing)) {
            return false;
        }
        ModIntegerRing m = (ModIntegerRing)b;
        return 0 == this.modul.compareTo(m.modul);
    }

    public int hashCode() {
        return this.modul.hashCode();
    }

    @Override
    public ModInteger random(int n) {
        return this.random(n, random);
    }

    @Override
    public ModInteger random(int n, Random rnd) {
        java.math.BigInteger v = new java.math.BigInteger(n, rnd);
        return new ModInteger(this, v);
    }

    @Override
    public ModInteger chineseRemainder(ModInteger c, ModInteger ci, ModInteger a) {
        ModInteger b = a.ring.fromInteger(c.val);
        ModInteger d = a.subtract(b);
        if (d.isZERO()) {
            return this.fromInteger(c.val);
        }
        b = d.multiply(ci);
        java.math.BigInteger s = c.ring.modul.multiply(b.val);
        s = s.add(c.val);
        return this.fromInteger(s);
    }

    @Override
    public Iterator<ModInteger> iterator() {
        return new ModIntegerIterator(this);
    }
}

