/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith;

import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigRational;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.GcdRingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class BigComplex
implements GcdRingElem<BigComplex>,
RingFactory<BigComplex> {
    public final BigRational re;
    public final BigRational im;
    private static final Random random = new Random();
    public static final BigComplex ZERO = new BigComplex();
    public static final BigComplex ONE = new BigComplex(BigRational.ONE);
    public static final BigComplex I = new BigComplex(BigRational.ZERO, BigRational.ONE);

    public BigComplex(BigRational r, BigRational i) {
        this.re = r;
        this.im = i;
    }

    public BigComplex(BigRational r) {
        this(r, BigRational.ZERO);
    }

    public BigComplex() {
        this(BigRational.ZERO);
    }

    public BigComplex factory() {
        return this;
    }

    @Override
    public List<BigComplex> generators() {
        ArrayList<BigComplex> g = new ArrayList<BigComplex>(2);
        g.add(this.getONE());
        g.add(this.getIMAG());
        return g;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigComplex copy() {
        return new BigComplex(this.re, this.im);
    }

    @Override
    public BigComplex copy(BigComplex c) {
        return new BigComplex(c.re, c.im);
    }

    @Override
    public BigComplex getZERO() {
        return ZERO;
    }

    @Override
    public BigComplex getONE() {
        return ONE;
    }

    public BigComplex getIMAG() {
        return I;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigComplex fromInteger(BigInteger a) {
        return new BigComplex(new BigRational(a));
    }

    @Override
    public BigComplex fromInteger(long a) {
        return new BigComplex(new BigRational(a));
    }

    public BigRational getRe() {
        return this.re;
    }

    public BigRational getIm() {
        return this.im;
    }

    public String toString() {
        String s = "" + this.re;
        int i = this.im.compareTo(BigRational.ZERO);
        if (i == 0) {
            return s;
        }
        s = s + "i" + this.im;
        return s;
    }

    @Override
    public boolean isZERO() {
        return this.re.equals(BigRational.ZERO) && this.im.equals(BigRational.ZERO);
    }

    @Override
    public boolean isONE() {
        return this.re.equals(BigRational.ONE) && this.im.equals(BigRational.ZERO);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof BigComplex)) {
            return false;
        }
        BigComplex bc = (BigComplex)b;
        return this.re.equals(bc.re) && this.im.equals(bc.im);
    }

    @Override
    public int hashCode() {
        return 37 * this.re.hashCode() + this.im.hashCode();
    }

    @Override
    public int compareTo(BigComplex b) {
        int s = this.re.compareTo(b.re);
        if (s != 0) {
            return s;
        }
        return this.im.compareTo(b.im);
    }

    @Override
    public int signum() {
        int s = this.re.signum();
        if (s != 0) {
            return s;
        }
        return this.im.signum();
    }

    @Override
    public BigComplex sum(BigComplex B) {
        return new BigComplex(this.re.sum(B.re), this.im.sum(B.im));
    }

    @Override
    public BigComplex subtract(BigComplex B) {
        return new BigComplex(this.re.subtract(B.re), this.im.subtract(B.im));
    }

    @Override
    public BigComplex negate() {
        return new BigComplex(this.re.negate(), this.im.negate());
    }

    public BigComplex conjugate() {
        return new BigComplex(this.re, this.im.negate());
    }

    public BigComplex norm() {
        BigRational v = this.re.multiply(this.re);
        v = v.sum(this.im.multiply(this.im));
        return new BigComplex(v);
    }

    @Override
    public BigComplex abs() {
        BigComplex n = this.norm();
        return n;
    }

    @Override
    public BigComplex multiply(BigComplex B) {
        return new BigComplex(this.re.multiply(B.re).subtract(this.im.multiply(B.im)), this.re.multiply(B.im).sum(this.im.multiply(B.re)));
    }

    @Override
    public BigComplex inverse() {
        BigRational a = this.norm().re.inverse();
        return new BigComplex(this.re.multiply(a), this.im.multiply(a.negate()));
    }

    @Override
    public BigComplex remainder(BigComplex S) {
        if (S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    @Override
    public BigComplex divide(BigComplex B) {
        return this.multiply(B.inverse());
    }

    @Override
    public BigComplex random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigComplex random(int n, Random rnd) {
        BigRational r = BigRational.ONE.random(n, rnd);
        BigRational i = BigRational.ONE.random(n, rnd);
        return new BigComplex(r, i);
    }

    @Override
    public BigComplex gcd(BigComplex S) {
        if (S == null || S.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return S;
        }
        return ONE;
    }

    public BigComplex[] egcd(BigComplex S) {
        BigComplex[] ret = new BigComplex[]{null, null, null};
        if (S == null || S.isZERO()) {
            ret[0] = this;
            return ret;
        }
        if (this.isZERO()) {
            ret[0] = S;
            return ret;
        }
        BigComplex half = new BigComplex(new BigRational(1L, 2L));
        ret[0] = ONE;
        ret[1] = this.inverse().multiply(half);
        ret[2] = S.inverse().multiply(half);
        return ret;
    }
}

