/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations.factor;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.Rational;
import cc.redberry.core.tensor.MultiTensor;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.factor.FactorizationEngine;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigInteger;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.arith.BigRational;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.ExpVector;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.GenPolynomialRing;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.Monomial;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.poly.PolyUtil;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.structure.RingElem;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorAbstract;
import cc.redberry.core.transformations.factor.jasfactor.edu.jas.ufd.FactorFactory;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;

public final class JasFactor
implements FactorizationEngine {
    public static final JasFactor ENGINE = new JasFactor();
    static final char START_CHAR = 'a';
    private static final NumberConverter<BigRational> RationalConverter = new NumberConverter<BigRational>(){

        @Override
        public BigRational convertComplex(Complex complex) {
            Rational rational = (Rational)complex.getReal();
            return new BigRational(new BigInteger(rational.getNumerator()), new BigInteger(rational.getDenominator()));
        }
    };
    private static final NumberConverter<BigInteger> IntegerConverter = new NumberConverter<BigInteger>(){

        @Override
        public BigInteger convertComplex(Complex complex) {
            return new BigInteger(((Rational)complex.getReal()).getNumerator());
        }
    };

    private JasFactor() {
    }

    @Override
    public Tensor factor(Tensor tensor) {
        return JasFactor.factor1(tensor);
    }

    static Tensor factor1(Tensor t) {
        SortedMap map;
        GenPolynomial poly;
        java.math.BigInteger lcm;
        java.math.BigInteger gcd;
        if (!(t instanceof MultiTensor) && !(t instanceof Power)) {
            return t;
        }
        TIntObjectMap<Var> vars = JasFactor.getVars(t);
        Object[] varsArray = (Var[])vars.values((Object[])new Var[vars.size()]);
        Arrays.sort(varsArray);
        String[] forFactoryNames = new String[varsArray.length];
        for (int i = 0; i < varsArray.length; ++i) {
            ((Var)varsArray[i]).position = i;
            forFactoryNames[((Var)varsArray[i]).position] = String.valueOf((char)(97 + i));
            ((Var)varsArray[i]).polyName = forFactoryNames[((Var)varsArray[i]).position];
        }
        GenPolynomialRing<BigInteger> factory = new GenPolynomialRing<BigInteger>(BigInteger.ONE, forFactoryNames);
        if (JasFactor.containsRationals(t)) {
            GenPolynomialRing<BigRational> ratFactory = new GenPolynomialRing<BigRational>(BigRational.ONE, forFactoryNames);
            GenPolynomial<BigRational> polyRat = JasFactor.tensor2Poly(t, ratFactory, vars, RationalConverter);
            Object[] factors = PolyUtil.integerFromRationalCoefficientsFactor(factory, polyRat);
            gcd = (java.math.BigInteger)factors[0];
            lcm = (java.math.BigInteger)factors[1];
            poly = (GenPolynomial)factors[2];
        } else {
            gcd = java.math.BigInteger.ONE;
            lcm = java.math.BigInteger.ONE;
            poly = JasFactor.tensor2Poly(t, factory, vars, IntegerConverter);
        }
        if (poly.isZERO()) {
            return Complex.ZERO;
        }
        FactorAbstract<BigInteger> jasFactor = FactorFactory.getImplementation(BigInteger.ONE);
        if (!jasFactor.isFactorization(poly, map = jasFactor.factors(poly))) {
            return t;
        }
        ArrayList<Tensor> toMultiply = new ArrayList<Tensor>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            toMultiply.add(Tensors.pow(JasFactor.poly2Tensor(entry.getKey(), (Var[])varsArray), new Complex(entry.getValue())));
        }
        if (!gcd.equals(java.math.BigInteger.ONE) || !lcm.equals(java.math.BigInteger.ONE)) {
            toMultiply.add(new Complex(new Rational(gcd, lcm)));
        }
        return Tensors.multiply(toMultiply.toArray(new Tensor[toMultiply.size()]));
    }

    static <T extends RingElem<T>> GenPolynomial<T> tensor2Poly(Tensor tensor, GenPolynomialRing<T> factory, TIntObjectMap<Var> vars, NumberConverter<T> numberConverter) {
        if (tensor.getClass() == SimpleTensor.class) {
            return ((GenPolynomial)factory.getONE()).multiply(ExpVector.create(vars.size(), ((Var)vars.get((int)((SimpleTensor)tensor).getName())).position, 1L));
        }
        if (tensor.getClass() == Power.class) {
            long pow;
            if (tensor.get(0) instanceof SimpleTensor) {
                return ((GenPolynomial)factory.getONE()).multiply(ExpVector.create(vars.size(), ((Var)vars.get((int)((SimpleTensor)tensor.get((int)0)).getName())).position, pow));
            }
            GenPolynomial<GenPolynomial<T>> result = factory.getONE();
            GenPolynomial<Object> base = JasFactor.tensor2Poly(tensor.get(0), factory, vars, numberConverter);
            for (pow = ((Complex)tensor.get(1)).longValue(); pow > 0L; pow >>>= 1) {
                if ((pow & 1L) != 0L) {
                    result = result.multiply((GenPolynomial<T>)base);
                }
                base = base.multiply((T)base);
            }
            return result;
        }
        if (tensor.getClass() == Sum.class) {
            GenPolynomial<GenPolynomial<T>> result = factory.getZERO();
            for (Tensor t : tensor) {
                result = result.sum(JasFactor.tensor2Poly(t, factory, vars, numberConverter));
            }
            return result;
        }
        if (tensor.getClass() == Product.class) {
            GenPolynomial<GenPolynomial<T>> result = factory.getONE();
            for (Tensor t : tensor) {
                result = result.multiply(JasFactor.tensor2Poly(t, factory, vars, numberConverter));
            }
            return result;
        }
        if (tensor.getClass() == Complex.class) {
            return ((GenPolynomial)factory.getONE()).multiply(numberConverter.convertComplex((Complex)tensor));
        }
        throw new RuntimeException();
    }

    private static boolean containsRationals(Tensor tensor) {
        if (tensor instanceof Complex) {
            return !((Complex)tensor).isInteger();
        }
        for (Tensor t : tensor) {
            if (!JasFactor.containsRationals(t)) continue;
            return true;
        }
        return false;
    }

    static Tensor poly2Tensor(GenPolynomial<BigInteger> poly, Var[] varsArray) {
        if (poly.length() == 0) {
            return Complex.ZERO;
        }
        ArrayList<Tensor> temp = new ArrayList<Tensor>();
        ArrayList<Tensor> sum = new ArrayList<Tensor>(poly.length());
        for (Monomial<BigInteger> monomial : poly) {
            BigInteger coefficient = monomial.coefficient();
            ExpVector exp = monomial.exponent();
            temp.clear();
            temp.add(new Complex(new Rational(coefficient.getVal())));
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                temp.add(Tensors.pow((Tensor)varsArray[i].simpleTensor, new Complex(lExp)));
            }
            sum.add(Tensors.multiply(temp.toArray(new Tensor[temp.size()])));
        }
        return Tensors.sum(sum.toArray(new Tensor[sum.size()]));
    }

    static TIntObjectMap<Var> getVars(Tensor ... tensors) {
        TIntObjectHashMap vars = new TIntObjectHashMap();
        for (Tensor t : tensors) {
            JasFactor.addVars(t, (TIntObjectMap<Var>)vars, 1L);
        }
        return vars;
    }

    static void addVars(Tensor tensor, TIntObjectMap<Var> vars, long power) {
        if (power < 0L) {
            throw new IllegalArgumentException("Negative powers.");
        }
        if (tensor.getClass() == SimpleTensor.class) {
            if (tensor.getIndices().size() != 0) {
                throw new IllegalArgumentException();
            }
            int name = ((SimpleTensor)tensor).getName();
            Var var = (Var)vars.get(name);
            if (var == null) {
                var = new Var((SimpleTensor)tensor);
                vars.put(name, (Object)var);
            }
            var.maxPower = Math.max(power, var.maxPower);
            return;
        }
        if (tensor.getClass() == Power.class) {
            if (!TensorUtils.isNaturalNumber(tensor.get(1))) {
                throw new IllegalArgumentException(tensor.toString());
            }
            long pow = power * ((Complex)tensor.get(1)).longValue();
            JasFactor.addVars(tensor.get(0), vars, pow);
            return;
        }
        if (tensor instanceof MultiTensor) {
            for (Tensor t : tensor) {
                JasFactor.addVars(t, vars, power);
            }
            return;
        }
        if (tensor.getClass() == Complex.class) {
            if (((Complex)tensor).isNumeric() || !((Complex)tensor).isReal()) {
                throw new IllegalArgumentException("Illegal coefficient: " + tensor);
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    static GenPolynomial<BigInteger> tensor2Poly(Tensor t) {
        GenPolynomial poly;
        TIntObjectMap<Var> vars = JasFactor.getVars(t);
        Object[] varsArray = (Var[])vars.values((Object[])new Var[vars.size()]);
        Arrays.sort(varsArray);
        String[] forFactoryNames = new String[varsArray.length];
        for (int i = 0; i < varsArray.length; ++i) {
            ((Var)varsArray[i]).position = i;
            forFactoryNames[((Var)varsArray[i]).position] = String.valueOf((char)(97 + i));
            ((Var)varsArray[i]).polyName = forFactoryNames[((Var)varsArray[i]).position];
        }
        GenPolynomialRing<BigInteger> factory = new GenPolynomialRing<BigInteger>(BigInteger.ONE, forFactoryNames);
        if (JasFactor.containsRationals(t)) {
            GenPolynomialRing<BigRational> ratFactory = new GenPolynomialRing<BigRational>(BigRational.ONE, forFactoryNames);
            GenPolynomial<BigRational> polyRat = JasFactor.tensor2Poly(t, ratFactory, vars, RationalConverter);
            Object[] factors = PolyUtil.integerFromRationalCoefficientsFactor(factory, polyRat);
            poly = (GenPolynomial)factors[2];
        } else {
            poly = JasFactor.tensor2Poly(t, factory, vars, IntegerConverter);
        }
        return poly;
    }

    static class Var
    implements Comparable<Var> {
        final int name;
        String polyName = null;
        int position;
        long maxPower;
        final SimpleTensor simpleTensor;

        private Var(SimpleTensor simpleTensor) {
            this.simpleTensor = simpleTensor;
            this.name = simpleTensor.getName();
        }

        @Override
        public int compareTo(Var o) {
            return -Long.compare(o.maxPower, this.maxPower);
        }
    }

    private static interface NumberConverter<T extends RingElem<T>> {
        public T convertComplex(Complex var1);
    }
}

