/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations;

import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.iterator.TraverseGuide;
import cc.redberry.core.tensor.iterator.TraverseState;
import cc.redberry.core.tensor.iterator.TreeTraverseIterator;
import cc.redberry.core.transformations.Transformation;

public class Transformer
implements Transformation {
    private final TraverseState state;
    private final Transformation[] transformations;
    private final TraverseGuide guide;

    public Transformer(TraverseState state, Transformation[] transformations, TraverseGuide guide) {
        this.state = state;
        this.transformations = transformations;
        this.guide = guide;
    }

    public Transformer(TraverseState state, Transformation[] transformations) {
        this.state = state;
        this.transformations = transformations;
        this.guide = TraverseGuide.ALL;
    }

    @Override
    public Tensor transform(Tensor t) {
        TraverseState currentState;
        TreeTraverseIterator iterator = new TreeTraverseIterator(t, this.guide);
        while ((currentState = iterator.next()) != null) {
            Tensor newTensor;
            if (currentState != this.state) continue;
            Tensor currentTensor = newTensor = iterator.current();
            for (Transformation transformation : this.transformations) {
                newTensor = transformation.transform(newTensor);
            }
            if (currentTensor == newTensor) continue;
            iterator.set(newTensor);
        }
        return iterator.result();
    }
}

