/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations;

import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.iterator.TraverseState;
import cc.redberry.core.tensor.iterator.TreeTraverseIterator;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.TensorUtils;

public final class EliminateDueSymmetriesTransformation
implements Transformation {
    public static final EliminateDueSymmetriesTransformation ELIMINATE_DUE_SYMMETRIES = new EliminateDueSymmetriesTransformation();

    private EliminateDueSymmetriesTransformation() {
    }

    @Override
    public Tensor transform(Tensor t) {
        TraverseState state;
        TreeTraverseIterator iterator = new TreeTraverseIterator(t);
        while ((state = iterator.next()) != null) {
            Tensor c;
            if (state != TraverseState.Leaving || !TensorUtils.isZeroDueToSymmetry(c = iterator.current())) continue;
            iterator.set(Complex.ZERO);
        }
        return iterator.result();
    }
}

