/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.transformations;

import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.SumBuilderSplitingScalars;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.Transformation;

public final class CollectNonScalarsTransformation
implements Transformation {
    public static final CollectNonScalarsTransformation COLLECT_NON_SCALARS = new CollectNonScalarsTransformation();

    private CollectNonScalarsTransformation() {
    }

    @Override
    public Tensor transform(Tensor t) {
        return CollectNonScalarsTransformation.collectNonScalars(t);
    }

    public static Tensor collectNonScalars(Tensor t) {
        Tensor c;
        FromChildToParentIterator iterator = new FromChildToParentIterator(t);
        while ((c = iterator.next()) != null) {
            if (!(c instanceof Sum)) continue;
            SumBuilderSplitingScalars sbss = new SumBuilderSplitingScalars(c.size());
            for (Tensor tt : c) {
                sbss.put(tt);
            }
            iterator.set(sbss.build());
        }
        return iterator.result();
    }
}

