/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.random;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.groups.permutations.Permutations;
import cc.redberry.core.indexgenerator.IndexGeneratorImpl;
import cc.redberry.core.indexmapping.Mapping;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.IntArrayList;
import cc.redberry.core.utils.TensorUtils;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well1024a;
import org.apache.commons.math3.random.Well19937c;

public final class RandomTensor {
    protected final RandomGenerator random;
    protected long seed;
    protected static final byte TYPES_COUNT = 8;
    protected static final byte[] TYPES = IndexType.getBytes();
    protected static final int[] ALPHABETS_SIZES = new int[8];
    private final int[] minIndices;
    private final int[] maxIndices;
    private final int diffStringNames;
    private final boolean withSymmetries;
    private final List<NameDescriptor> namespace;
    private final int initialNamespaceSize;
    private final boolean generateNewDescriptors;

    public RandomTensor() {
        this(true);
    }

    public RandomTensor(boolean generateNewDescriptors) {
        this(2, 5, new int[]{0, 0, 0, 0}, new int[]{4, 4, 4, 4}, true, generateNewDescriptors);
    }

    public RandomTensor(int minDiffNDs, int maxDiffNDs, int[] minIndices, int[] maxIndices, boolean withSymmetries, boolean generateNewDescriptors, RandomGenerator random) {
        this.generateNewDescriptors = generateNewDescriptors;
        this.random = random;
        this.seed = random.nextLong();
        this.random.setSeed(this.seed);
        this.minIndices = Arrays.copyOf(minIndices, 8);
        this.maxIndices = Arrays.copyOf(maxIndices, 8);
        this.withSymmetries = withSymmetries;
        int di = 1;
        for (int i = 0; i < 8; ++i) {
            int t = this.maxIndices[i] - this.minIndices[i];
            di *= t == 0 ? 1 : t;
        }
        this.diffStringNames = (maxDiffNDs - minDiffNDs) / di;
        this.initialNamespaceSize = minDiffNDs + (int)(0.5 * (double)(maxDiffNDs - minDiffNDs));
        this.namespace = new ArrayList<NameDescriptor>(this.initialNamespaceSize);
        this.generateDescriptors();
    }

    public RandomTensor(int minDiffNDs, int maxDiffNDs, int[] minIndices, int[] maxIndices, boolean withSymmetries, boolean generateNewDescriptors, long seed) {
        this(minDiffNDs, maxDiffNDs, minIndices, maxIndices, withSymmetries, generateNewDescriptors, (RandomGenerator)new Well1024a(seed));
    }

    public RandomTensor(int minDiffNDs, int maxDiffNDs, int[] minIndices, int[] maxIndices, boolean withSymmetries, boolean generateNewDescriptors) {
        this(minDiffNDs, maxDiffNDs, minIndices, maxIndices, withSymmetries, generateNewDescriptors, (RandomGenerator)new Well19937c());
    }

    public RandomGenerator getRandom() {
        return this.random;
    }

    public void clearNamespace() {
        this.namespace.clear();
    }

    public void reset() {
        this.seed = this.random.nextLong();
        this.random.setSeed(this.seed);
        this.generateDescriptors();
    }

    public void reset(long seed) {
        this.seed = seed;
        this.random.setSeed(this.seed);
        this.generateDescriptors();
    }

    public final int nextInt(int n) {
        if (n == 0) {
            return 0;
        }
        return this.random.nextInt(n);
    }

    public long getSeed() {
        return this.seed;
    }

    private void generateDescriptors() {
        if (!this.generateNewDescriptors) {
            return;
        }
        for (int i = 0; i < this.initialNamespaceSize; ++i) {
            int[] typesCount = new int[8];
            for (int j = 0; j < 8; ++j) {
                typesCount[j] = this.minIndices[j] + this.nextInt(this.maxIndices[j] - this.minIndices[j]);
            }
            StructureOfIndices typeStructure = StructureOfIndices.create(TYPES, typesCount);
            NameDescriptor nameDescriptor = CC.getNameManager().mapNameDescriptor(this.nextName(), typeStructure);
            if (this.withSymmetries) {
                this.addRandomSymmetries(nameDescriptor);
            }
            this.namespace.add(nameDescriptor);
        }
    }

    private String nextName() {
        int i = this.diffStringNames < 10 ? this.nextInt(10) : this.nextInt(this.diffStringNames);
        int second = i / ALPHABETS_SIZES[1];
        int first = i - second * ALPHABETS_SIZES[1];
        if (second == 0) {
            return new String(new char[]{(char)(65 + first)});
        }
        return new String(new char[]{(char)(64 + second), (char)(65 + first)});
    }

    public void addToNamespace(Tensor ... tensors) {
        for (SimpleTensor st : TensorUtils.getAllDiffSimpleTensors(tensors)) {
            this.namespace.add(st.getNameDescriptor());
        }
    }

    public int getInitialNamespaceSize() {
        return this.initialNamespaceSize;
    }

    public int getNamespaceSize() {
        return this.namespace.size();
    }

    public NameDescriptor nextNameDescriptor() {
        return this.namespace.get(this.nextInt(this.namespace.size()));
    }

    private NameDescriptor nextNameDescriptor(StructureOfIndices typeStructure) {
        IntArrayList positions = new IntArrayList();
        for (int i = this.namespace.size() - 1; i >= 0; --i) {
            if (!this.namespace.get(i).getStructureOfIndices().equals(typeStructure)) continue;
            positions.add(i);
        }
        if (!positions.isEmpty()) {
            return this.namespace.get(positions.get(this.random.nextInt(positions.size())));
        }
        if (!this.generateNewDescriptors) {
            throw new IllegalArgumentException("No descriptor for such structure.");
        }
        NameDescriptor nameDescriptor = CC.getNameManager().mapNameDescriptor(this.nextName(), typeStructure);
        if (this.withSymmetries) {
            this.addRandomSymmetries(nameDescriptor);
        }
        if (this.namespace.indexOf(nameDescriptor) == -1) {
            this.namespace.add(nameDescriptor);
        }
        return nameDescriptor;
    }

    private void addRandomSymmetries(NameDescriptor descriptor) {
        if (!descriptor.getSymmetries().isTrivial()) {
            return;
        }
        StructureOfIndices typeStructure = descriptor.getStructureOfIndices();
        for (byte type = 0; type < 8; type = (byte)(type + 1)) {
            StructureOfIndices.TypeData typeData = typeStructure.getTypeData(type);
            if (typeData == null || typeData.length == 0) continue;
            int count = this.random.nextInt(4);
            for (int i = 0; i < count; ++i) {
                descriptor.getSymmetries().addSymmetry(type, Permutations.createPermutation(false, this.nextPermutation(typeData.length)));
            }
        }
    }

    public SimpleTensor nextSimpleTensor(SimpleIndices indices) {
        NameDescriptor nd = this.nextNameDescriptor(indices.getStructureOfIndices());
        StructureOfIndices structureOfIndices = nd.getStructureOfIndices();
        int[] _indices = this.nextIndices(structureOfIndices);
        return Tensors.simpleTensor(nd.getId(), IndicesFactory.createSimple(nd.getSymmetries(), _indices));
    }

    public SimpleTensor nextSimpleTensor() {
        NameDescriptor nd = this.nextNameDescriptor();
        StructureOfIndices structureOfIndices = nd.getStructureOfIndices();
        int[] indices = this.nextIndices(structureOfIndices);
        return Tensors.simpleTensor(nd.getId(), IndicesFactory.createSimple(nd.getSymmetries(), indices));
    }

    public Tensor nextProduct(int minProductSize, Indices indices) {
        if (minProductSize < 2) {
            throw new IllegalArgumentException();
        }
        return this.nextProductTree(1, new Parameters(0, 0, minProductSize, minProductSize), indices);
    }

    public Tensor nextProduct(int minProductSize) {
        return this.nextProduct(minProductSize, IndicesFactory.createSimple(null, this.nextIndices(this.nextNameDescriptor().getStructureOfIndices())));
    }

    public Tensor nextSum(Parameters parameters, Indices indices) {
        return this.nextSumTree(2, parameters, indices);
    }

    public Tensor nextSum(int sumSize, int productSize, Indices indices) {
        return this.nextSumTree(2, new Parameters(sumSize, sumSize, productSize, productSize), indices);
    }

    public Tensor nextTensorTree(int depth, Parameters parameters, Indices indices) {
        return this.nextTensorTree(this.random.nextBoolean() ? TensorType.Product : TensorType.Sum, depth, parameters, indices);
    }

    public Tensor nextTensorTree(TensorType head, int depth, Parameters parameters, Indices indices) {
        if (head == null) {
            this.nextTensorTree(depth, parameters, indices);
        }
        indices = indices.getFree();
        if (depth == 0) {
            return this.nextSimpleTensor(IndicesFactory.createSimple(null, indices));
        }
        if (head == TensorType.Product) {
            return this.nextProductTree(depth, parameters, indices);
        }
        if (head == TensorType.Sum) {
            return this.nextSumTree(depth, parameters, indices);
        }
        throw new RuntimeException();
    }

    protected Tensor nextTensorTree(TensorType head, int depth, Parameters parameters) {
        return this.nextTensorTree(head, depth, parameters, (Indices)IndicesFactory.createSimple(null, this.nextIndices(this.nextNameDescriptor().getStructureOfIndices())));
    }

    /*
     * WARNING - void declaration
     */
    public Tensor nextProductTree(int depth, Parameters parameters, Indices indices) {
        void var17_26;
        int n;
        Object typeData;
        Tensor nd;
        int i;
        int productSize = this.getRandomValue(parameters.minProductSize, parameters.maxProductSize);
        indices = indices.getFree();
        StructureOfIndices typeStructure = StructureOfIndices.create(IndicesFactory.createSimple(null, indices));
        ArrayList<Tensor> descriptors = new ArrayList<Tensor>();
        int[] totalIndicesCounts = new int[TYPES.length];
        for (i = 0; i < productSize; ++i) {
            nd = this.nextTensorTree(TensorType.Sum, depth - 1, parameters);
            descriptors.add(nd);
            for (byte b : TYPES) {
                typeData = IndicesFactory.createSimple(null, nd.getIndices().getFree()).getStructureOfIndices().getTypeData(b);
                if (typeData == null) continue;
                byte by = b;
                totalIndicesCounts[by] = totalIndicesCounts[by] + ((StructureOfIndices.TypeData)typeData).length;
            }
        }
        for (byte b : TYPES) {
            typeData = typeStructure.getTypeData(b);
            if (typeData == null) continue;
            while (totalIndicesCounts[b] < ((StructureOfIndices.TypeData)typeData).length) {
                nd = this.nextTensorTree(TensorType.Sum, depth - 1, parameters);
                descriptors.add(nd);
                byte[] byArray = TYPES;
                n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    byte bb = byArray[j];
                    StructureOfIndices.TypeData typeData1 = IndicesFactory.createSimple(null, nd.getIndices().getFree()).getStructureOfIndices().getTypeData(bb);
                    if (typeData1 == null) continue;
                    byte by = bb;
                    totalIndicesCounts[by] = totalIndicesCounts[by] + typeData1.length;
                }
            }
        }
        for (byte b : TYPES) {
            typeData = typeStructure.getTypeData(b);
            if ((totalIndicesCounts[b] - (typeData == null ? 0 : ((StructureOfIndices.TypeData)typeData).length)) % 2 == 0) continue;
            int[] typeCount = new int[TYPES.length];
            typeCount[b] = 1;
            descriptors.add(this.nextTensorTree(TensorType.Sum, depth - 1, parameters, (Indices)IndicesFactory.createSimple(null, this.nextIndices(StructureOfIndices.create(TYPES, typeCount)))));
            byte by = b;
            totalIndicesCounts[by] = totalIndicesCounts[by] + 1;
        }
        int[] _freeIndices = indices.getFree().getAllIndices().copy();
        int[][] freeIndices = new int[TYPES.length][];
        int[][] indicesSpace = new int[TYPES.length][];
        IndexGeneratorImpl indexGenerator = new IndexGeneratorImpl((int[])_freeIndices.clone());
        for (Object object : (Object)TYPES) {
            indicesSpace[object] = new int[totalIndicesCounts[object]];
            StructureOfIndices.TypeData typeData2 = typeStructure.getTypeData((byte)object);
            if (typeData2 == null) {
                freeIndices[object] = new int[0];
            } else {
                freeIndices[object] = new int[typeData2.length];
                System.arraycopy(_freeIndices, typeData2.from, freeIndices[object], 0, typeData2.length);
            }
            int diff = (totalIndicesCounts[object] - freeIndices[object].length) / 2;
            for (i = 0; i < diff; ++i) {
                indicesSpace[object][i] = indexGenerator.generate((byte)object);
            }
            for (i = 0; i < diff; ++i) {
                indicesSpace[object][i + diff] = IndicesUtils.inverseIndexState(indicesSpace[object][i]);
            }
            System.arraycopy(freeIndices[object], 0, indicesSpace[object], diff * 2, freeIndices[object].length);
            this.shuffle(indicesSpace[object]);
        }
        TIntHashSet forbidden = new TIntHashSet();
        int[][] typeCount = indicesSpace;
        n = typeCount.length;
        boolean bl = false;
        while (var17_26 < n) {
            int[] sp = typeCount[var17_26];
            forbidden.ensureCapacity(sp.length);
            forbidden.addAll(IndicesUtils.getIndicesNames(sp));
            ++var17_26;
        }
        ProductBuilder pb = new ProductBuilder(10, productSize);
        for (Tensor tensor : descriptors) {
            Indices free = tensor.getIndices().getFree();
            StructureOfIndices its = IndicesFactory.createSimple(null, free).getStructureOfIndices();
            int[] factorIndices = new int[its.size()];
            int position = 0;
            for (byte b : TYPES) {
                StructureOfIndices.TypeData typeData3 = its.getTypeData(b);
                if (typeData3 == null || typeData3.length == 0) continue;
                if (typeData3.states == null) {
                    for (i = 0; i < typeData3.length; ++i) {
                        int n2 = position++;
                        byte by = b;
                        int n3 = totalIndicesCounts[by] - 1;
                        totalIndicesCounts[by] = n3;
                        factorIndices[n2] = indicesSpace[b][n3];
                    }
                    continue;
                }
                for (i = 0; i < typeData3.length; ++i) {
                    int n4 = position++;
                    byte by = b;
                    int n5 = totalIndicesCounts[by] - 1;
                    totalIndicesCounts[by] = n5;
                    factorIndices[n4] = IndicesUtils.setState(typeData3.states.get(i), indicesSpace[b][n5]);
                }
            }
            Tensor tensor3 = ApplyIndexMapping.applyIndexMapping(tensor, new Mapping(free.getAllIndices().copy(), factorIndices), forbidden.toArray());
            tensor3 = ApplyIndexMapping.renameDummy(tensor3, forbidden.toArray());
            forbidden.addAll((TIntCollection)TensorUtils.getAllIndicesNamesT(tensor3));
            pb.put(tensor3);
        }
        if (this.random.nextBoolean()) {
            Complex factor = new Complex(1 + this.nextInt(100));
            factor = this.random.nextBoolean() ? factor : factor.negate();
            pb.put(factor);
        }
        return pb.build();
    }

    public Tensor nextSumTree(int depth, Parameters parameters, Indices indices) {
        int sumSize = this.getRandomValue(parameters.minSumSize, parameters.maxSumSize);
        SumBuilder sum = new SumBuilder();
        for (int i = 0; i < sumSize; ++i) {
            sum.put(this.nextTensorTree(TensorType.Product, depth - 1, parameters, indices));
        }
        return sum.build();
    }

    public int[] nextIndices(StructureOfIndices structureOfIndices) {
        int[] indices = new int[structureOfIndices.size()];
        int p = 0;
        for (byte b : TYPES) {
            StructureOfIndices.TypeData typeData = structureOfIndices.getTypeData(b);
            if (typeData == null || typeData.length == 0) continue;
            int[] typeInd = new int[typeData.length];
            if (typeData.states != null) {
                int[] names = this.nextPermutation(typeInd.length);
                for (int i = 0; i < typeInd.length; ++i) {
                    typeInd[i] = IndicesUtils.createIndex(names[i], b, typeData.states.get(i));
                }
            } else {
                int i;
                int contracted = this.nextInt(indices.length / 2);
                contracted = contracted == 0 ? 1 : contracted;
                for (i = 0; i < typeInd.length / contracted; ++i) {
                    typeInd[i] = IndicesUtils.setType(b, i);
                }
                if (i - contracted < 0) {
                    contracted = i;
                }
                while (i < typeInd.length) {
                    typeInd[i] = IndicesUtils.createIndex(i - contracted, b, true);
                    ++i;
                }
                this.shuffle(typeInd);
            }
            System.arraycopy(typeInd, 0, indices, p, typeInd.length);
            p += typeInd.length;
        }
        return indices;
    }

    public int[] nextPermutation(int dimension) {
        return Permutations.randomPermutation(dimension, this.random);
    }

    public final void shuffle(int[] target) {
        if (target.length < 2) {
            return;
        }
        for (int i = 0; i < target.length; ++i) {
            int p2;
            int p1;
            while ((p1 = this.nextInt(target.length)) == (p2 = this.nextInt(target.length))) {
            }
            RandomTensor.swap(target, p1, p2);
        }
    }

    private static void swap(int[] a, int p1, int p2) {
        int c = a[p1];
        a[p1] = a[p2];
        a[p2] = c;
    }

    private int getRandomValue(int min, int max) {
        if (min == max) {
            return min;
        }
        return min + this.random.nextInt(max - min);
    }

    public Tensor nextTensorTree(int depth, int productSize, int sumSize, Indices indices) {
        return this.nextTensorTree(depth, new Parameters(sumSize, sumSize, productSize, productSize), indices);
    }

    public Tensor nextTensorTree(TensorType head, int depth, int productSize, int sumSize, Indices indices) {
        return this.nextTensorTree(head, depth, new Parameters(sumSize, sumSize, productSize, productSize), indices);
    }

    public Tensor nextSumTree(int depth, int productSize, int sumSize, Indices indices) {
        return this.nextSumTree(depth, new Parameters(sumSize, sumSize, productSize, productSize), indices);
    }

    public Tensor nextProductTree(int depth, int productSize, int sumSize, Indices indices) {
        return this.nextProductTree(depth, new Parameters(sumSize, sumSize, productSize, productSize), indices);
    }

    static {
        for (byte b : TYPES) {
            RandomTensor.ALPHABETS_SIZES[b] = IndexType.getType(b).getSymbolConverter().maxNumberOfSymbols();
        }
    }

    public static class Parameters {
        final int minSumSize;
        final int maxSumSize;
        final int minProductSize;
        final int maxProductSize;

        public Parameters(int minSumSize, int maxSumSize, int minProductSize, int maxProductSize) {
            this.minSumSize = minSumSize;
            this.maxSumSize = maxSumSize;
            this.minProductSize = minProductSize;
            this.maxProductSize = maxProductSize;
        }
    }

    public static enum TensorType {
        Product,
        Sum;

    }
}

