/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.ArcTan;
import cc.redberry.core.tensor.functions.Cos;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.utils.TensorUtils;

public final class Tan
extends ScalarFunction {
    Tan(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return Tensors.pow((Tensor)new Cos(this.argument), Complex.MINUS_TWO);
    }

    @Override
    public String functionName() {
        return "Tan";
    }

    @Override
    protected int hash() {
        return 17 * this.argument.hashCode();
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(TanFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return TanFactory.FACTORY;
    }

    public static class TanFactory
    extends ScalarFunctionFactory {
        public static final TanFactory FACTORY = new TanFactory();

        private TanFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof ArcTan) {
                return arg.get(0);
            }
            if (TensorUtils.isZero(arg)) {
                return Complex.ZERO;
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.tan((Complex)arg);
            }
            return new Tan(arg);
        }
    }
}

