/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.functions.ArcSin;
import cc.redberry.core.tensor.functions.Cos;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.utils.TensorUtils;

public final class Sin
extends ScalarFunction {
    Sin(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return new Cos(this.argument);
    }

    @Override
    protected int hash() {
        return 7 * this.argument.hashCode();
    }

    @Override
    public String functionName() {
        return "Sin";
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(SinFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return SinFactory.FACTORY;
    }

    public static final class SinFactory
    extends ScalarFunctionFactory {
        public static final SinFactory FACTORY = new SinFactory();

        private SinFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof ArcSin) {
                return arg.get(0);
            }
            if (TensorUtils.isZero(arg)) {
                return Complex.ZERO;
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.sin((Complex)arg);
            }
            return new Sin(arg);
        }
    }
}

