/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor.functions;

import cc.redberry.core.number.Complex;
import cc.redberry.core.number.ComplexUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.tensor.functions.ScalarFunctionBuilder;
import cc.redberry.core.tensor.functions.ScalarFunctionFactory;
import cc.redberry.core.tensor.functions.Tan;
import cc.redberry.core.utils.TensorUtils;

public class ArcTan
extends ScalarFunction {
    ArcTan(Tensor argument) {
        super(argument);
    }

    @Override
    public Tensor derivative() {
        return Tensors.pow(Tensors.sum(Complex.ONE, Tensors.pow(this.argument, Complex.TWO)), Complex.MINUS_ONE);
    }

    @Override
    protected String functionName() {
        return "ArcTan";
    }

    @Override
    public TensorBuilder getBuilder() {
        return new ScalarFunctionBuilder(ArcTanFactory.FACTORY);
    }

    @Override
    public TensorFactory getFactory() {
        return ArcTanFactory.FACTORY;
    }

    @Override
    protected int hash() {
        return 2321 * this.argument.hashCode();
    }

    public static final class ArcTanFactory
    extends ScalarFunctionFactory {
        public static final ArcTanFactory FACTORY = new ArcTanFactory();

        private ArcTanFactory() {
        }

        @Override
        public Tensor create1(Tensor arg) {
            if (arg instanceof Tan) {
                return arg.get(0);
            }
            if (TensorUtils.isZero(arg)) {
                return Complex.ZERO;
            }
            if (TensorUtils.isNumeric(arg)) {
                return ComplexUtils.arctan((Complex)arg);
            }
            return new ArcTan(arg);
        }
    }
}

