/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.graph.GraphUtils;
import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;
import java.util.Arrays;

public final class StructureOfContractions {
    public static final StructureOfContractions EMPTY_FULL_CONTRACTIONS_STRUCTURE = new StructureOfContractions(new long[0], new long[0][], new int[0], 0);
    public final long[] freeContractions;
    public final long[][] contractions;
    public final int[] components;
    public final int componentCount;
    private static final long dummyTensorInfo = -65536L;

    private StructureOfContractions(long[] freeContractions, long[][] contractions, int[] components, int componentCount) {
        this.freeContractions = freeContractions;
        this.contractions = contractions;
        this.components = components;
        this.componentCount = componentCount;
    }

    StructureOfContractions(Tensor[] data, int differentIndicesCount, Indices freeIndices) {
        int tensorIndex;
        int state;
        int index;
        int i;
        int[] upperIndices = new int[differentIndicesCount];
        int[] lowerIndices = new int[differentIndicesCount];
        long[] upperInfo = new long[differentIndicesCount];
        long[] lowerInfo = new long[differentIndicesCount];
        int[][] indices = new int[][]{lowerIndices, upperIndices};
        long[][] info = new long[][]{lowerInfo, upperInfo};
        int[] pointer = new int[2];
        this.contractions = new long[data.length][];
        this.freeContractions = new long[freeIndices.size()];
        for (i = 0; i < freeIndices.size(); ++i) {
            index = freeIndices.get(i);
            state = 1 - IndicesUtils.getStateInt(index);
            info[state][pointer[state]] = -65536L;
            int n = state;
            int n2 = pointer[n];
            pointer[n] = n2 + 1;
            indices[state][n2] = IndicesUtils.getNameWithType(index);
        }
        for (tensorIndex = 0; tensorIndex < data.length; ++tensorIndex) {
            Indices tInds = data[tensorIndex].getIndices();
            short[] diffIds = tInds.getPositionsInOrbits();
            if (tInds.size() >= 65536) {
                throw new RuntimeException("Too many indices!!! max count = 2^16");
            }
            for (i = 0; i < tInds.size(); ++i) {
                index = tInds.get(i);
                state = IndicesUtils.getStateInt(index);
                info[state][pointer[state]] = StructureOfContractions.packToLong(tensorIndex, diffIds[i], i);
                int n = state;
                int n3 = pointer[n];
                pointer[n] = n3 + 1;
                indices[state][n3] = IndicesUtils.getNameWithType(index);
            }
            this.contractions[tensorIndex] = new long[tInds.size()];
        }
        ArraysUtils.quickSort(indices[0], info[0]);
        ArraysUtils.quickSort(indices[1], info[1]);
        int[] infoTensorIndicesFrom = StructureOfContractions.infoToTensorIndices(lowerInfo);
        int[] infoTensorIndicesTo = StructureOfContractions.infoToTensorIndices(upperInfo);
        int shift = 0;
        int last = 0;
        for (i = 0; i < infoTensorIndicesFrom.length; ++i) {
            if (infoTensorIndicesFrom[i] != -1 && infoTensorIndicesTo[i] != -1) continue;
            System.arraycopy(infoTensorIndicesFrom, last, infoTensorIndicesFrom, last - shift, i - last);
            System.arraycopy(infoTensorIndicesTo, last, infoTensorIndicesTo, last - shift, i - last);
            last = i + 1;
            ++shift;
        }
        System.arraycopy(infoTensorIndicesFrom, last, infoTensorIndicesFrom, last - shift, i - last);
        System.arraycopy(infoTensorIndicesTo, last, infoTensorIndicesTo, last - shift, i - last);
        infoTensorIndicesFrom = Arrays.copyOf(infoTensorIndicesFrom, infoTensorIndicesFrom.length - shift);
        infoTensorIndicesTo = Arrays.copyOf(infoTensorIndicesTo, infoTensorIndicesTo.length - shift);
        int[] components = GraphUtils.calculateConnectedComponents(infoTensorIndicesFrom, infoTensorIndicesTo, data.length);
        this.componentCount = components[components.length - 1];
        this.components = Arrays.copyOfRange(components, 0, components.length - 1);
        assert (Arrays.equals(indices[0], indices[1]));
        int freePointer = 0;
        for (i = 0; i < differentIndicesCount; ++i) {
            tensorIndex = (int)(0xFFFFFFFFL & info[0][i] >> 16);
            int indexIndex = (int)(0xFFFFL & info[0][i] >> 48);
            long contraction = 0xFFFFFFFFFFFF0000L & info[1][i] << 16 | 0xFFFFL & info[0][i];
            if (tensorIndex == -1) {
                this.freeContractions[freePointer++] = contraction;
            } else {
                this.contractions[tensorIndex][indexIndex] = contraction;
            }
            tensorIndex = (int)(0xFFFFFFFFL & info[1][i] >> 16);
            indexIndex = (int)(0xFFFFL & info[1][i] >> 48);
            contraction = 0xFFFFFFFFFFFF0000L & info[0][i] << 16 | 0xFFFFL & info[1][i];
            if (tensorIndex == -1) {
                this.freeContractions[freePointer++] = contraction;
                continue;
            }
            this.contractions[tensorIndex][indexIndex] = contraction;
        }
    }

    public Contraction[] getContractedWith(int position) {
        long[] indicesContractions = this.contractions[position];
        int[] involvedTensors = new int[this.contractions.length];
        Arrays.fill(involvedTensors, -1);
        IntArrayList[] indicesFrom = new IntArrayList[this.contractions.length];
        IntArrayList[] indicesTo = new IntArrayList[this.contractions.length];
        IntArrayList freeIndices = new IntArrayList();
        int tensorsCount = 0;
        for (int i = 0; i < indicesContractions.length; ++i) {
            int tensorIndex = StructureOfContractions.getToTensorIndex(indicesContractions[i]);
            if (tensorIndex == -1) {
                freeIndices.add(i);
                continue;
            }
            if (involvedTensors[tensorIndex] == -1) {
                involvedTensors[tensorIndex] = tensorIndex;
                indicesFrom[tensorIndex] = new IntArrayList();
                indicesTo[tensorIndex] = new IntArrayList();
                ++tensorsCount;
            }
            indicesFrom[tensorIndex].add(i);
            indicesTo[tensorIndex].add(StructureOfContractions.getToIndexId(indicesContractions[i]));
        }
        int f = freeIndices.size() == 0 ? 0 : 1;
        Contraction[] result = new Contraction[tensorsCount + f];
        if (f == 1) {
            result[0] = new Contraction(-1, freeIndices.toArray(), null);
        }
        tensorsCount = f;
        for (int i = 0; i < this.contractions.length; ++i) {
            if (involvedTensors[i] == -1) continue;
            result[tensorsCount++] = new Contraction(involvedTensors[i], indicesFrom[i].toArray(), indicesTo[i].toArray());
        }
        return result;
    }

    public static int getToTensorIndex(long contraction) {
        return (int)(contraction >> 32);
    }

    public static short getToIndexId(long contraction) {
        return (short)(0xFFFFL & contraction >> 16);
    }

    public static short getFromIndexId(long contraction) {
        return (short)(0xFFFFL & contraction);
    }

    private static long packToLong(int tensorIndex, short id, int indexIndex) {
        return (long)tensorIndex << 16 | 0xFFFFL & (long)id | (long)indexIndex << 48;
    }

    private static int[] infoToTensorIndices(long[] info) {
        int[] result = new int[info.length];
        for (int i = 0; i < info.length; ++i) {
            result[i] = (int)(0xFFFFFFFFL & info[i] >> 16);
        }
        return result;
    }

    public static final class Contraction {
        final int tensor;
        final int[] indicesFrom;
        final int[] indicesTo;

        public Contraction(int tensor, int[] indicesFrom, int[] indicesTo) {
            this.tensor = tensor;
            this.indicesFrom = indicesFrom;
            this.indicesTo = indicesTo;
        }

        public int getTensor() {
            return this.tensor;
        }

        public int[] getIndicesFrom() {
            return this.indicesFrom;
        }

        public int[] getIndicesTo() {
            return this.indicesTo;
        }

        public String toString() {
            return "tensor: " + this.tensor + ", indices from: " + Arrays.toString(this.indicesFrom) + ", indices to: " + Arrays.toString(this.indicesTo);
        }
    }
}

