/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.ContextManager;
import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorBuilder;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.utils.EmptyIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;

public class SimpleTensor
extends Tensor {
    protected final SimpleIndices indices;
    protected final int name;

    SimpleTensor(int name, SimpleIndices indices) {
        this.name = name;
        this.indices = indices;
    }

    public int getName() {
        return this.name;
    }

    @Override
    protected int hash() {
        return this.name;
    }

    @Override
    public SimpleIndices getIndices() {
        return this.indices;
    }

    @Override
    public Tensor get(int i) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return 0;
    }

    public String toString(OutputFormat mode, Class clazz) {
        if (!mode.printMatrixIndices && Tensors.isKronecker(this) && !CC.isMetric(IndicesUtils.getType(this.indices.get(0)))) {
            String str = clazz == Sum.class ? "1" : "";
            return this.indices.getFree().size() == 0 ? this.toString0(mode.printMatrixIndices()) : str;
        }
        if (!mode.printMatrixIndices) {
            if (clazz != Product.class) {
                EnumSet<IndexType> matrixTypes = IndicesUtils.nonMetricTypes(this.indices);
                if (matrixTypes.isEmpty()) {
                    return this.toString0(mode);
                }
                ArrayList<IndexType> traces = new ArrayList<IndexType>();
                for (IndexType type : matrixTypes) {
                    SimpleIndices ofType = this.indices.getOfType(type);
                    if (ofType.getFree().size() != 0) continue;
                    traces.add(type);
                }
                if (traces.size() != 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Tr[").append(this.toString0(mode));
                    if (traces.size() != matrixTypes.size()) {
                        sb.append(", ");
                        int i = 0;
                        while (true) {
                            sb.append(traces.get(i));
                            if (i == traces.size() - 1) break;
                            sb.append(", ");
                            ++i;
                        }
                    }
                    sb.append("]");
                    return sb.toString();
                }
                return this.toString0(mode);
            }
            return this.toString0(mode);
        }
        return this.toString0(mode);
    }

    @Override
    public String toString(OutputFormat mode) {
        return this.toString(mode, (Class)null);
    }

    String toString0(OutputFormat mode) {
        boolean external;
        StringBuilder sb = new StringBuilder();
        sb.append(CC.getNameDescriptor(this.name).getName(this.indices, mode));
        if (this.indices.size() == 0) {
            return sb.toString();
        }
        boolean bl = external = mode.is(OutputFormat.WolframMathematica) || mode.is(OutputFormat.Maple);
        if (external) {
            sb.append("[");
        }
        sb.append(this.indices.toString(mode));
        if (external) {
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public Iterator<Tensor> iterator() {
        return EmptyIterator.INSTANCE;
    }

    @Override
    public TensorBuilder getBuilder() {
        return new Builder(this);
    }

    @Override
    public TensorFactory getFactory() {
        return new Factory(this);
    }

    public NameDescriptor getNameDescriptor() {
        return ContextManager.getCurrentContext().getNameDescriptor(this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTensor other = (SimpleTensor)obj;
        if (this.name != other.name) {
            return false;
        }
        return this.indices.equals(other.indices);
    }

    public String getStringName() {
        return CC.current().getNameDescriptor(this.name).getName(this.indices);
    }

    private static final class Factory
    implements TensorFactory {
        private final SimpleTensor st;

        public Factory(SimpleTensor st) {
            this.st = st;
        }

        @Override
        public Tensor create(Tensor ... tensors) {
            if (tensors.length != 0) {
                throw new IllegalArgumentException();
            }
            return this.st;
        }
    }

    private static final class Builder
    implements TensorBuilder {
        private final SimpleTensor tensor;

        public Builder(SimpleTensor tensor) {
            this.tensor = tensor;
        }

        @Override
        public Tensor build() {
            return this.tensor;
        }

        @Override
        public void put(Tensor tensor) {
            throw new IllegalStateException("Can not put to SimpleTensor builder!");
        }

        @Override
        public TensorBuilder clone() {
            return this;
        }
    }
}

