/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.number.Complex;
import cc.redberry.core.number.NumberUtils;
import cc.redberry.core.tensor.PowersContainer;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorFactory;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.ToNumericTransformation;
import cc.redberry.core.utils.TensorUtils;
import java.util.ArrayList;
import java.util.Arrays;

public final class ProductFactory
implements TensorFactory {
    public static final ProductFactory FACTORY = new ProductFactory();

    private ProductFactory() {
    }

    @Override
    public Tensor create(Tensor ... tensors) {
        Object[] indexless;
        Indices indices;
        ProductContent content;
        Product p;
        if (tensors.length == 0) {
            return Complex.ONE;
        }
        if (tensors.length == 1) {
            return tensors[0];
        }
        Complex factor = Complex.ONE;
        IndexlessWrapper indexlessContainer = new IndexlessWrapper();
        DataWrapper dataContainer = new DataWrapper();
        for (Tensor current : tensors) {
            if (current instanceof Complex) {
                factor = factor.multiply((Complex)current);
            } else if (current instanceof Product) {
                p = (Product)current;
                indexlessContainer.add(p.indexlessData);
                dataContainer.add(p.data, p.contentReference.getReferent(), p.indices);
                factor = factor.multiply(p.factor);
            } else if (current.getIndices().size() == 0) {
                indexlessContainer.add(current);
            } else {
                dataContainer.add(current);
            }
            if (!factor.isNaN()) continue;
            return factor;
        }
        if (NumberUtils.isZeroOrIndeterminate(factor)) {
            return factor;
        }
        if (factor.isNumeric()) {
            ArrayList<Tensor> newTensors = new ArrayList<Tensor>();
            factor = Complex.ONE;
            for (Tensor current : tensors) {
                if ((current = ToNumericTransformation.toNumeric(current)) instanceof Complex) {
                    factor = factor.multiply((Complex)current);
                    continue;
                }
                newTensors.add(current);
            }
            if (newTensors.isEmpty()) {
                return factor;
            }
            indexlessContainer = new IndexlessWrapper();
            dataContainer = new DataWrapper();
            for (Tensor current : newTensors) {
                if (current instanceof Product) {
                    p = (Product)current;
                    indexlessContainer.add(p.indexlessData);
                    dataContainer.add(p.data, p.contentReference.getReferent(), p.indices);
                    factor = factor.multiply(p.factor);
                    continue;
                }
                if (current.getIndices().size() == 0) {
                    indexlessContainer.add(current);
                    continue;
                }
                dataContainer.add(current);
            }
        }
        Object[] data = dataContainer.list.toArray(new Tensor[dataContainer.list.size()]);
        if (dataContainer.count == 1) {
            content = dataContainer.content;
            indices = dataContainer.indices;
            if (indices == null) {
                assert (dataContainer.list.size() == 1);
                indices = IndicesFactory.create(((Tensor)dataContainer.list.get(0)).getIndices());
            }
        } else {
            content = null;
            Arrays.sort(data);
            IndicesBuilder builder = new IndicesBuilder();
            for (int i = dataContainer.list.size() - 1; i >= 0; --i) {
                builder.append((Tensor)dataContainer.list.get(i));
            }
            indices = builder.getIndices();
        }
        if (indexlessContainer.count == 0) {
            indexless = new Tensor[]{};
        } else if (indexlessContainer.count == 1) {
            indexless = indexlessContainer.list.toArray(new Tensor[indexlessContainer.list.size()]);
        } else {
            PowersContainer powersContainer = new PowersContainer(indexlessContainer.list.size());
            ArrayList<Tensor> indexlessArray = new ArrayList<Tensor>();
            for (int i = indexlessContainer.list.size() - 1; i >= 0; --i) {
                Tensor tensor = (Tensor)indexlessContainer.list.get(i);
                if (TensorUtils.isSymbolic(tensor)) {
                    powersContainer.put(tensor);
                    continue;
                }
                indexlessArray.add(tensor);
            }
            for (Tensor t : powersContainer) {
                if (t instanceof Product) {
                    factor = factor.multiply(((Product)t).factor);
                    indexlessArray.ensureCapacity(t.size());
                    for (Tensor multiplier : ((Product)t).indexlessData) {
                        indexlessArray.add(multiplier);
                    }
                    continue;
                }
                if (t instanceof Complex) {
                    if (!NumberUtils.isZeroOrIndeterminate(factor = factor.multiply((Complex)t))) continue;
                    return factor;
                }
                indexlessArray.add(t);
            }
            if (powersContainer.isSign()) {
                factor = factor.negate();
            }
            indexless = indexlessArray.toArray(new Tensor[indexlessArray.size()]);
            Arrays.sort(indexless);
        }
        if (data.length == 0 && indexless.length == 0) {
            return factor;
        }
        if (factor.isOne()) {
            if (data.length == 1 && indexless.length == 0) {
                return data[0];
            }
            if (data.length == 0 && indexless.length == 1) {
                return indexless[0];
            }
        }
        if (factor.isMinusOne()) {
            Sum s = null;
            if (indexless.length == 1 && data.length == 0 && indexless[0] instanceof Sum) {
                s = (Sum)indexless[0];
            }
            if (indexless.length == 0 && data.length == 1 && data[0] instanceof Sum) {
                s = (Sum)data[0];
            }
            if (s != null) {
                Tensor[] sumData = (Tensor[])s.data.clone();
                for (int i = sumData.length - 1; i >= 0; --i) {
                    sumData[i] = Tensors.negate(sumData[i]);
                }
                return new Sum(s.indices, sumData, s.hashCode());
            }
        }
        return new Product(factor, (Tensor[])indexless, (Tensor[])data, content, indices);
    }

    private static final class DataWrapper
    extends ListWrapper {
        private ProductContent content;
        private Indices indices;

        private DataWrapper() {
        }

        void add(Tensor[] t, ProductContent content, Indices indices) {
            if (t.length != 0) {
                this.list.addAll(Arrays.asList(t));
                this.content = content;
                this.indices = indices;
                ++this.count;
            }
        }
    }

    private static final class IndexlessWrapper
    extends ListWrapper {
        private IndexlessWrapper() {
        }

        void add(Tensor[] t) {
            if (t.length != 0) {
                this.list.addAll(Arrays.asList(t));
                ++this.count;
            }
        }
    }

    private static class ListWrapper {
        final ArrayList<Tensor> list = new ArrayList();
        int count = 0;

        private ListWrapper() {
        }

        void add(Tensor t) {
            this.list.add(t);
            ++this.count;
        }
    }
}

