/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.tensor;

import cc.redberry.core.context.CC;
import cc.redberry.core.indices.IndicesFactory;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.SumFactory;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.expand.ExpandUtils;
import cc.redberry.core.utils.TensorUtils;
import java.util.ArrayList;

public final class FastTensors {
    private FastTensors() {
    }

    public static Tensor multiplySumElementsOnFactor(Sum sum, Tensor factor) {
        return FastTensors.multiplySumElementsOnFactor(sum, factor, new Transformation[0]);
    }

    public static Tensor multiplySumElementsOnFactorAndExpand(Sum sum, Tensor factor) {
        if (factor instanceof Sum && factor.getIndices().size() != 0) {
            throw new IllegalArgumentException();
        }
        return FastTensors.multiplySumElementsOnFactor(sum, factor, new Transformation[]{ExpandUtils.expandIndexlessSubproduct});
    }

    private static Tensor multiplySumElementsOnFactor(Sum sum, Tensor factor, Transformation[] transformations) {
        if (TensorUtils.isZero(factor)) {
            return Complex.ZERO;
        }
        if (TensorUtils.isOne(factor)) {
            return sum;
        }
        if (TensorUtils.haveIndicesIntersections(sum, factor) || sum.indices.size() == 0 && factor.getIndices().size() != 0) {
            return FastTensors.multiplyWithBuilder(sum, factor, transformations);
        }
        return FastTensors.multiplyWithFactory(sum, factor, transformations);
    }

    private static Tensor multiplyWithBuilder(Sum sum, Tensor factor, Transformation ... transformations) {
        SumBuilder sb = new SumBuilder(sum.size());
        for (Tensor t : sum) {
            sb.put(Transformation.Util.applySequentially(Tensors.multiply(t, factor), transformations));
        }
        return sb.build();
    }

    private static Tensor multiplyWithFactory(Sum sum, Tensor factor, Transformation ... transformations) {
        ArrayList<Tensor> newSumData = new ArrayList<Tensor>(sum.size());
        boolean reduced = false;
        for (int i = sum.size() - 1; i >= 0; --i) {
            Tensor temp = Transformation.Util.applySequentially(Tensors.multiply(factor, sum.get(i)), transformations);
            if (TensorUtils.isZero(temp)) continue;
            newSumData.add(temp);
            if (reduced || !FastTensors.isReduced(sum.get(i), factor, temp)) continue;
            reduced = true;
        }
        if (newSumData.size() == 0) {
            return Complex.ZERO;
        }
        if (newSumData.size() == 1) {
            return (Tensor)newSumData.get(0);
        }
        Tensor[] data = newSumData.toArray(new Tensor[newSumData.size()]);
        if (reduced) {
            return SumFactory.FACTORY.create(data);
        }
        return new Sum(data, IndicesFactory.create(((Tensor)newSumData.get(0)).getIndices().getFree()));
    }

    @Deprecated
    public static Tensor multiplySumElementsOnFactors(Sum sum) {
        Tensor[] newSumData = new Tensor[sum.size()];
        for (int i = newSumData.length - 1; i >= 0; --i) {
            newSumData[i] = Tensors.multiply(CC.generateNewSymbol(), sum.get(i));
        }
        return new Sum(newSumData, IndicesFactory.create(newSumData[0].getIndices().getFree()));
    }

    private static boolean isReduced(Tensor initial, Tensor factor, Tensor result) {
        return initial instanceof Product && !(result instanceof Product);
    }
}

